/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.command.commands;

import com.github.cubiomes.CanyonCarverConfig;
import com.github.cubiomes.CaveCarverConfig;
import com.github.cubiomes.Cubiomes;
import com.github.cubiomes.Generator;
import com.github.cubiomes.OreConfig;
import com.github.cubiomes.OreVeinParameters;
import com.github.cubiomes.Pos3;
import com.github.cubiomes.Pos3List;
import com.github.cubiomes.SurfaceNoise;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import dev.xpple.seedmapper.command.CommandExceptions;
import dev.xpple.seedmapper.command.CustomClientCommandSource;
import dev.xpple.seedmapper.command.arguments.BlockArgument;
import dev.xpple.seedmapper.command.arguments.CanyonCarverArgument;
import dev.xpple.seedmapper.command.arguments.CaveCarverArgument;
import dev.xpple.seedmapper.command.commands.LocateCommand;
import dev.xpple.seedmapper.config.Configs;
import dev.xpple.seedmapper.feature.OreTypes;
import dev.xpple.seedmapper.render.RenderManager;
import dev.xpple.seedmapper.thread.LocatorThreadHelper;
import dev.xpple.seedmapper.util.ChatBuilder;
import dev.xpple.seedmapper.util.ComponentUtils;
import dev.xpple.seedmapper.util.SpiralLoop;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.ToIntBiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import org.jetbrains.annotations.Nullable;

public class HighlightCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sm:highlight").then(ClientCommandManager.literal((String)"block").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"block", (ArgumentType)BlockArgument.block()).executes(ctx -> HighlightCommand.highlightBlock(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()), BlockArgument.getBlock((CommandContext<FabricClientCommandSource>)ctx, "block")))).then(ClientCommandManager.argument((String)"chunks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)20)).executes(ctx -> LocatorThreadHelper.submit(() -> HighlightCommand.highlightBlock(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()), BlockArgument.getBlock((CommandContext<FabricClientCommandSource>)ctx, "block"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"chunks")))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"orevein").executes(ctx -> LocatorThreadHelper.submit(() -> HighlightCommand.highlightOreVein(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()))))).then(ClientCommandManager.argument((String)"chunks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)20)).executes(ctx -> LocatorThreadHelper.submit(() -> HighlightCommand.highlightOreVein(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"chunks"))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"canyon").requires(fabricClientCommandSource -> Configs.DevMode)).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"canyon", (ArgumentType)CanyonCarverArgument.canyonCarver()).executes(ctx -> HighlightCommand.highlightCanyon(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()), CanyonCarverArgument.getCanyonCarver((CommandContext<FabricClientCommandSource>)ctx, "canyon")))).then(ClientCommandManager.argument((String)"chunks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)20)).executes(ctx -> HighlightCommand.highlightCanyon(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()), CanyonCarverArgument.getCanyonCarver((CommandContext<FabricClientCommandSource>)ctx, "canyon"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"chunks"))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cave").requires(fabricClientCommandSource -> Configs.DevMode)).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"cave", (ArgumentType)CaveCarverArgument.caveCarver()).executes(ctx -> HighlightCommand.highlightCave(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()), CaveCarverArgument.getCaveCarver((CommandContext<FabricClientCommandSource>)ctx, "cave")))).then(ClientCommandManager.argument((String)"chunks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)20)).executes(ctx -> LocatorThreadHelper.submit(() -> HighlightCommand.highlightCave(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()), CaveCarverArgument.getCaveCarver((CommandContext<FabricClientCommandSource>)ctx, "cave"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"chunks"))))))));
    }

    private static int highlightBlock(CustomClientCommandSource source, Pair<Integer, Integer> blockPair) throws CommandSyntaxException {
        return HighlightCommand.highlightBlock(source, blockPair, 0);
    }

    private static int highlightBlock(CustomClientCommandSource source, Pair<Integer, Integer> blockPair, int chunkRange) throws CommandSyntaxException {
        int version = source.getVersion();
        int dimension = source.getDimension();
        long seed = (Long)source.getSeed().getSecond();
        try (Arena arena = Arena.ofConfined();){
            MemorySegment generator = Generator.allocate(arena);
            Cubiomes.setupGenerator(generator, version, 0);
            Cubiomes.applySeed(generator, dimension, seed);
            MemorySegment surfaceNoise = SurfaceNoise.allocate(arena);
            Cubiomes.initSurfaceNoise(surfaceNoise, dimension, seed);
            class_1923 center = new class_1923(class_2338.method_49638((class_2374)source.getPosition()));
            int[] count = new int[]{0};
            SpiralLoop.spiral(center.field_9181, center.field_9180, chunkRange, (chunkX, chunkZ) -> {
                class_2818 chunk = source.getWorld().method_2935().method_2857(chunkX, chunkZ, class_2806.field_12803, false);
                boolean doAirCheck = Configs.OreAirCheck && chunk != null;
                HashMap generatedOres = new HashMap();
                List<Integer> biomes = version <= Cubiomes.MC_1_17() ? List.of(Integer.valueOf(Cubiomes.getBiomeForOreGen(generator, chunkX, chunkZ, 0))) : IntStream.of(-30, 64, 120).map(y2 -> Cubiomes.getBiomeForOreGen(generator, chunkX, chunkZ, y2)).boxed().toList();
                OreTypes.ORE_TYPES.stream().filter(oreType -> biomes.stream().anyMatch(biome -> Cubiomes.isViableOreBiome(version, oreType, biome) != 0)).mapMulti((oreType, consumer) -> {
                    MemorySegment oreConfig = OreConfig.allocate(arena);
                    if (Cubiomes.getOreConfig(oreType, version, (Integer)biomes.getFirst(), oreConfig) != 0) {
                        consumer.accept(oreConfig);
                    }
                }).sorted(Comparator.comparingInt(OreConfig::index)).forEachOrdered(oreConfig -> {
                    int oreBlock = OreConfig.oreBlock(oreConfig);
                    int numReplaceBlocks = OreConfig.numReplaceBlocks(oreConfig);
                    MemorySegment replaceBlocks = OreConfig.replaceBlocks(oreConfig);
                    MemorySegment pos3List = Cubiomes.generateOres(arena, generator, surfaceNoise, oreConfig, chunkX, chunkZ);
                    int size = Pos3List.size(pos3List);
                    MemorySegment pos3s = Pos3List.pos3s(pos3List);
                    try {
                        for (int i = 0; i < size; ++i) {
                            MemorySegment pos3 = Pos3.asSlice(pos3s, i);
                            class_2338 pos = new class_2338(Pos3.x(pos3), Pos3.y(pos3), Pos3.z(pos3));
                            if (doAirCheck && chunk.method_8320(pos).method_26215()) continue;
                            Integer previouslyGeneratedOre = (Integer)generatedOres.get(pos);
                            if (previouslyGeneratedOre != null) {
                                boolean contains = false;
                                for (int j = 0; j < numReplaceBlocks; ++j) {
                                    int replaceBlock = replaceBlocks.getAtIndex(Cubiomes.C_INT, (long)j);
                                    if (replaceBlock != previouslyGeneratedOre) continue;
                                    contains = true;
                                    break;
                                }
                                if (!contains) continue;
                            }
                            generatedOres.put(pos, oreBlock);
                        }
                    }
                    finally {
                        Cubiomes.freePos3List(pos3List);
                    }
                });
                int block = (Integer)blockPair.getFirst();
                int colour = (Integer)blockPair.getSecond();
                List<class_2338> blockOres = generatedOres.entrySet().stream().filter(entry -> (Integer)entry.getValue() == block).map(Map.Entry::getKey).toList();
                count[0] = count[0] + blockOres.size();
                source.getClient().method_63588(() -> {
                    RenderManager.drawBoxes(blockOres, colour);
                    source.sendFeedback((class_2561)class_2561.method_43469((String)"command.highlight.block.chunkSuccess", (Object[])new Object[]{ChatBuilder.accent(String.valueOf(blockOres.size())), ComponentUtils.formatXZ(chunkX, chunkZ)}));
                });
                return false;
            });
            source.getClient().method_63588(() -> source.sendFeedback((class_2561)class_2561.method_43469((String)"command.highlight.block.success", (Object[])new Object[]{ChatBuilder.accent(String.valueOf(count[0]))})));
            int n = count[0];
            return n;
        }
    }

    private static int highlightOreVein(CustomClientCommandSource source) throws CommandSyntaxException {
        return HighlightCommand.highlightOreVein(source, 0);
    }

    private static int highlightOreVein(CustomClientCommandSource source, int chunkRange) throws CommandSyntaxException {
        int version = source.getVersion();
        long seed = (Long)source.getSeed().getSecond();
        try (Arena arena = Arena.ofConfined();){
            MemorySegment parameters = OreVeinParameters.allocate(arena);
            if (Cubiomes.initOreVeinNoise(parameters, seed, version) == 0) {
                throw CommandExceptions.ORE_VEIN_WRONG_VERSION_EXCEPTION.create();
            }
            class_1923 center = new class_1923(class_2338.method_49638((class_2374)source.getPosition()));
            HashMap blocks = new HashMap();
            SpiralLoop.spiral(center.field_9181, center.field_9180, chunkRange, (chunkX, chunkZ) -> {
                class_2818 chunk = source.getWorld().method_2935().method_2857(chunkX, chunkZ, class_2806.field_12803, false);
                boolean doAirCheck = Configs.OreAirCheck && chunk != null;
                int minX = chunkX << 4;
                int minZ = chunkZ << 4;
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (int y2 = -60; y2 <= 50; ++y2) {
                            int block = Cubiomes.getOreVeinBlockAt(minX + x, y2, minZ + z, parameters);
                            if (block == -1) continue;
                            class_2338 pos = new class_2338(minX + x, y2, minZ + z);
                            if (doAirCheck && chunk.method_8320(pos).method_26215()) continue;
                            blocks.put(pos, block);
                        }
                    }
                }
                return false;
            });
            int[] count = new int[]{0};
            blocks.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList()))).forEach((block, positions) -> {
                if (block == Cubiomes.GRANITE() || block == Cubiomes.TUFF()) {
                    return;
                }
                count[0] = count[0] + positions.size();
                int colour = (Integer)BlockArgument.BLOCKS.values().stream().filter(pair -> Objects.equals(block, pair.getFirst())).findAny().orElseThrow().getSecond();
                RenderManager.drawBoxes(positions, colour);
                if (block == Cubiomes.RAW_COPPER_BLOCK() || block == Cubiomes.RAW_IRON_BLOCK()) {
                    source.getClient().method_63588(() -> source.sendFeedback((class_2561)class_2561.method_43469((String)"command.highlight.oreVein.rawBlocks", (Object[])new Object[]{ComponentUtils.formatXYZCollection(positions)})));
                }
            });
            source.getClient().method_63588(() -> source.sendFeedback((class_2561)class_2561.method_43469((String)"command.highlight.oreVein.success", (Object[])new Object[]{ChatBuilder.accent(String.valueOf(count[0]))})));
            int n = count[0];
            return n;
        }
    }

    private static int highlightCanyon(CustomClientCommandSource source, int canyonCarver) throws CommandSyntaxException {
        return HighlightCommand.highlightCanyon(source, canyonCarver, 0);
    }

    private static int highlightCanyon(CustomClientCommandSource source, int canyonCarver, int chunkRange) throws CommandSyntaxException {
        long seed = (Long)source.getSeed().getSecond();
        int dimension = source.getDimension();
        int version = source.getVersion();
        try (Arena arena = Arena.ofConfined();){
            MemorySegment ccc = CanyonCarverConfig.allocate(arena);
            if (Cubiomes.getCanyonCarverConfig(canyonCarver, version, ccc) == 0) {
                throw CommandExceptions.CANYON_WRONG_VERSION_EXCEPTION.create();
            }
            if (CanyonCarverConfig.dim(ccc) != dimension) {
                throw CommandExceptions.INVALID_DIMENSION_EXCEPTION.create();
            }
            ToIntBiFunction<Integer, Integer> biomeFunction = LocateCommand.getCarverBiomeFunction(arena, seed, dimension, version);
            int n = HighlightCommand.highlightCarver(source, chunkRange, (chunkX, chunkZ) -> {
                int biome = biomeFunction.applyAsInt((Integer)chunkX, (Integer)chunkZ);
                if (Cubiomes.isViableCanyonBiome(canyonCarver, biome) == 0) {
                    return null;
                }
                return Cubiomes.carveCanyon(arena, seed, chunkX, chunkZ, ccc);
            });
            return n;
        }
    }

    private static int highlightCave(CustomClientCommandSource source, int caveCarver) throws CommandSyntaxException {
        return HighlightCommand.highlightCave(source, caveCarver, 0);
    }

    private static int highlightCave(CustomClientCommandSource source, int caveCarver, int chunkRange) throws CommandSyntaxException {
        long seed = (Long)source.getSeed().getSecond();
        int dimension = source.getDimension();
        int version = source.getVersion();
        try (Arena arena = Arena.ofConfined();){
            MemorySegment ccc = CaveCarverConfig.allocate(arena);
            if (Cubiomes.getCaveCarverConfig(caveCarver, version, -1, ccc) == 0) {
                throw CommandExceptions.CAVE_WRONG_VERSION_EXCEPTION.create();
            }
            if (CaveCarverConfig.dim(ccc) != dimension) {
                throw CommandExceptions.INVALID_DIMENSION_EXCEPTION.create();
            }
            ToIntBiFunction<Integer, Integer> biomeFunction = LocateCommand.getCarverBiomeFunction(arena, seed, dimension, version);
            int n = HighlightCommand.highlightCarver(source, chunkRange, (chunkX, chunkZ) -> {
                int biome = biomeFunction.applyAsInt((Integer)chunkX, (Integer)chunkZ);
                if (Cubiomes.isViableCaveBiome(caveCarver, biome) == 0) {
                    return null;
                }
                return Cubiomes.carveCave(arena, seed, chunkX, chunkZ, ccc);
            });
            return n;
        }
    }

    private static int highlightCarver(CustomClientCommandSource source, int chunkRange, BiFunction<Integer, Integer, @Nullable MemorySegment> carverFunction) {
        class_1923 center = new class_1923(class_2338.method_49638((class_2374)source.getPosition()));
        HashSet<class_2338> blocks = new HashSet<class_2338>();
        SpiralLoop.spiral(center.field_9181, center.field_9180, chunkRange, (chunkX, chunkZ) -> {
            MemorySegment pos3List = (MemorySegment)carverFunction.apply(chunkX, chunkZ);
            if (pos3List == null) {
                return false;
            }
            int size = Pos3List.size(pos3List);
            MemorySegment pos3s = Pos3List.pos3s(pos3List);
            for (int i = 0; i < size; ++i) {
                MemorySegment pos3 = Pos3.asSlice(pos3s, i);
                blocks.add(new class_2338(Pos3.x(pos3), Pos3.y(pos3), Pos3.z(pos3)));
            }
            return false;
        });
        RenderManager.drawBoxes(blocks, -65536);
        source.getClient().method_63588(() -> source.sendFeedback((class_2561)class_2561.method_43469((String)"command.highlight.carver.success", (Object[])new Object[]{ChatBuilder.accent(String.valueOf(blocks.size()))})));
        return blocks.size();
    }
}

