/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.command.commands;

import com.github.cubiomes.CanyonCarverConfig;
import com.github.cubiomes.Cubiomes;
import com.github.cubiomes.Generator;
import com.github.cubiomes.ItemStack;
import com.github.cubiomes.LootTableContext;
import com.github.cubiomes.OreVeinParameters;
import com.github.cubiomes.Piece;
import com.github.cubiomes.Pos;
import com.github.cubiomes.Pos3;
import com.github.cubiomes.StrongholdIter;
import com.github.cubiomes.StructureConfig;
import com.github.cubiomes.StructureSaltConfig;
import com.github.cubiomes.StructureVariant;
import com.github.cubiomes.SurfaceNoise;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.xpple.seedmapper.command.CommandExceptions;
import dev.xpple.seedmapper.command.CustomClientCommandSource;
import dev.xpple.seedmapper.command.arguments.BiomeArgument;
import dev.xpple.seedmapper.command.arguments.CanyonCarverArgument;
import dev.xpple.seedmapper.command.arguments.ItemAndEnchantmentsPredicateArgument;
import dev.xpple.seedmapper.command.arguments.StructurePredicateArgument;
import dev.xpple.seedmapper.feature.StructureChecks;
import dev.xpple.seedmapper.feature.StructureVariantFeedbackHelper;
import dev.xpple.seedmapper.seedmap.SeedMapScreen;
import dev.xpple.seedmapper.thread.LocatorThreadHelper;
import dev.xpple.seedmapper.util.ChatBuilder;
import dev.xpple.seedmapper.util.ComponentUtils;
import dev.xpple.seedmapper.util.SpiralLoop;
import dev.xpple.seedmapper.util.SpiralSpliterator;
import dev.xpple.seedmapper.util.TwoDTree;
import dev.xpple.seedmapper.util.WorldIdentifier;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.ToIntBiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2919;
import net.minecraft.class_4076;
import net.minecraft.class_5819;

public class LocateCommand {
    private static final int BIOME_SEARCH_RADIUS = 6400;
    public static final Set<Integer> LOOT_SUPPORTED_STRUCTURES = Set.of(Cubiomes.Treasure(), Cubiomes.Desert_Pyramid(), Cubiomes.End_City(), Cubiomes.Igloo(), Cubiomes.Jungle_Pyramid(), Cubiomes.Ruined_Portal(), Cubiomes.Ruined_Portal_N(), Cubiomes.Fortress(), Cubiomes.Bastion(), Cubiomes.Outpost(), Cubiomes.Shipwreck());

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sm:locate").then(ClientCommandManager.literal((String)"biome").then(ClientCommandManager.argument((String)"biome", (ArgumentType)BiomeArgument.biome()).executes(ctx -> LocatorThreadHelper.submit(() -> LocateCommand.locateBiome(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()), BiomeArgument.getBiome((CommandContext<FabricClientCommandSource>)ctx, "biome"))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"feature").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"structure", (ArgumentType)StructurePredicateArgument.structurePredicate()).executes(ctx -> LocatorThreadHelper.submit(() -> LocateCommand.locateStructure(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()), StructurePredicateArgument.getStructurePredicate((CommandContext<FabricClientCommandSource>)ctx, "structure"))))).then(ClientCommandManager.argument((String)"variantdata", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> LocatorThreadHelper.submit(() -> LocateCommand.locateStructure(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()), StructurePredicateArgument.getStructurePredicate((CommandContext<FabricClientCommandSource>)ctx, "structure"), BoolArgumentType.getBool((CommandContext)ctx, (String)"variantdata"))))))).then(ClientCommandManager.literal((String)"stronghold").executes(ctx -> LocatorThreadHelper.submit(() -> LocateCommand.locateStronghold(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()))))))).then(ClientCommandManager.literal((String)"loot").then(ClientCommandManager.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(ClientCommandManager.argument((String)"item", (ArgumentType)ItemAndEnchantmentsPredicateArgument.itemAndEnchantments()).executes(ctx -> LocatorThreadHelper.submit(() -> LocateCommand.locateLoot(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), ItemAndEnchantmentsPredicateArgument.getItemAndEnchantments((CommandContext<FabricClientCommandSource>)ctx, "item")))))))).then(ClientCommandManager.literal((String)"slimechunk").executes(ctx -> LocateCommand.locateSlimeChunk(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()))))).then(ClientCommandManager.literal((String)"spawn").executes(ctx -> LocateCommand.locateSpawn(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"orevein").then(ClientCommandManager.literal((String)"copper").executes(ctx -> LocatorThreadHelper.submit(() -> LocateCommand.locateOreVein(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()), true))))).then(ClientCommandManager.literal((String)"iron").executes(ctx -> LocatorThreadHelper.submit(() -> LocateCommand.locateOreVein(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()), false)))))).then(ClientCommandManager.literal((String)"canyon").executes(ctx -> LocatorThreadHelper.submit(() -> LocateCommand.locateCanyon(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()))))));
    }

    private static int locateBiome(CustomClientCommandSource source, int biome) throws CommandSyntaxException {
        int dimension = source.getDimension();
        if (Cubiomes.getDimension(biome) != dimension) {
            throw CommandExceptions.INVALID_DIMENSION_EXCEPTION.create();
        }
        try (Arena arena = Arena.ofConfined();){
            MemorySegment generator = Generator.allocate(arena);
            Cubiomes.setupGenerator(generator, source.getVersion(), 0);
            Cubiomes.applySeed(generator, dimension, (Long)source.getSeed().getSecond());
            class_2338 center = class_2338.method_49638((class_2374)source.getPosition());
            SpiralLoop.Coordinate pos = SpiralLoop.spiral(center.method_10263(), center.method_10260(), 6400, 32, (x, z) -> Cubiomes.getBiomeAt(generator, 1, x, 63, z) == biome);
            if (pos == null) {
                throw CommandExceptions.NO_BIOME_FOUND_EXCEPTION.create((Object)6400);
            }
            source.getClient().method_63588(() -> source.sendFeedback((class_2561)class_2561.method_43469((String)"command.locate.biome.foundAt", (Object[])new Object[]{ComponentUtils.formatXZ(pos.x(), pos.z())})));
            int n = 1;
            return n;
        }
    }

    private static int locateStructure(CustomClientCommandSource source, StructurePredicateArgument.StructureAndPredicate structureAndPredicate) throws CommandSyntaxException {
        return LocateCommand.locateStructure(source, structureAndPredicate, false);
    }

    private static int locateStructure(CustomClientCommandSource source, StructurePredicateArgument.StructureAndPredicate structureAndPredicate, boolean variantData) throws CommandSyntaxException {
        try (Arena arena = Arena.ofConfined();){
            int numPieces;
            int version = source.getVersion();
            int dimension = source.getDimension();
            int structure = structureAndPredicate.structure();
            MemorySegment structureConfig = StructureConfig.allocate(arena);
            int config = Cubiomes.getStructureConfig(structure, version, structureConfig);
            if (config == 0) {
                throw CommandExceptions.INCOMPATIBLE_PARAMETERS_EXCEPTION.create();
            }
            if (StructureConfig.dim(structureConfig) != dimension) {
                throw CommandExceptions.INVALID_DIMENSION_EXCEPTION.create();
            }
            long seed = (Long)source.getSeed().getSecond();
            MemorySegment generator = Generator.allocate(arena);
            Cubiomes.setupGenerator(generator, version, 0);
            Cubiomes.applySeed(generator, dimension, seed);
            MemorySegment surfaceNoise = SurfaceNoise.allocate(arena);
            Cubiomes.initSurfaceNoise(surfaceNoise, dimension, seed);
            StructureChecks.GenerationCheck generationCheck = StructureChecks.getGenerationCheck(structure);
            StructurePredicateArgument.PiecesPredicate piecesPredicate = structureAndPredicate.piecesPredicate();
            StructureChecks.PiecesPredicateCheck piecesPredicateCheck = StructureChecks.getPiecesPredicateCheck(structure);
            StructurePredicateArgument.VariantPredicate variantPredicate = structureAndPredicate.variantPredicate();
            StructureChecks.VariantPredicateCheck variantPredicateCheck = StructureChecks.getVariantPredicateCheck(structure);
            class_2338 center = class_2338.method_49638((class_2374)source.getPosition());
            int regionSize = StructureConfig.regionSize(structureConfig) << 4;
            MemorySegment structurePos = Pos.allocate(arena);
            MemorySegment pieces = Piece.allocateArray(StructureChecks.MAX_END_CITY_AND_FORTRESS_PIECES, arena);
            MemorySegment structureVariant = StructureVariant.allocate(arena);
            SpiralLoop.Coordinate pos = SpiralLoop.spiral(center.method_10263() / regionSize, center.method_10260() / regionSize, 30000000 / regionSize, (x, z) -> {
                if (!generationCheck.check(generator, surfaceNoise, x, z, structurePos)) {
                    return false;
                }
                if (!piecesPredicateCheck.check(piecesPredicate, pieces, generator, structurePos)) {
                    return false;
                }
                return variantPredicateCheck.check(variantPredicate, structureVariant, generator, structurePos);
            });
            if (pos == null) {
                throw CommandExceptions.NO_STRUCTURE_FOUND_EXCEPTION.create((Object)30000000);
            }
            int structureXPos = Pos.x(structurePos);
            int structureZPos = Pos.z(structurePos);
            source.getClient().method_63588(() -> source.sendFeedback((class_2561)class_2561.method_43469((String)"command.locate.feature.structure.foundAt", (Object[])new Object[]{ComponentUtils.formatXZ(structureXPos, structureZPos)})));
            if (structure == Cubiomes.End_City()) {
                numPieces = Cubiomes.getEndCityPieces(pieces, seed, structureXPos >> 4, structureZPos >> 4);
                IntStream.range(0, numPieces).mapToObj(i -> Piece.asSlice(pieces, i)).filter(piece -> Piece.type(piece) == Cubiomes.END_SHIP()).findAny().map(Piece::pos).map(city -> new class_2338(Pos3.x(city), Pos3.y(city) + 60, Pos3.z(city))).ifPresent(city -> source.getClient().method_63588(() -> source.sendFeedback((class_2561)class_2561.method_43470((String)" - ").method_10852((class_2561)class_2561.method_43469((String)"command.locate.feature.structure.endCity.hasShip", (Object[])new Object[]{ComponentUtils.formatXYZ(city.method_10263(), city.method_10264(), city.method_10260())})))));
            } else if (structure == Cubiomes.Fortress()) {
                numPieces = Cubiomes.getFortressPieces(pieces, StructureChecks.MAX_END_CITY_AND_FORTRESS_PIECES, version, seed, structureXPos >> 4, structureZPos >> 4);
                IntStream.range(0, numPieces).mapToObj(i -> Piece.asSlice(pieces, i)).filter(piece -> Piece.type(piece) == Cubiomes.BRIDGE_SPAWNER()).map(Piece::pos).map(monsterThrone -> new class_2338(Pos3.x(monsterThrone), Pos3.y(monsterThrone) + 10, Pos3.z(monsterThrone))).forEach(spawnerPos -> source.getClient().method_63588(() -> source.sendFeedback((class_2561)class_2561.method_43470((String)" - ").method_10852((class_2561)class_2561.method_43469((String)"command.locate.feature.structure.fortress.hasSpawner", (Object[])new Object[]{ComponentUtils.formatXYZ(spawnerPos.method_10263(), spawnerPos.method_10264(), spawnerPos.method_10260())})))));
            }
            if (!variantData) {
                numPieces = 1;
                return numPieces;
            }
            int biome = Cubiomes.getBiomeAt(generator, 4, structureXPos >> 2, 80, structureZPos >> 2);
            Cubiomes.getVariant(structureVariant, structure, version, seed, structureXPos, structureZPos, biome);
            List<class_2561> components = StructureVariantFeedbackHelper.get(structure, structureVariant);
            if (components.isEmpty()) {
                int n = 1;
                return n;
            }
            source.getClient().method_63588(() -> source.sendFeedback((class_2561)class_2561.method_43471((String)"command.locate.feature.structure.variantData")));
            components.forEach(component -> source.getClient().method_63588(() -> source.sendFeedback((class_2561)class_2561.method_43470((String)" - ").method_10852(component))));
            int n = 1;
            return n;
        }
    }

    private static int locateStronghold(CustomClientCommandSource source) throws CommandSyntaxException {
        int dimension = source.getDimension();
        if (dimension != Cubiomes.DIM_OVERWORLD()) {
            throw CommandExceptions.INVALID_DIMENSION_EXCEPTION.create();
        }
        int version = source.getVersion();
        long seed = (Long)source.getSeed().getSecond();
        class_2338 position = class_2338.method_49638((class_2374)source.getPosition());
        TwoDTree tree = (TwoDTree)SeedMapScreen.strongholdDataCache.computeIfAbsent((Object)new WorldIdentifier(seed, dimension, version), object -> LocateCommand.calculateStrongholds(seed, dimension, version));
        class_2338 pos = tree.nearestTo(position.method_33096(0));
        source.getClient().method_63588(() -> source.sendFeedback((class_2561)class_2561.method_43469((String)"command.locate.feature.stronghold.success", (Object[])new Object[]{ComponentUtils.formatXZ(pos.method_10263(), pos.method_10260())})));
        return 1;
    }

    public static TwoDTree calculateStrongholds(long seed, int dimension, int version) {
        TwoDTree tree = new TwoDTree();
        try (Arena arena = Arena.ofConfined();){
            MemorySegment strongholdIter = StrongholdIter.allocate(arena);
            Cubiomes.initFirstStronghold(arena, strongholdIter, version, seed);
            MemorySegment generator = Generator.allocate(arena);
            Cubiomes.setupGenerator(generator, version, 0);
            Cubiomes.applySeed(generator, dimension, seed);
            int count = version <= Cubiomes.MC_1_8() ? 3 : 128;
            for (int i = 0; i < count; ++i) {
                if (Cubiomes.nextStronghold(strongholdIter, generator) == 0) {
                    break;
                }
                MemorySegment pos = StrongholdIter.pos(strongholdIter);
                tree.insert(new class_2338(Pos.x(pos), 0, Pos.z(pos)));
            }
        }
        return tree;
    }

    private static int locateSlimeChunk(CustomClientCommandSource source) throws CommandSyntaxException {
        if (source.getDimension() != Cubiomes.DIM_OVERWORLD()) {
            throw CommandExceptions.INVALID_DIMENSION_EXCEPTION.create();
        }
        long seed = (Long)source.getSeed().getSecond();
        class_1923 center = new class_1923(class_2338.method_49638((class_2374)source.getPosition()));
        SpiralLoop.Coordinate pos = SpiralLoop.spiral(center.field_9181, center.field_9180, 6400, (x, z) -> {
            class_5819 random = class_2919.method_12662((int)x, (int)z, (long)seed, (long)987234911L);
            return random.method_43048(10) == 0;
        });
        assert (pos != null);
        int blockPosX = (pos.x() << 4) + 9;
        int blockPosZ = (pos.z() << 4) + 9;
        source.sendFeedback((class_2561)class_2561.method_43469((String)"command.locate.feature.slimeChunk.foundAt", (Object[])new Object[]{ComponentUtils.formatXZ(blockPosX, blockPosZ, class_2561.method_43471((String)"command.locate.feature.slimeChunk.copy")), ComponentUtils.formatXZ(pos.x(), pos.z(), class_2561.method_43471((String)"command.locate.feature.slimeChunk.copyChunk"))}));
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int locateLoot(CustomClientCommandSource source, int amount, ItemAndEnchantmentsPredicateArgument.EnchantedItem itemPredicate) throws CommandSyntaxException {
        int version = source.getVersion();
        if (version <= Cubiomes.MC_1_12()) {
            throw CommandExceptions.LOOT_NOT_SUPPORTED_EXCEPTION.create();
        }
        int dimension = source.getDimension();
        long seed = (Long)source.getSeed().getSecond();
        try (Arena arena = Arena.ofConfined();){
            record StructureIterationState(MemorySegment structureConfig, StructureChecks.GenerationCheck generationCheck, SpiralSpliterator iterator) {
            }
            MemorySegment generator = Generator.allocate(arena);
            Cubiomes.setupGenerator(generator, version, 0);
            Cubiomes.applySeed(generator, dimension, seed);
            MemorySegment surfaceNoise = SurfaceNoise.allocate(arena);
            Cubiomes.initSurfaceNoise(surfaceNoise, dimension, seed);
            class_2338 center = class_2338.method_49638((class_2374)source.getPosition());
            List structureStates = LOOT_SUPPORTED_STRUCTURES.stream().mapMulti((s, consumer) -> {
                MemorySegment structureConfig = StructureConfig.allocate(arena);
                if (Cubiomes.getStructureConfig(s, version, structureConfig) != 0) {
                    consumer.accept(structureConfig);
                }
            }).filter(sconf -> StructureConfig.dim(sconf) == dimension).sorted(Comparator.comparingInt(StructureConfig::regionSize)).map(sconf -> {
                int regionSize = StructureConfig.regionSize(sconf) << 4;
                return new StructureIterationState((MemorySegment)sconf, StructureChecks.getGenerationCheck(StructureConfig.structType(sconf)), new SpiralSpliterator(center.method_10263() / regionSize, center.method_10260() / regionSize, 30000000 / regionSize));
            }).collect(Collectors.toList());
            HashMap lootTableContextCache = new HashMap();
            Map<Integer, Integer> lootTableCount = structureStates.stream().collect(Collectors.toMap(state -> StructureConfig.structType(state.structureConfig), state -> Cubiomes.getLootTableCountForStructure(StructureConfig.structType(state.structureConfig), version)));
            HashMap ignoredLootTables = new HashMap();
            MemorySegment structurePos = Pos.allocate(arena);
            MemorySegment pieces = Piece.allocateArray(StructureChecks.MAX_END_CITY_AND_FORTRESS_PIECES, arena);
            MemorySegment structureVariant = StructureVariant.allocate(arena);
            MemorySegment structureSaltConfig = StructureSaltConfig.allocate(arena);
            int[] found = new int[]{0};
            try {
                int stateIndex = 0;
                int radius = 0;
                while (true) {
                    int newlyFound;
                    if (structureStates.isEmpty()) {
                        throw CommandExceptions.LOOT_NOT_AVAILABLE_EXCEPTION.create();
                    }
                    if (stateIndex >= structureStates.size()) {
                        stateIndex = 0;
                        ++radius;
                    }
                    StructureIterationState state2 = (StructureIterationState)structureStates.get(stateIndex);
                    MemorySegment structureConfig = state2.structureConfig;
                    byte structure = StructureConfig.structType(structureConfig);
                    int regionSize = StructureConfig.regionSize(structureConfig) << 4;
                    int maxRegionSize = StructureConfig.regionSize(((StructureIterationState)structureStates.getLast()).structureConfig) << 4;
                    int previouslyFound = found[0];
                    ArrayList aggregatedLootPositions = new ArrayList();
                    while (state2.iterator.getX() * regionSize <= center.method_10263() + radius * maxRegionSize && state2.iterator.getZ() * regionSize <= center.method_10260() + radius * maxRegionSize) {
                        boolean exhausted;
                        boolean bl = exhausted = !state2.iterator.tryAdvance((Consumer<? super SpiralLoop.Coordinate>)((Consumer<SpiralLoop.Coordinate>)pos -> {
                            if (!state.generationCheck.check(generator, surfaceNoise, pos.x(), pos.z(), structurePos)) {
                                return;
                            }
                            int posX = Pos.x(structurePos);
                            int posZ = Pos.z(structurePos);
                            int biome = Cubiomes.getBiomeAt(generator, 4, posX >> 2, 80, posZ >> 2);
                            Cubiomes.getVariant(structureVariant, structure, version, seed, posX, posZ, biome);
                            int n2 = biome = StructureVariant.biome(structureVariant) != -1 ? (int)StructureVariant.biome(structureVariant) : biome;
                            if (Cubiomes.getStructureSaltConfig(structure, version, biome, structureSaltConfig) == 0) {
                                return;
                            }
                            int numPieces = Cubiomes.getStructurePieces(pieces, StructureChecks.MAX_END_CITY_AND_FORTRESS_PIECES, structure, structureSaltConfig, structureVariant, version, seed, posX, posZ);
                            if (numPieces <= 0) {
                                return;
                            }
                            int foundInStructure = 0;
                            for (int i = 0; i < numPieces; ++i) {
                                MemorySegment piece = Piece.asSlice(pieces, i);
                                int chestCount = Piece.chestCount(piece);
                                if (chestCount == 0) continue;
                                MemorySegment lootTables = Piece.lootTables(piece);
                                MemorySegment lootSeeds = Piece.lootSeeds(piece);
                                for (int j = 0; j < chestCount; ++j) {
                                    MemorySegment lootTable = lootTables.getAtIndex(ValueLayout.ADDRESS, (long)j).reinterpret(Long.MAX_VALUE);
                                    String lootTableString = lootTable.getString(0L);
                                    MemorySegment lootTableContext = lootTableContextCache.computeIfAbsent(lootTableString, string -> {
                                        MemorySegment ltc = LootTableContext.allocate(arena);
                                        if (Cubiomes.init_loot_table_name(ltc, lootTable, version) == 0) {
                                            return null;
                                        }
                                        return ltc;
                                    });
                                    if (lootTableContext == null || Cubiomes.has_item(lootTableContext, itemPredicate.item()) == 0) {
                                        Set structureIgnoredLootTables = ignoredLootTables.computeIfAbsent(structure, n -> new HashSet());
                                        structureIgnoredLootTables.add(lootTableString);
                                        if (structureIgnoredLootTables.size() != ((Integer)lootTableCount.get(structure)).intValue()) continue;
                                        return;
                                    }
                                    Cubiomes.set_loot_seed(lootTableContext, lootSeeds.getAtIndex(Cubiomes.C_LONG_LONG, (long)j));
                                    Cubiomes.generate_loot(lootTableContext);
                                    int lootCount = LootTableContext.generated_item_count(lootTableContext);
                                    for (int k = 0; k < lootCount; ++k) {
                                        MemorySegment itemStack = ItemStack.asSlice(LootTableContext.generated_items(lootTableContext), k);
                                        if (Cubiomes.get_global_item_id(lootTableContext, ItemStack.item(itemStack)) != itemPredicate.item() || !itemPredicate.enchantmensPredicate().test(itemStack)) continue;
                                        foundInStructure += ItemStack.count(itemStack);
                                    }
                                }
                            }
                            if (foundInStructure > 0) {
                                found[0] = found[0] + foundInStructure;
                                aggregatedLootPositions.add(new class_2338(posX, 0, posZ));
                            }
                        }));
                        if (exhausted) {
                            structureStates.remove(stateIndex);
                            break;
                        }
                        if (ignoredLootTables.getOrDefault(structure, Collections.emptySet()).size() == lootTableCount.get(structure).intValue()) {
                            structureStates.remove(stateIndex);
                            break;
                        }
                        if (found[0] < amount) continue;
                        break;
                    }
                    if ((newlyFound = found[0] - previouslyFound) > 0) {
                        String structureName = Cubiomes.struct2str(StructureConfig.structType(structureConfig)).getString(0L);
                        source.getClient().method_63588(() -> source.sendFeedback((class_2561)class_2561.method_43469((String)"command.locate.loot.foundAtStructure", (Object[])new Object[]{ChatBuilder.accent(String.valueOf(newlyFound)), structureName, ComponentUtils.formatXZCollection(aggregatedLootPositions)})));
                    }
                    if (found[0] >= amount) {
                        break;
                    }
                    ++stateIndex;
                }
            }
            finally {
                lootTableContextCache.values().forEach(Cubiomes::free_loot_table_pools);
            }
            String itemName = Cubiomes.global_id2item_name(itemPredicate.item(), version).getString(0L);
            source.getClient().method_63588(() -> source.sendFeedback((class_2561)class_2561.method_43469((String)"command.locate.loot.totalFound", (Object[])new Object[]{ChatBuilder.accent(String.valueOf(found[0])), itemName})));
            int n = found[0];
            return n;
        }
    }

    private static int locateSpawn(CustomClientCommandSource source) throws CommandSyntaxException {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment generator = Generator.allocate(arena);
            Cubiomes.setupGenerator(generator, source.getVersion(), 0);
            Cubiomes.applySeed(generator, source.getDimension(), (Long)source.getSeed().getSecond());
            MemorySegment pos = Cubiomes.getSpawn(arena, generator);
            source.sendFeedback((class_2561)class_2561.method_43469((String)"command.locate.spawn.success", (Object[])new Object[]{ComponentUtils.formatXZ(Pos.x(pos), Pos.z(pos))}));
            int n = 1;
            return n;
        }
    }

    private static int locateOreVein(CustomClientCommandSource source, boolean wantCopperVein) throws CommandSyntaxException {
        int version = source.getVersion();
        long seed = (Long)source.getSeed().getSecond();
        try (Arena arena = Arena.ofConfined();){
            MemorySegment parameters = OreVeinParameters.allocate(arena);
            if (Cubiomes.initOreVeinNoise(parameters, seed, version) == 0) {
                throw CommandExceptions.ORE_VEIN_WRONG_VERSION_EXCEPTION.create();
            }
            class_1923 center = new class_1923(class_2338.method_49638((class_2374)source.getPosition()));
            class_2338[] pos = new class_2338[]{null};
            SpiralLoop.spiral(center.field_9181, center.field_9180, 6400, (chunkX, chunkZ) -> {
                int minX = chunkX << 4;
                int minZ = chunkZ << 4;
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (int y2 = -60; y2 <= 50; ++y2) {
                            boolean isCopperVein;
                            int block = Cubiomes.getOreVeinBlockAt(minX + x, y2, minZ + z, parameters);
                            if (block == -1) continue;
                            boolean bl = isCopperVein = block == Cubiomes.RAW_COPPER_BLOCK() || block == Cubiomes.COPPER_ORE() || block == Cubiomes.GRANITE();
                            if (wantCopperVein != isCopperVein) continue;
                            pos[0] = new class_2338(minX + x, y2, minZ + z);
                            return true;
                        }
                    }
                }
                return false;
            });
            if (pos[0] == null) {
                throw CommandExceptions.NO_ORE_VEIN_FOUND_EXCEPTION.create((Object)6400);
            }
            source.getClient().method_63588(() -> source.sendFeedback((class_2561)class_2561.method_43469((String)"command.locate.oreVein.foundAt", (Object[])new Object[]{ComponentUtils.formatXYZ(pos[0].method_10263(), pos[0].method_10264(), pos[0].method_10260(), class_2561.method_43471((String)"command.locate.oreVein.copy"))})));
            int n = 1;
            return n;
        }
    }

    private static int locateCanyon(CustomClientCommandSource source) throws CommandSyntaxException {
        long seed = (Long)source.getSeed().getSecond();
        int dimension = source.getDimension();
        if (dimension != Cubiomes.DIM_OVERWORLD()) {
            throw CommandExceptions.INVALID_DIMENSION_EXCEPTION.create();
        }
        int version = source.getVersion();
        if (version < Cubiomes.MC_1_13()) {
            throw CommandExceptions.CANYON_WRONG_VERSION_EXCEPTION.create();
        }
        class_1923 center = new class_1923(class_2338.method_49638((class_2374)source.getPosition()));
        try (Arena arena = Arena.ofConfined();){
            ToIntBiFunction<Integer, Integer> biomeFunction = LocateCommand.getCarverBiomeFunction(arena, seed, dimension, version);
            MemorySegment ccc = CanyonCarverConfig.allocate(arena);
            MemorySegment rnd = arena.allocate(Cubiomes.C_LONG_LONG);
            SpiralLoop.Coordinate pos = SpiralLoop.spiral(center.field_9181, center.field_9180, 6400, (chunkX, chunkZ) -> {
                for (int canyonCarver : CanyonCarverArgument.CANYON_CARVERS.values()) {
                    int biome;
                    if (Cubiomes.getCanyonCarverConfig(canyonCarver, version, ccc) == 0 || Cubiomes.isViableCanyonBiome(canyonCarver, biome = biomeFunction.applyAsInt(chunkX, chunkZ)) == 0 || Cubiomes.checkCanyonStart(seed, chunkX, chunkZ, ccc, rnd) == 0) continue;
                    return true;
                }
                return false;
            });
            if (pos == null) {
                throw CommandExceptions.NO_CANYON_FOUND_EXCEPTION.create((Object)6400);
            }
            source.getClient().method_63588(() -> source.sendFeedback((class_2561)class_2561.method_43469((String)"command.locate.canyon.foundAt", (Object[])new Object[]{ComponentUtils.formatXZ(class_4076.method_18688((int)pos.x()), class_4076.method_18688((int)pos.z()), class_2561.method_43471((String)"command.locate.canyon.copy"))})));
            int n = 1;
            return n;
        }
    }

    static ToIntBiFunction<Integer, Integer> getCarverBiomeFunction(Arena arena, long seed, int dimension, int version) {
        if (version > Cubiomes.MC_1_17_1()) {
            return (n, n2) -> -1;
        }
        MemorySegment generator = Generator.allocate(arena);
        Cubiomes.setupGenerator(generator, version, 0);
        Cubiomes.applySeed(generator, dimension, seed);
        return (chunkX, chunkZ) -> Cubiomes.getBiomeAt(generator, 4, chunkX << 2, 0, chunkZ << 2);
    }
}

