/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.config;

import com.google.common.base.Suppliers;
import dev.xpple.betterconfig.api.BetterConfigAPI;
import dev.xpple.betterconfig.api.Config;
import dev.xpple.betterconfig.api.ModConfig;
import dev.xpple.seedmapper.command.arguments.SeedResolutionArgument;
import dev.xpple.seedmapper.seedmap.MapFeature;
import dev.xpple.seedmapper.util.ChatBuilder;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class Configs {
    public static final Supplier<ModConfig<class_2561>> CONFIG_REF = Suppliers.memoize(() -> BetterConfigAPI.getInstance().getModConfig("seedmapper"));
    @Config
    public static Long Seed = null;
    @Config(putter=@Config.Putter(value="none"), adder=@Config.Adder(value="addSavedSeed", type=long.class))
    public static Map<String, Long> SavedSeeds = new HashMap<String, Long>();
    @Config
    public static SeedResolutionArgument.SeedResolution SeedResolutionOrder = new SeedResolutionArgument.SeedResolution();
    @Config(comment="getOreAreCheckComment")
    public static boolean OreAirCheck = true;
    private static final int MAX_THREADS;
    @Config(setter=@Config.Setter(value="setSeedMapThreads"))
    public static int SeedMapThreads;
    @Config(setter=@Config.Setter(value="setPixelsPerBiome"))
    public static int PixelsPerBiome;
    @Config(chatRepresentation="listToggledFeatures")
    public static EnumSet<MapFeature> ToggledFeatures;
    @Config(comment="getDevModeComment")
    public static boolean DevMode;

    public static void save() {
        CONFIG_REF.get().save();
    }

    private static void addSavedSeed(long seed) {
        String key = class_310.method_1551().method_1562().method_48296().method_10755().toString();
        SavedSeeds.put(key, seed);
    }

    private static class_2561 getOreAreCheckComment() {
        return class_2561.method_43471((String)"config.oreAirCheck.comment");
    }

    private static void setSeedMapThreads(int seedMapThreads) {
        SeedMapThreads = Math.clamp((long)seedMapThreads, 1, MAX_THREADS);
    }

    private static void setPixelsPerBiome(int pixelsPerBiome) {
        PixelsPerBiome = Math.clamp((long)pixelsPerBiome, 1, 100);
    }

    public static class_2561 listToggledFeatures() {
        return ChatBuilder.join((class_2561)class_2561.method_43470((String)", "), ToggledFeatures.stream().map(MapFeature::getName).map(class_2561::method_43470));
    }

    public static class_2561 getDevModeComment() {
        return class_2561.method_43471((String)"config.devMode.comment");
    }

    static {
        SeedMapThreads = MAX_THREADS = Math.max(1, Runtime.getRuntime().availableProcessors() - 2);
        PixelsPerBiome = 4;
        ToggledFeatures = (EnumSet)class_156.method_656(() -> {
            EnumSet<MapFeature> toggledFeatures = EnumSet.allOf(MapFeature.class);
            toggledFeatures.remove((Object)MapFeature.SLIME_CHUNK);
            return toggledFeatures;
        });
        DevMode = false;
    }
}

