/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.feature;

import com.github.cubiomes.Cubiomes;
import com.github.cubiomes.StructureVariant;
import dev.xpple.seedmapper.util.ChatBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.foreign.MemorySegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public final class StructureVariantFeedbackHelper {
    private static final Int2ObjectMap<Function<MemorySegment, List<class_2561>>> VARIANT_FEEDBACK;

    private StructureVariantFeedbackHelper() {
    }

    public static List<class_2561> get(int structure, MemorySegment structureVariant) {
        return (List)((Function)VARIANT_FEEDBACK.get(structure)).apply(structureVariant);
    }

    static {
        Int2ObjectOpenHashMap temp = new Int2ObjectOpenHashMap();
        temp.defaultReturnValue(memorySegment -> Collections.emptyList());
        temp.put(Cubiomes.Village(), variant -> {
            ArrayList<class_5250> components = new ArrayList<class_5250>();
            short biome = StructureVariant.biome(variant);
            byte start = StructureVariant.start(variant);
            if (biome == Cubiomes.meadow() || biome == Cubiomes.plains()) {
                if (start == 0) {
                    components.add(class_2561.method_43469((String)"command.locate.feature.structure.start", (Object[])new Object[]{"plains_fountain_01"}));
                } else {
                    components.add(class_2561.method_43469((String)"command.locate.feature.structure.start", (Object[])new Object[]{"plains_meeting_point_" + start}));
                }
            } else if (biome == Cubiomes.desert()) {
                components.add(class_2561.method_43469((String)"command.locate.feature.structure.start", (Object[])new Object[]{"desert_meeting_point_" + start}));
            } else if (biome == Cubiomes.savanna()) {
                components.add(class_2561.method_43469((String)"command.locate.feature.structure.start", (Object[])new Object[]{"savanna_meeting_point_" + start}));
            } else if (biome == Cubiomes.taiga()) {
                components.add(class_2561.method_43469((String)"command.locate.feature.structure.start", (Object[])new Object[]{"taiga_meeting_point_" + start}));
            } else if (biome == Cubiomes.snowy_tundra()) {
                components.add(class_2561.method_43469((String)"command.locate.feature.structure.start", (Object[])new Object[]{"snowy_meeting_point_" + start}));
            }
            components.add(class_2561.method_43471((String)("command.locate.feature.structure.rotation_" + StructureVariant.rotation(variant))));
            if (StructureVariant.abandoned(variant) == 1) {
                components.add(class_2561.method_43471((String)"command.locate.feature.structure.village.abandoned"));
            } else {
                components.add(class_2561.method_43471((String)"command.locate.feature.structure.village.notAbandoned"));
            }
            return components;
        });
        temp.put(Cubiomes.Bastion(), variant -> {
            ArrayList<class_5250> components = new ArrayList<class_5250>();
            switch (StructureVariant.start(variant)) {
                case 0: {
                    components.add(class_2561.method_43469((String)"command.locate.feature.structure.start", (Object[])new Object[]{"units/air_base"}));
                    break;
                }
                case 1: {
                    components.add(class_2561.method_43469((String)"command.locate.feature.structure.start", (Object[])new Object[]{"hoglin_stable/air_base"}));
                    break;
                }
                case 2: {
                    components.add(class_2561.method_43469((String)"command.locate.feature.structure.start", (Object[])new Object[]{"treasure/big_air_full"}));
                    break;
                }
                case 3: {
                    components.add(class_2561.method_43469((String)"command.locate.feature.structure.start", (Object[])new Object[]{"bridge/starting_pieces/entrance_base"}));
                }
            }
            components.add(class_2561.method_43471((String)("command.locate.feature.structure.rotation_" + StructureVariant.rotation(variant))));
            return components;
        });
        temp.put(Cubiomes.Ancient_City(), variant -> {
            ArrayList<class_5250> components = new ArrayList<class_5250>();
            short yLevel = StructureVariant.y(variant);
            components.add(class_2561.method_43469((String)"command.locate.feature.structure.yLevel", (Object[])new Object[]{ChatBuilder.copy(ChatBuilder.accent(String.valueOf(yLevel)), String.valueOf(yLevel))}));
            components.add(class_2561.method_43469((String)"command.locate.feature.structure.start", (Object[])new Object[]{"city_center_" + StructureVariant.start(variant)}));
            components.add(class_2561.method_43471((String)("command.locate.feature.structure.rotation_" + StructureVariant.rotation(variant))));
            return components;
        });
        temp.put(Cubiomes.Ruined_Portal(), variant -> {
            ArrayList<class_5250> components = new ArrayList<class_5250>();
            byte start = StructureVariant.start(variant);
            if (StructureVariant.giant(variant) == 1) {
                components.add(class_2561.method_43469((String)"command.locate.feature.structure.start", (Object[])new Object[]{"ruined_portal/giant_portal_" + start}));
                components.add(class_2561.method_43471((String)"command.locate.feature.structure.ruinedPortal.giant"));
            } else {
                components.add(class_2561.method_43469((String)"command.locate.feature.structure.start", (Object[])new Object[]{"ruined_portal/portal_" + start}));
                components.add(class_2561.method_43471((String)"command.locate.feature.structure.ruinedPortal.notGiant"));
            }
            components.add(1, class_2561.method_43471((String)("command.locate.feature.structure.rotation_" + StructureVariant.rotation(variant))));
            components.add(2, class_2561.method_43469((String)"command.locate.feature.structure.mirrored", (Object[])new Object[]{StructureVariant.mirror(variant) == 1}));
            if (StructureVariant.underground(variant) == 1) {
                components.add(class_2561.method_43471((String)"command.locate.feature.structure.ruinedPortal.underground"));
            } else {
                components.add(class_2561.method_43471((String)"command.locate.feature.structure.ruinedPortal.notUnderground"));
            }
            if (StructureVariant.airpocket(variant) == 1) {
                components.add(class_2561.method_43471((String)"command.locate.feature.structure.ruinedPortal.airPocket"));
            } else {
                components.add(class_2561.method_43471((String)"command.locate.feature.structure.ruinedPortal.noAirPocket"));
            }
            return components;
        });
        temp.put(Cubiomes.Ruined_Portal_N(), (Object)((Function)temp.get(Cubiomes.Ruined_Portal())));
        temp.put(Cubiomes.Igloo(), variant -> {
            ArrayList<class_5250> components = new ArrayList<class_5250>();
            components.add(class_2561.method_43469((String)"command.locate.feature.structure.igloo.size", (Object[])new Object[]{StructureVariant.size(variant)}));
            components.add(class_2561.method_43471((String)("command.locate.feature.structure.rotation_" + StructureVariant.rotation(variant))));
            components.add(class_2561.method_43469((String)"command.locate.feature.structure.mirrored", (Object[])new Object[]{StructureVariant.mirror(variant) == 1}));
            if (StructureVariant.basement(variant) == 1) {
                components.add(class_2561.method_43471((String)"command.locate.feature.structure.igloo.basement"));
            } else {
                components.add(class_2561.method_43471((String)"command.locate.feature.structure.igloo.noBasement"));
            }
            return components;
        });
        temp.put(Cubiomes.Shipwreck(), variant -> {
            String variantName;
            ArrayList<class_5250> components = new ArrayList<class_5250>();
            short biome = StructureVariant.biome(variant);
            if (Cubiomes.isOceanic(biome) == 0) {
                variantName = switch (StructureVariant.start(variant)) {
                    case 0 -> "shipwreck/with_mast";
                    case 1 -> "shipwreck/sideways_full";
                    case 2 -> "shipwreck/sideways_fronthalf";
                    case 3 -> "shipwreck/sideways_backhalf";
                    case 4 -> "shipwreck/rightsideup_full";
                    case 5 -> "shipwreck/rightsideup_fronthalf";
                    case 6 -> "shipwreck/rightsideup_backhalf";
                    case 7 -> "shipwreck/with_mast_degraded";
                    case 8 -> "shipwreck/rightsideup_full_degraded";
                    case 9 -> "shipwreck/rightsideup_fronthalf_degraded";
                    case 10 -> "shipwreck/rightsideup_backhalf_degraded";
                    default -> "shipwreck/isBeached/error";
                };
            } else {
                variantName = switch (StructureVariant.start(variant)) {
                    case 0 -> "shipwreck/with_mast";
                    case 1 -> "shipwreck/upsidedown_full";
                    case 2 -> "shipwreck/upsidedown_fronthalf";
                    case 3 -> "shipwreck/upsidedown_backhalf";
                    case 4 -> "shipwreck/sideways_full";
                    case 5 -> "shipwreck/sideways_fronthalf";
                    case 6 -> "shipwreck/sideways_backhalf";
                    case 7 -> "shipwreck/rightsideup_full";
                    case 8 -> "shipwreck/rightsideup_fronthalf";
                    case 9 -> "shipwreck/rightsideup_backhalf";
                    case 10 -> "shipwreck/with_mast_degraded";
                    case 11 -> "shipwreck/upsidedown_full_degraded";
                    case 12 -> "shipwreck/upsidedown_fronthalf_degraded";
                    case 13 -> "shipwreck/upsidedown_backhalf_degraded";
                    case 14 -> "shipwreck/sideways_full_degraded";
                    case 15 -> "shipwreck/sideways_fronthalf_degraded";
                    case 16 -> "shipwreck/sideways_backhalf_degraded";
                    case 17 -> "shipwreck/rightsideup_full_degraded";
                    case 18 -> "shipwreck/rightsideup_fronthalf_degraded";
                    case 19 -> "shipwreck/rightsideup_backhalf_degraded";
                    default -> "shipwreck/isOcean/error";
                };
            }
            components.add(class_2561.method_43469((String)"command.locate.feature.structure.start", (Object[])new Object[]{variantName}));
            components.add(class_2561.method_43471((String)("command.locate.feature.structure.rotation_" + StructureVariant.rotation(variant))));
            return components;
        });
        temp.put(Cubiomes.Outpost(), variant -> {
            ArrayList<class_5250> components = new ArrayList<class_5250>();
            components.add(class_2561.method_43471((String)("command.locate.feature.structure.rotation_" + StructureVariant.rotation(variant))));
            return components;
        });
        temp.put(Cubiomes.Desert_Pyramid(), variant -> {
            ArrayList<class_5250> components = new ArrayList<class_5250>();
            components.add(class_2561.method_43471((String)("command.locate.feature.structure.rotation_" + StructureVariant.rotation(variant))));
            components.add(class_2561.method_43469((String)"command.locate.feature.structure.mirrored", (Object[])new Object[]{StructureVariant.mirror(variant) == 1}));
            return components;
        });
        temp.put(Cubiomes.Jungle_Temple(), (Object)((Function)temp.get(Cubiomes.Desert_Pyramid())));
        temp.put(Cubiomes.Swamp_Hut(), (Object)((Function)temp.get(Cubiomes.Desert_Pyramid())));
        temp.put(Cubiomes.Geode(), variant -> {
            ArrayList<class_5250> components = new ArrayList<class_5250>();
            short yLevel = StructureVariant.y(variant);
            components.add(class_2561.method_43469((String)"command.locate.feature.structure.yLevel", (Object[])new Object[]{ChatBuilder.copy(ChatBuilder.accent(String.valueOf(yLevel)), String.valueOf(yLevel))}));
            components.add(class_2561.method_43469((String)"command.locate.feature.structure.geode.size", (Object[])new Object[]{StructureVariant.size(variant)}));
            if (StructureVariant.cracked(variant) == 1) {
                components.add(class_2561.method_43471((String)"command.locate.feature.structure.geode.cracked"));
            } else {
                components.add(class_2561.method_43471((String)"command.locate.feature.structure.geode.notCracked"));
            }
            return components;
        });
        temp.put(Cubiomes.Trial_Chambers(), variant -> {
            ArrayList<class_5250> components = new ArrayList<class_5250>();
            short yLevel = StructureVariant.y(variant);
            components.add(class_2561.method_43469((String)"command.locate.feature.structure.yLevel", (Object[])new Object[]{ChatBuilder.copy(ChatBuilder.accent(String.valueOf(yLevel)), String.valueOf(yLevel))}));
            components.add(class_2561.method_43469((String)"command.locate.feature.structure.start", (Object[])new Object[]{"corridor/end_" + StructureVariant.start(variant)}));
            components.add(class_2561.method_43471((String)("command.locate.feature.structure.rotation_" + StructureVariant.rotation(variant))));
            return components;
        });
        VARIANT_FEEDBACK = Int2ObjectMaps.unmodifiable((Int2ObjectMap)temp);
    }
}

