/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.seedmap;

import com.github.cubiomes.Cubiomes;
import dev.xpple.seedmapper.seedmap.ChestLootData;
import dev.xpple.seedmapper.util.ChatBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_8001;

public class ChestLootWidget {
    private static final class_2960 CHEST_CONTAINER = class_2960.method_60655((String)"seedmapper", (String)"textures/gui/chest_container.png");
    private static final int CHEST_CONTAINER_WIDTH = 176;
    private static final int CHEST_CONTAINER_HEIGHT = 78;
    private static final class_2960 BUTTON_TEXTURE = class_2960.method_60655((String)"fabric", (String)"textures/gui/creative_buttons.png");
    private static final int BUTTON_X_OFFSET = 149;
    private static final int BUTTON_Y_OFFSET = 4;
    private static final int BUTTON_WIDTH = 10;
    private static final int BUTTON_HEIGHT = 12;
    private static final int ITEM_SLOT_SIZE = 18;
    private final int x;
    private final int y;
    private int chestIndex = 0;
    private final List<ChestLootData> chestDataList;
    private final List<List<class_5684>> extraChestInfo = new ArrayList<List<class_5684>>();

    public ChestLootWidget(int x, int y2, List<ChestLootData> chestDataList) {
        this.x = x;
        this.y = y2;
        this.chestDataList = chestDataList;
        for (ChestLootData chestData : this.chestDataList) {
            ArrayList<class_5684> tooltips = new ArrayList<class_5684>();
            class_5250 pieceNameComponent = class_2561.method_43469((String)"seedMap.chestLoot.extraInfo.pieceName", (Object[])new Object[]{ChatBuilder.accent(chestData.pieceName())});
            tooltips.add(class_5684.method_32662((class_5481)pieceNameComponent.method_30937()));
            class_2338 chestPos = chestData.chestPos();
            class_5250 chestPosComponent = class_2561.method_43469((String)"seedMap.chestLoot.extraInfo.chestPos", (Object[])new Object[]{ChatBuilder.accent("x: %d, z: %d".formatted(chestPos.method_10263(), chestPos.method_10260()))});
            tooltips.add(class_5684.method_32662((class_5481)chestPosComponent.method_30937()));
            String lootTable = chestData.lootTable();
            class_5250 lootTableComponent = class_2561.method_43469((String)"seedMap.chestLoot.extraInfo.lootTable", (Object[])new Object[]{ChatBuilder.accent(lootTable)});
            tooltips.add(class_5684.method_32662((class_5481)lootTableComponent.method_30937()));
            long lootSeed = chestData.lootSeed();
            class_5250 lootSeedComponent = class_2561.method_43469((String)"seedMap.chestLoot.extraInfo.lootSeed", (Object[])new Object[]{ChatBuilder.accent(Long.toString(lootSeed))});
            tooltips.add(class_5684.method_32662((class_5481)lootSeedComponent.method_30937()));
            this.extraChestInfo.add(tooltips);
        }
    }

    public void render(class_332 guiGraphics, int mouseX, int mouseY, class_327 font) {
        guiGraphics.method_25290(class_10799.field_56883, CHEST_CONTAINER, this.x, this.y, 0.0f, 0.0f, 176, 78, 176, 78);
        ChestLootData chestData = this.chestDataList.get(this.chestIndex);
        String structure = Cubiomes.struct2str(chestData.structure()).getString(0L);
        class_5250 title = class_2561.method_43469((String)"seedMap.chestLoot.title", (Object[])new Object[]{structure, this.chestIndex + 1, this.chestDataList.size()});
        int minX = this.x + 8;
        int minY = this.y + 6;
        guiGraphics.method_27535(font, (class_2561)title, minX, minY, -1);
        int titleWidth = font.method_30880(title.method_30937());
        if (mouseX >= minX && mouseX <= minX + titleWidth && mouseY >= minY) {
            Objects.requireNonNull(font);
            if (mouseY <= minY + 9) {
                List<class_5684> tooltips = this.extraChestInfo.get(this.chestIndex);
                int n = tooltips.size();
                Objects.requireNonNull(font);
                guiGraphics.method_51435(font, tooltips, minX - 4 - 12, this.y - n * 9 - 8 + 12, class_8001.field_41687, null);
            }
        }
        minY += 12;
        for (int row = 0; row < 3; ++row) {
            int y2 = minY + row * 18;
            for (int column = 0; column < 9; ++column) {
                class_1799 item = chestData.container().method_5438(row * 9 + column);
                if (item == class_1799.field_8037) continue;
                int x = minX + column * 18;
                guiGraphics.method_51427(item, x, y2);
                guiGraphics.method_51431(font, item, x, y2);
                if (mouseX < x || mouseX > x + 18 || mouseY < y2 || mouseY > y2 + 18) continue;
                guiGraphics.method_51446(font, item, mouseX, mouseY);
            }
        }
        guiGraphics.method_25290(class_10799.field_56883, BUTTON_TEXTURE, this.x + 149, this.y + 4, 0.0f, 0.0f, 10, 12, 256, 256);
        guiGraphics.method_25290(class_10799.field_56883, BUTTON_TEXTURE, this.x + 149 + 10, this.y + 4, 10.0f, 0.0f, 10, 12, 256, 256);
    }

    public boolean mouseClicked(class_11909 mouseButtonEvent, boolean doubleClick) {
        int button = mouseButtonEvent.method_74245();
        if (button != 0) {
            return false;
        }
        double mouseX = mouseButtonEvent.comp_4798();
        double mouseY = mouseButtonEvent.comp_4799();
        int minX = this.x + 149;
        int minY = this.y + 4;
        int maxX = minX + 10;
        int maxY = minY + 12;
        if (mouseX >= (double)minX && mouseX <= (double)maxX && mouseY >= (double)minY && mouseY <= (double)maxY) {
            this.chestIndex = Math.max(0, this.chestIndex - 1);
            return true;
        }
        minX += 10;
        maxX += 10;
        if (mouseX >= (double)minX && mouseX <= (double)maxX && mouseY >= (double)minY && mouseY <= (double)maxY) {
            this.chestIndex = Math.min(this.chestDataList.size() - 1, this.chestIndex + 1);
            return true;
        }
        return false;
    }
}

