/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.seedmap;

import com.github.cubiomes.CanyonCarverConfig;
import com.github.cubiomes.Cubiomes;
import com.github.cubiomes.EnchantInstance;
import com.github.cubiomes.Generator;
import com.github.cubiomes.ItemStack;
import com.github.cubiomes.LootTableContext;
import com.github.cubiomes.OreVeinParameters;
import com.github.cubiomes.Piece;
import com.github.cubiomes.Pos;
import com.github.cubiomes.Range;
import com.github.cubiomes.StructureConfig;
import com.github.cubiomes.StructureSaltConfig;
import com.github.cubiomes.StructureVariant;
import com.github.cubiomes.SurfaceNoise;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.xpple.seedmapper.command.arguments.CanyonCarverArgument;
import dev.xpple.seedmapper.command.arguments.ItemAndEnchantmentsPredicateArgument;
import dev.xpple.seedmapper.command.commands.LocateCommand;
import dev.xpple.seedmapper.config.Configs;
import dev.xpple.seedmapper.feature.StructureChecks;
import dev.xpple.seedmapper.seedmap.ChestLootData;
import dev.xpple.seedmapper.seedmap.ChestLootWidget;
import dev.xpple.seedmapper.seedmap.FeatureToggleWidget;
import dev.xpple.seedmapper.seedmap.MapFeature;
import dev.xpple.seedmapper.seedmap.OreVeinData;
import dev.xpple.seedmapper.seedmap.StructureData;
import dev.xpple.seedmapper.seedmap.Tile;
import dev.xpple.seedmapper.seedmap.TilePos;
import dev.xpple.seedmapper.thread.SeedMapCache;
import dev.xpple.seedmapper.thread.SeedMapExecutor;
import dev.xpple.seedmapper.util.ChatBuilder;
import dev.xpple.seedmapper.util.QuartPos2;
import dev.xpple.seedmapper.util.RegionPos;
import dev.xpple.seedmapper.util.TwoDTree;
import dev.xpple.seedmapper.util.WorldIdentifier;
import dev.xpple.simplewaypoints.api.SimpleWaypointsAPI;
import it.unimi.dsi.fastutil.ints.AbstractIntCollection;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SequenceLayout;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntSupplier;
import java.util.function.ToIntBiFunction;
import java.util.stream.IntStream;
import net.minecraft.class_1043;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1277;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4076;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_6574;
import net.minecraft.class_6677;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7532;
import net.minecraft.class_7924;
import net.minecraft.class_8685;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;

public class SeedMapScreen
extends class_437 {
    private static final int[] biomeColours = new int[256];
    public static final int BIOME_SCALE = 4;
    public static final int SCALED_CHUNK_SIZE = 4;
    private static final int HORIZONTAL_PADDING = 50;
    private static final int VERTICAL_PADDING = 50;
    public static final int MIN_PIXELS_PER_BIOME = 1;
    public static final int MAX_PIXELS_PER_BIOME = 100;
    private static final int HORIZONTAL_FEATURE_TOGGLE_SPACING = 5;
    private static final int VERTICAL_FEATURE_TOGGLE_SPACING = 1;
    private static final int FEATURE_TOGGLE_HEIGHT = 20;
    private static final int TELEPORT_FIELD_WIDTH = 70;
    private static final int WAYPOINT_NAME_FIELD_WIDTH = 100;
    private static final IntSupplier TILE_SIZE_PIXELS;
    private static final Object2ObjectMap<WorldIdentifier, Object2ObjectMap<TilePos, int[]>> biomeDataCache;
    private static final Object2ObjectMap<WorldIdentifier, Object2ObjectMap<class_1923, StructureData>> structureDataCache;
    public static final Object2ObjectMap<WorldIdentifier, TwoDTree> strongholdDataCache;
    private static final Object2ObjectMap<WorldIdentifier, Object2ObjectMap<TilePos, OreVeinData>> oreVeinDataCache;
    private static final Object2ObjectMap<WorldIdentifier, Object2ObjectMap<TilePos, BitSet>> canyonDataCache;
    private static final Object2ObjectMap<WorldIdentifier, Object2ObjectMap<TilePos, BitSet>> slimeChunkDataCache;
    private static final Object2ObjectMap<WorldIdentifier, class_2338> spawnDataCache;
    private final SeedMapExecutor seedMapExecutor = new SeedMapExecutor();
    private final Arena arena = Arena.ofShared();
    private final long seed;
    private final int dimension;
    private final int version;
    private final WorldIdentifier worldIdentifier;
    private final MemorySegment biomeGenerator;
    private final MemorySegment structureGenerator;
    private final MemorySegment[] structureConfigs;
    private final MemorySegment surfaceNoise;
    private final class_6574 oreVeinRandom;
    private final MemorySegment oreVeinParameters;
    private final Object2ObjectMap<TilePos, Tile> biomeTileCache = new Object2ObjectOpenHashMap();
    private final SeedMapCache<TilePos, int[]> biomeCache;
    private final Object2ObjectMap<class_1923, StructureData> structureCache;
    private final SeedMapCache<TilePos, OreVeinData> oreVeinCache;
    private final Object2ObjectMap<TilePos, BitSet> canyonCache;
    private final Object2ObjectMap<TilePos, Tile> slimeChunkTileCache = new Object2ObjectOpenHashMap();
    private final SeedMapCache<TilePos, BitSet> slimeChunkCache;
    private final class_2338 playerPos;
    private QuartPos2 centerQuart;
    private int centerX;
    private int centerY;
    private int seedMapWidth;
    private int seedMapHeight;
    private final List<MapFeature> toggleableFeatures;
    private final int featureIconsCombinedWidth;
    private final ObjectSet<FeatureWidget> featureWidgets = new ObjectOpenHashSet();
    private QuartPos2 mouseQuart;
    private int displayCoordinatesCopiedTicks = 0;
    private class_342 teleportEditBoxX;
    private class_342 teleportEditBoxZ;
    private class_342 waypointNameEditBox;
    @Nullable
    private FeatureWidget markerWidget = null;
    @Nullable
    private ChestLootWidget chestLootWidget = null;
    private class_2378<class_1887> enchantmentsRegistry;
    private static final BiMap<Integer, class_5321<class_1937>> DIM_ID_TO_MC;

    public SeedMapScreen(long seed, int dimension, int version, class_2338 playerPos) {
        super((class_2561)class_2561.method_43473());
        this.seed = seed;
        this.dimension = dimension;
        this.version = version;
        this.worldIdentifier = new WorldIdentifier(this.seed, this.dimension, this.version);
        this.biomeGenerator = Generator.allocate(this.arena);
        Cubiomes.setupGenerator(this.biomeGenerator, this.version, 0);
        Cubiomes.applySeed(this.biomeGenerator, this.dimension, this.seed);
        this.structureGenerator = Generator.allocate(this.arena);
        this.structureGenerator.copyFrom(this.biomeGenerator);
        this.structureConfigs = (MemorySegment[])IntStream.range(0, Cubiomes.FEATURE_NUM()).mapToObj(structure -> {
            MemorySegment structureConfig = StructureConfig.allocate(this.arena);
            if (Cubiomes.getStructureConfig(structure, this.version, structureConfig) == 0) {
                return null;
            }
            if (StructureConfig.dim(structureConfig) != this.dimension) {
                return null;
            }
            return structureConfig;
        }).toArray(MemorySegment[]::new);
        this.surfaceNoise = SurfaceNoise.allocate(this.arena);
        Cubiomes.initSurfaceNoise(this.surfaceNoise, this.dimension, this.seed);
        this.oreVeinRandom = new class_6677(this.seed).method_38421().method_39000(class_2960.method_60655((String)"seedmapper", (String)"ore_vein_feature")).method_38421();
        this.oreVeinParameters = OreVeinParameters.allocate(this.arena);
        Cubiomes.initOreVeinNoise(this.oreVeinParameters, this.seed, this.version);
        this.toggleableFeatures = Arrays.stream(MapFeature.values()).filter(feature -> feature.getDimension() == this.dimension || feature.getDimension() == Cubiomes.DIM_UNDEF()).filter(feature -> this.version >= feature.availableSince()).sorted(Comparator.comparing(MapFeature::getName)).toList();
        this.biomeCache = new SeedMapCache(Object2ObjectMaps.synchronize((Object2ObjectMap)((Object2ObjectMap)biomeDataCache.computeIfAbsent((Object)this.worldIdentifier, object -> new Object2ObjectOpenHashMap()))), this.seedMapExecutor);
        this.structureCache = (Object2ObjectMap)structureDataCache.computeIfAbsent((Object)this.worldIdentifier, object -> new Object2ObjectOpenHashMap());
        this.slimeChunkCache = new SeedMapCache(Object2ObjectMaps.synchronize((Object2ObjectMap)((Object2ObjectMap)slimeChunkDataCache.computeIfAbsent((Object)this.worldIdentifier, object -> new Object2ObjectOpenHashMap()))), this.seedMapExecutor);
        this.oreVeinCache = new SeedMapCache((Object2ObjectMap)oreVeinDataCache.computeIfAbsent((Object)this.worldIdentifier, object -> new Object2ObjectOpenHashMap()), this.seedMapExecutor);
        this.canyonCache = (Object2ObjectMap)canyonDataCache.computeIfAbsent((Object)this.worldIdentifier, object -> new Object2ObjectOpenHashMap());
        if (this.toggleableFeatures.contains((Object)MapFeature.STRONGHOLD) && !strongholdDataCache.containsKey((Object)this.worldIdentifier)) {
            this.seedMapExecutor.submitCalculation(() -> LocateCommand.calculateStrongholds(this.seed, this.dimension, this.version)).thenAccept(tree -> {
                if (tree != null) {
                    strongholdDataCache.put((Object)this.worldIdentifier, tree);
                }
            });
        }
        this.featureIconsCombinedWidth = this.toggleableFeatures.stream().map(feature -> feature.getTexture().width()).reduce((l, r) -> l + 5 + r).orElseThrow();
        this.playerPos = playerPos;
        this.centerQuart = QuartPos2.fromBlockPos(playerPos);
        this.mouseQuart = new QuartPos2(this.centerQuart.x(), this.centerQuart.z());
    }

    protected void method_25426() {
        super.method_25426();
        this.centerX = this.field_22789 / 2;
        this.centerY = this.field_22790 / 2;
        this.seedMapWidth = 2 * (this.centerX - 50);
        this.seedMapHeight = 2 * (this.centerY - 50);
        this.createFeatureToggles();
        this.createTeleportField();
        this.createWaypointNameField();
        this.enchantmentsRegistry = this.field_22787.field_1724.method_56673().method_30530(class_7924.field_41265);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        TilePos tilePos;
        TwoDTree tree;
        Object biomeData;
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        class_5250 seedComponent = class_2561.method_43469((String)"seedMap.seedAndVersion", (Object[])new Object[]{ChatBuilder.accent(Long.toString(this.seed)), Cubiomes.mc2str(this.version).getString(0L)});
        Objects.requireNonNull(this.field_22793);
        guiGraphics.method_27535(this.field_22793, (class_2561)seedComponent, 50, 50 - 9 - 1, -1);
        int tileSizePixels = TILE_SIZE_PIXELS.getAsInt();
        int horTileRadius = Math.ceilDiv(this.seedMapWidth, tileSizePixels) + 1;
        int verTileRadius = Math.ceilDiv(this.seedMapHeight, tileSizePixels) + 1;
        TilePos centerTile = TilePos.fromQuartPos(this.centerQuart);
        for (int relTileX = -horTileRadius; relTileX <= horTileRadius; ++relTileX) {
            for (int relTileZ = -verTileRadius; relTileZ <= verTileRadius; ++relTileZ) {
                BitSet slimeChunkData;
                TilePos tilePos2 = centerTile.add(relTileX, relTileZ);
                biomeData = this.biomeCache.computeIfAbsent(tilePos2, this::calculateBiomeData);
                if (biomeData != null) {
                    Tile tile = (Tile)this.biomeTileCache.computeIfAbsent((Object)tilePos2, arg_0 -> this.lambda$render$14(tilePos2, (int[])biomeData, arg_0));
                    this.drawTile(guiGraphics, tile);
                }
                if (!this.toggleableFeatures.contains((Object)MapFeature.SLIME_CHUNK) || !Configs.ToggledFeatures.contains((Object)MapFeature.SLIME_CHUNK) || (slimeChunkData = this.slimeChunkCache.computeIfAbsent(tilePos2, this::calculateSlimeChunkData)) == null) continue;
                Tile tile = (Tile)this.slimeChunkTileCache.computeIfAbsent((Object)tilePos2, object -> this.createSlimeChunkTile(tilePos2, slimeChunkData));
                this.drawTile(guiGraphics, tile);
            }
        }
        int horChunkRadius = Math.ceilDiv(this.seedMapWidth / 2, 4 * Configs.PixelsPerBiome);
        int verChunkRadius = Math.ceilDiv(this.seedMapHeight / 2, 4 * Configs.PixelsPerBiome);
        Configs.ToggledFeatures.stream().filter(this.toggleableFeatures::contains).filter(f -> f.getStructureId() != -1).forEach(feature -> {
            int structure = feature.getStructureId();
            MemorySegment structureConfig = this.structureConfigs[structure];
            if (structureConfig == null) {
                return;
            }
            byte regionSize = StructureConfig.regionSize(structureConfig);
            RegionPos centerRegion = RegionPos.fromQuartPos(this.centerQuart, regionSize);
            int horRegionRadius = Math.ceilDiv(horChunkRadius, (int)regionSize);
            int verRegionRadius = Math.ceilDiv(verChunkRadius, (int)regionSize);
            StructureChecks.GenerationCheck generationCheck = StructureChecks.getGenerationCheck(structure);
            MemorySegment structurePos = Pos.allocate(this.arena);
            for (int relRegionX = -horRegionRadius; relRegionX <= horRegionRadius; ++relRegionX) {
                for (int relRegionZ = -verRegionRadius; relRegionZ <= verRegionRadius; ++relRegionZ) {
                    class_1923 chunkPos;
                    StructureData structureData;
                    class_2338 pos;
                    RegionPos regionPos = centerRegion.add(relRegionX, relRegionZ);
                    if (Cubiomes.getStructurePos(structure, this.version, this.seed, regionPos.x(), regionPos.z(), structurePos) == 0 || (pos = (class_2338)(structureData = (StructureData)this.structureCache.computeIfAbsent((Object)(chunkPos = new class_1923(class_4076.method_18675((int)Pos.x(structurePos)), class_4076.method_18675((int)Pos.z(structurePos)))), object -> new StructureData(chunkPos, (Int2ObjectMap<class_2338>)new Int2ObjectArrayMap()))).structures().computeIfAbsent(structure, n -> this.calculateStructurePos(regionPos, structurePos, generationCheck))) == null) continue;
                    this.addFeatureWidget(guiGraphics, (MapFeature)((Object)feature), pos);
                }
            }
        });
        if (this.toggleableFeatures.contains((Object)MapFeature.STRONGHOLD) && Configs.ToggledFeatures.contains((Object)MapFeature.STRONGHOLD) && (tree = (TwoDTree)strongholdDataCache.get((Object)this.worldIdentifier)) != null) {
            biomeData = tree.iterator();
            while (biomeData.hasNext()) {
                class_2338 strongholdPos = (class_2338)biomeData.next();
                this.addFeatureWidget(guiGraphics, MapFeature.STRONGHOLD, strongholdPos);
            }
        }
        if ((this.toggleableFeatures.contains((Object)MapFeature.COPPER_ORE_VEIN) || this.toggleableFeatures.contains((Object)MapFeature.IRON_ORE_VEIN)) && (Configs.ToggledFeatures.contains((Object)MapFeature.COPPER_ORE_VEIN) || Configs.ToggledFeatures.contains((Object)MapFeature.IRON_ORE_VEIN))) {
            for (int relTileX = -horTileRadius; relTileX <= horTileRadius; ++relTileX) {
                for (int relTileZ = -verTileRadius; relTileZ <= verTileRadius; ++relTileZ) {
                    tilePos = new TilePos(centerTile.x() + relTileX, centerTile.z() + relTileZ);
                    OreVeinData oreVeinData = this.oreVeinCache.computeIfAbsent(tilePos, this::calculateOreVein);
                    if (oreVeinData == null || !Configs.ToggledFeatures.contains((Object)oreVeinData.oreVeinType())) continue;
                    this.addFeatureWidget(guiGraphics, oreVeinData.oreVeinType(), oreVeinData.blockPos());
                }
            }
        }
        if (this.toggleableFeatures.contains((Object)MapFeature.CANYON) && Configs.ToggledFeatures.contains((Object)MapFeature.CANYON)) {
            for (int relTileX = -horTileRadius; relTileX <= horTileRadius; ++relTileX) {
                for (int relTileZ = -verTileRadius; relTileZ <= verTileRadius; ++relTileZ) {
                    tilePos = new TilePos(centerTile.x() + relTileX, centerTile.z() + relTileZ);
                    class_1923 chunkPos = tilePos.toChunkPos();
                    BitSet canyonData = (BitSet)this.canyonCache.computeIfAbsent((Object)tilePos, this::calculateCanyonData);
                    canyonData.stream().forEach(i -> {
                        int relChunkX = i % 25;
                        int relChunkZ = i / 25;
                        int chunkX = chunkPos.field_9181 + relChunkX;
                        int chunkZ = chunkPos.field_9180 + relChunkZ;
                        this.addFeatureWidget(guiGraphics, MapFeature.CANYON, new class_2338(class_4076.method_18688((int)chunkX), 0, class_4076.method_18688((int)chunkZ)));
                    });
                }
            }
        }
        if (this.toggleableFeatures.contains((Object)MapFeature.WAYPOINT) && Configs.ToggledFeatures.contains((Object)MapFeature.WAYPOINT)) {
            SimpleWaypointsAPI waypointsApi = SimpleWaypointsAPI.getInstance();
            String identifier = waypointsApi.getWorldIdentifier(this.field_22787);
            Map worldWaypoints = waypointsApi.getWorldWaypoints(identifier);
            worldWaypoints.forEach((name, waypoint) -> {
                if (!waypoint.dimension().equals(DIM_ID_TO_MC.get((Object)this.dimension))) {
                    return;
                }
                FeatureWidget widget = this.addFeatureWidget(guiGraphics, MapFeature.WAYPOINT, waypoint.location());
                if (widget == null) {
                    return;
                }
                guiGraphics.method_25300(this.field_22793, name, widget.x + widget.width() / 2, widget.y + widget.height(), class_9848.method_61330((int)255, (int)waypoint.color()));
            });
        }
        int playerMinX = this.centerX + Configs.PixelsPerBiome * (class_5742.method_33100((int)this.playerPos.method_10263()) - this.centerQuart.x()) - 10;
        int playerMinY = this.centerY + Configs.PixelsPerBiome * (class_5742.method_33100((int)this.playerPos.method_10260()) - this.centerQuart.z()) - 10;
        int playerMaxX = playerMinX + 20;
        int playerMaxY = playerMinY + 20;
        if (playerMinX >= 50 && playerMaxX <= 50 + this.seedMapWidth && playerMinY >= 50 && playerMaxY <= 50 + this.seedMapHeight) {
            class_7532.method_52722((class_332)guiGraphics, (class_8685)this.field_22787.field_1724.method_52814(), (int)playerMinX, (int)playerMinY, (int)20);
        }
        if (this.toggleableFeatures.contains((Object)MapFeature.WORLD_SPAWN) && Configs.ToggledFeatures.contains((Object)MapFeature.WORLD_SPAWN)) {
            class_2338 spawnPoint = (class_2338)spawnDataCache.computeIfAbsent((Object)this.worldIdentifier, object -> this.calculateSpawnData());
            this.addFeatureWidget(guiGraphics, MapFeature.WORLD_SPAWN, spawnPoint);
        }
        if (this.markerWidget != null && this.markerWidget.withinBounds()) {
            FeatureWidget.drawFeatureIcon(guiGraphics, this.markerWidget.feature.getTexture(), this.markerWidget.x, this.markerWidget.y, -1);
        }
        if (this.chestLootWidget != null) {
            this.chestLootWidget.render(guiGraphics, mouseX, mouseY, this.field_22793);
        }
        class_5250 coordinates = ChatBuilder.accent("x: %d, z: %d".formatted(class_5742.method_33101((int)this.mouseQuart.x()), class_5742.method_33101((int)this.mouseQuart.z())));
        if (this.displayCoordinatesCopiedTicks > 0) {
            coordinates = class_2561.method_43469((String)"seedMap.coordinatesCopied", (Object[])new Object[]{coordinates});
        }
        guiGraphics.method_27535(this.field_22793, (class_2561)coordinates, 50, 50 + this.seedMapHeight + 1, -1);
    }

    private void drawTile(class_332 guiGraphics, Tile tile) {
        float v1;
        float v0;
        float u1;
        float u0;
        TilePos tilePos = tile.pos();
        QuartPos2 relQuartPos = QuartPos2.fromTilePos(tilePos).subtract(this.centerQuart);
        int tileSizePixels = TILE_SIZE_PIXELS.getAsInt();
        int minX = this.centerX + Configs.PixelsPerBiome * relQuartPos.x();
        int minY = this.centerY + Configs.PixelsPerBiome * relQuartPos.z();
        int maxX = minX + tileSizePixels;
        int maxY = minY + tileSizePixels;
        if (maxX < 50 || minX > 50 + this.seedMapWidth) {
            return;
        }
        if (maxY < 50 || minY > 50 + this.seedMapHeight) {
            return;
        }
        if (minX < 50) {
            u0 = (float)(50 - minX) / (float)tileSizePixels;
            minX = 50;
        } else {
            u0 = 0.0f;
        }
        if (maxX > 50 + this.seedMapWidth) {
            u1 = 1.0f - (float)(maxX - 50 - this.seedMapWidth) / (float)tileSizePixels;
            maxX = 50 + this.seedMapWidth;
        } else {
            u1 = 1.0f;
        }
        if (minY < 50) {
            v0 = (float)(50 - minY) / (float)tileSizePixels;
            minY = 50;
        } else {
            v0 = 0.0f;
        }
        if (maxY > 50 + this.seedMapHeight) {
            v1 = 1.0f - (float)(maxY - 50 - this.seedMapHeight) / (float)tileSizePixels;
            maxY = 50 + this.seedMapHeight;
        } else {
            v1 = 1.0f;
        }
        guiGraphics.method_70847(class_10799.field_56883, tile.texture().method_71659(), minX, minY, maxX, maxY, u0, u1, v0, v1, -1);
    }

    private Tile createBiomeTile(TilePos tilePos, int[] biomeData) {
        Tile tile = new Tile(tilePos, this.seed, this.dimension);
        class_1043 texture = tile.texture();
        int width = texture.method_4525().method_4307();
        int height = texture.method_4525().method_4323();
        for (int relX = 0; relX < width; ++relX) {
            for (int relZ = 0; relZ < height; ++relZ) {
                int biome = biomeData[relX + relZ * width];
                texture.method_4525().method_61941(relX, relZ, biomeColours[biome]);
            }
        }
        texture.method_4524();
        return tile;
    }

    private Tile createSlimeChunkTile(TilePos tilePos, BitSet slimeChunkData) {
        Tile tile = new Tile(tilePos, this.seed, this.dimension);
        class_1043 texture = tile.texture();
        for (int relChunkX = 0; relChunkX < 25; ++relChunkX) {
            for (int relChunkZ = 0; relChunkZ < 25; ++relChunkZ) {
                boolean isSlimeChunk = slimeChunkData.get(relChunkX + relChunkZ * 25);
                if (!isSlimeChunk) continue;
                texture.method_4525().method_4326(4 * relChunkX, 4 * relChunkZ, 4, 4, -16711936);
            }
        }
        texture.method_4524();
        return tile;
    }

    @Nullable
    private FeatureWidget addFeatureWidget(class_332 guiGraphics, MapFeature feature, class_2338 pos) {
        FeatureWidget widget = new FeatureWidget(feature, pos);
        if (!widget.withinBounds()) {
            return null;
        }
        this.featureWidgets.add((Object)widget);
        FeatureWidget.drawFeatureIcon(guiGraphics, feature.getTexture(), widget.x, widget.y, -1);
        return widget;
    }

    private void createFeatureToggles() {
        int rows = Math.ceilDiv(this.featureIconsCombinedWidth, this.seedMapWidth);
        int togglesPerRow = Math.ceilDiv(this.toggleableFeatures.size(), rows);
        int toggleMinY = 1;
        for (int row = 0; row < rows - 1; ++row) {
            this.createFeatureTogglesInner(row, togglesPerRow, togglesPerRow, 50, toggleMinY);
            toggleMinY += 21;
        }
        int togglesInLastRow = this.toggleableFeatures.size() - togglesPerRow * (rows - 1);
        this.createFeatureTogglesInner(rows - 1, togglesPerRow, togglesInLastRow, 50, toggleMinY);
    }

    private void createFeatureTogglesInner(int row, int togglesPerRow, int maxToggles, int toggleMinX, int toggleMinY) {
        for (int toggle = 0; toggle < maxToggles; ++toggle) {
            MapFeature feature = this.toggleableFeatures.get(row * togglesPerRow + toggle);
            MapFeature.Texture featureIcon = feature.getTexture();
            this.method_37063((class_364)new FeatureToggleWidget(feature, toggleMinX, toggleMinY));
            toggleMinX += featureIcon.width() + 5;
        }
    }

    private int[] calculateBiomeData(TilePos tilePos) {
        QuartPos2 quartPos = QuartPos2.fromTilePos(tilePos);
        int rangeSize = 100;
        MemorySegment range = Range.allocate(this.arena);
        Range.scale(range, 4);
        Range.x(range, quartPos.x());
        Range.z(range, quartPos.z());
        Range.sx(range, rangeSize);
        Range.sz(range, rangeSize);
        Range.y(range, 63 / Range.scale(range));
        Range.sy(range, 1);
        long cacheSize = Cubiomes.getMinCacheSize(this.biomeGenerator, Range.scale(range), Range.sx(range), Range.sy(range), Range.sz(range));
        MemorySegment biomeIds = this.arena.allocate(Cubiomes.C_INT, cacheSize);
        if (Cubiomes.genBiomes(this.biomeGenerator, biomeIds, range) == 0) {
            return biomeIds.toArray(Cubiomes.C_INT);
        }
        throw new RuntimeException("Cubiomes.genBiomes() failed!");
    }

    private BitSet calculateSlimeChunkData(TilePos tilePos) {
        BitSet slimeChunks = new BitSet(625);
        class_1923 chunkPos = tilePos.toChunkPos();
        for (int relChunkX = 0; relChunkX < 25; ++relChunkX) {
            for (int relChunkZ = 0; relChunkZ < 25; ++relChunkZ) {
                class_5819 random = class_2919.method_12662((int)(chunkPos.field_9181 + relChunkX), (int)(chunkPos.field_9180 + relChunkZ), (long)this.seed, (long)987234911L);
                slimeChunks.set(relChunkX + relChunkZ * 25, random.method_43048(10) == 0);
            }
        }
        return slimeChunks;
    }

    @Nullable
    private class_2338 calculateStructurePos(RegionPos regionPos, MemorySegment structurePos, StructureChecks.GenerationCheck generationCheck) {
        if (!generationCheck.check(this.structureGenerator, this.surfaceNoise, regionPos.x(), regionPos.z(), structurePos)) {
            return null;
        }
        return new class_2338(Pos.x(structurePos), 0, Pos.z(structurePos));
    }

    @Nullable
    private OreVeinData calculateOreVein(TilePos tilePos) {
        class_1923 chunkPos = tilePos.toChunkPos();
        for (int relChunkX = 0; relChunkX < 25; ++relChunkX) {
            for (int relChunkZ = 0; relChunkZ < 25; ++relChunkZ) {
                int minBlockX = class_4076.method_18688((int)(chunkPos.field_9181 + relChunkZ));
                int minBlockZ = class_4076.method_18688((int)(chunkPos.field_9180 + relChunkZ));
                class_5819 rnd = this.oreVeinRandom.method_38418(minBlockX, 0, minBlockZ);
                class_2338 pos = new class_2338(minBlockX + rnd.method_43048(16), 0, minBlockZ + rnd.method_43048(16));
                IntSet blocks = (IntSet)IntStream.rangeClosed(0, 27).map(y2 -> 4 * y2 + -60).map(y2 -> Cubiomes.getOreVeinBlockAt(pos.method_10263(), y2, pos.method_10260(), this.oreVeinParameters)).collect(IntArraySet::new, IntArraySet::add, AbstractIntCollection::addAll);
                if (blocks.contains(Cubiomes.RAW_COPPER_BLOCK())) {
                    return new OreVeinData(tilePos, MapFeature.COPPER_ORE_VEIN, pos);
                }
                if (blocks.contains(Cubiomes.RAW_IRON_BLOCK())) {
                    return new OreVeinData(tilePos, MapFeature.IRON_ORE_VEIN, pos);
                }
                if (blocks.contains(Cubiomes.COPPER_ORE())) {
                    return new OreVeinData(tilePos, MapFeature.COPPER_ORE_VEIN, pos);
                }
                if (blocks.contains(Cubiomes.IRON_ORE())) {
                    return new OreVeinData(tilePos, MapFeature.IRON_ORE_VEIN, pos);
                }
                if (blocks.contains(Cubiomes.GRANITE())) {
                    return new OreVeinData(tilePos, MapFeature.COPPER_ORE_VEIN, pos);
                }
                if (!blocks.contains(Cubiomes.TUFF())) continue;
                return new OreVeinData(tilePos, MapFeature.IRON_ORE_VEIN, pos);
            }
        }
        return null;
    }

    private BitSet calculateCanyonData(TilePos tilePos) {
        ToIntBiFunction<Integer, Integer> biomeFunction = this.version <= Cubiomes.MC_1_17() ? (chunkX, chunkZ) -> Cubiomes.getBiomeAt(this.biomeGenerator, 4, chunkX << 2, 0, chunkZ << 2) : (n, n2) -> -1;
        MemorySegment ccc = CanyonCarverConfig.allocate(this.arena);
        MemorySegment rnd = this.arena.allocate(Cubiomes.C_LONG_LONG);
        BitSet canyons = new BitSet(625);
        class_1923 chunkPos = tilePos.toChunkPos();
        for (int relChunkX = 0; relChunkX < 25; ++relChunkX) {
            block1: for (int relChunkZ = 0; relChunkZ < 25; ++relChunkZ) {
                int chunkX2 = chunkPos.field_9181 + relChunkX;
                int chunkZ2 = chunkPos.field_9180 + relChunkZ;
                for (int canyonCarver : CanyonCarverArgument.CANYON_CARVERS.values()) {
                    int biome;
                    if (Cubiomes.getCanyonCarverConfig(canyonCarver, this.version, ccc) == 0 || Cubiomes.isViableCanyonBiome(canyonCarver, biome = biomeFunction.applyAsInt(chunkX2, chunkZ2)) == 0 || Cubiomes.checkCanyonStart(this.seed, chunkX2, chunkZ2, ccc, rnd) == 0) continue;
                    canyons.set(relChunkX + relChunkZ * 25);
                    continue block1;
                }
            }
        }
        return canyons;
    }

    private class_2338 calculateSpawnData() {
        MemorySegment pos = Cubiomes.getSpawn(this.arena, this.biomeGenerator);
        return new class_2338(Pos.x(pos), 0, Pos.z(pos));
    }

    private void createTeleportField() {
        this.teleportEditBoxX = new class_342(this.field_22793, this.field_22789 / 2 - 70, 50 + this.seedMapHeight + 1, 70, 20, (class_2561)class_2561.method_43471((String)"seedMap.teleportEditBoxX"));
        this.teleportEditBoxX.method_47404((class_2561)class_2561.method_43470((String)"X"));
        this.teleportEditBoxX.method_1880(9);
        this.method_37063((class_364)this.teleportEditBoxX);
        this.teleportEditBoxZ = new class_342(this.field_22793, this.field_22789 / 2, 50 + this.seedMapHeight + 1, 70, 20, (class_2561)class_2561.method_43471((String)"seedMap.teleportEditBoxZ"));
        this.teleportEditBoxZ.method_47404((class_2561)class_2561.method_43470((String)"Z"));
        this.teleportEditBoxZ.method_1880(9);
        this.method_37063((class_364)this.teleportEditBoxZ);
    }

    private void createWaypointNameField() {
        this.waypointNameEditBox = new class_342(this.field_22793, 50 + this.seedMapWidth - 100, 50 + this.seedMapHeight + 1, 100, 20, (class_2561)class_2561.method_43471((String)"seedMap.waypointNameEditBox"));
        this.waypointNameEditBox.method_47404((class_2561)class_2561.method_43470((String)"Waypoint name"));
        this.method_37063((class_364)this.waypointNameEditBox);
    }

    private void moveCenter(QuartPos2 newCenter) {
        this.centerQuart = newCenter;
        this.featureWidgets.removeIf(widget -> {
            widget.updatePosition();
            return !widget.withinBounds();
        });
        if (this.markerWidget != null) {
            this.markerWidget.updatePosition();
        }
    }

    public void method_25393() {
        super.method_25393();
        if (this.displayCoordinatesCopiedTicks > 0) {
            --this.displayCoordinatesCopiedTicks;
        }
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        super.method_25410(minecraft, width, height);
        this.moveCenter(this.centerQuart);
        this.chestLootWidget = null;
    }

    public void method_16014(double mouseX, double mouseY) {
        this.handleMapMouseMoved(mouseX, mouseY);
    }

    private void handleMapMouseMoved(double mouseX, double mouseY) {
        if (mouseX < 50.0 || mouseX > (double)(50 + this.seedMapWidth) || mouseY < 50.0 || mouseY > (double)(50 + this.seedMapHeight)) {
            return;
        }
        int relXQuart = (int)((mouseX - (double)this.centerX) / (double)Configs.PixelsPerBiome);
        int relZQuart = (int)((mouseY - (double)this.centerY) / (double)Configs.PixelsPerBiome);
        this.mouseQuart = this.centerQuart.add(relXQuart, relZQuart);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.method_25401(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        float currentScroll = class_3532.method_15363((float)((float)Configs.PixelsPerBiome / 100.0f), (float)0.0f, (float)1.0f);
        currentScroll = class_3532.method_15363((float)(currentScroll - (float)(-scrollY / 100.0)), (float)0.0f, (float)1.0f);
        Configs.PixelsPerBiome = Math.max((int)((double)(currentScroll * 100.0f) + 0.5), 1);
        if (this.markerWidget != null) {
            this.markerWidget.updatePosition();
        }
        return true;
    }

    public boolean method_25403(class_11909 mouseButtonEvent, double dragX, double dragY) {
        int button = mouseButtonEvent.method_74245();
        if (button != 0) {
            return false;
        }
        double mouseX = mouseButtonEvent.comp_4798();
        double mouseY = mouseButtonEvent.comp_4799();
        if (mouseX < 50.0 || mouseX > (double)(50 + this.seedMapWidth) || mouseY < 50.0 || mouseY > (double)(50 + this.seedMapHeight)) {
            return false;
        }
        int relXQuart = (int)(-dragX / (double)Configs.PixelsPerBiome);
        int relZQuart = (int)(-dragY / (double)Configs.PixelsPerBiome);
        this.moveCenter(this.centerQuart.add(relXQuart, relZQuart));
        return true;
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean doubleClick) {
        if (super.method_25402(mouseButtonEvent, doubleClick)) {
            return true;
        }
        int button = mouseButtonEvent.method_74245();
        if (this.chestLootWidget != null && this.chestLootWidget.mouseClicked(mouseButtonEvent, doubleClick)) {
            return true;
        }
        if (button == 0) {
            this.chestLootWidget = null;
        }
        if (this.handleMapFeatureLeftClicked(mouseButtonEvent, doubleClick)) {
            return true;
        }
        if (this.handleMapMiddleClicked(mouseButtonEvent, doubleClick)) {
            return true;
        }
        return this.handleMapRightClicked(mouseButtonEvent, doubleClick);
    }

    private boolean handleMapFeatureLeftClicked(class_11909 mouseButtonEvent, boolean doubleClick) {
        int button = mouseButtonEvent.method_74245();
        if (button != 0) {
            return false;
        }
        double mouseX = mouseButtonEvent.comp_4798();
        double mouseY = mouseButtonEvent.comp_4799();
        if (mouseX < 50.0 || mouseX > (double)(50 + this.seedMapWidth) || mouseY < 50.0 || mouseY > (double)(50 + this.seedMapHeight)) {
            return false;
        }
        Optional<FeatureWidget> optionalFeatureWidget = this.featureWidgets.stream().filter(widget -> mouseX >= (double)widget.x && mouseX <= (double)(widget.x + widget.width()) && mouseY >= (double)widget.y && mouseY <= (double)(widget.y + widget.height())).findAny();
        if (optionalFeatureWidget.isEmpty()) {
            return false;
        }
        FeatureWidget widget2 = optionalFeatureWidget.get();
        this.showLoot(widget2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showLoot(FeatureWidget widget) {
        MapFeature feature = widget.feature;
        int structure = feature.getStructureId();
        if (!LocateCommand.LOOT_SUPPORTED_STRUCTURES.contains(structure)) {
            return;
        }
        class_2338 pos = widget.featureLocation;
        int biome = Cubiomes.getBiomeAt(this.biomeGenerator, 4, class_5742.method_33100((int)pos.method_10263()), class_5742.method_33100((int)320), class_5742.method_33100((int)pos.method_10260()));
        try (Arena tempArena = Arena.ofConfined();){
            MemorySegment structureVariant = StructureVariant.allocate(tempArena);
            Cubiomes.getVariant(structureVariant, structure, this.version, this.seed, pos.method_10263(), pos.method_10260(), biome);
            biome = StructureVariant.biome(structureVariant) != -1 ? (int)StructureVariant.biome(structureVariant) : biome;
            MemorySegment structureSaltConfig = StructureSaltConfig.allocate(tempArena);
            if (Cubiomes.getStructureSaltConfig(structure, this.version, biome, structureSaltConfig) == 0) {
                return;
            }
            MemorySegment pieces = Piece.allocateArray(StructureChecks.MAX_END_CITY_AND_FORTRESS_PIECES, tempArena);
            int numPieces = Cubiomes.getStructurePieces(pieces, StructureChecks.MAX_END_CITY_AND_FORTRESS_PIECES, structure, structureSaltConfig, structureVariant, this.version, this.seed, pos.method_10263(), pos.method_10260());
            if (numPieces <= 0) {
                return;
            }
            ArrayList<ChestLootData> chestLootDataList = new ArrayList<ChestLootData>();
            for (int pieceIdx = 0; pieceIdx < numPieces; ++pieceIdx) {
                MemorySegment piece = Piece.asSlice(pieces, pieceIdx);
                int chestCount = Piece.chestCount(piece);
                if (chestCount == 0) continue;
                String pieceName = Piece.name(piece).getString(0L);
                MemorySegment chestPoses = Piece.chestPoses(piece);
                MemorySegment lootTables = Piece.lootTables(piece);
                MemorySegment lootSeeds = Piece.lootSeeds(piece);
                for (int chestIdx = 0; chestIdx < chestCount; ++chestIdx) {
                    MemorySegment lootTable = lootTables.getAtIndex(ValueLayout.ADDRESS, (long)chestIdx).reinterpret(Long.MAX_VALUE);
                    String lootTableString = lootTable.getString(0L);
                    MemorySegment lootTableContext = LootTableContext.allocate(tempArena);
                    try {
                        if (Cubiomes.init_loot_table_name(lootTableContext, lootTable, this.version) == 0) continue;
                        MemorySegment chestPosInternal = Pos.asSlice(chestPoses, chestIdx);
                        class_2338 chestPos = new class_2338(Pos.x(chestPosInternal), 0, Pos.z(chestPosInternal));
                        long lootSeed = lootSeeds.getAtIndex(Cubiomes.C_LONG_LONG, (long)chestIdx);
                        Cubiomes.set_loot_seed(lootTableContext, lootSeed);
                        Cubiomes.generate_loot(lootTableContext);
                        int lootCount = LootTableContext.generated_item_count(lootTableContext);
                        class_1277 container = new class_1277(27);
                        for (int lootIdx = 0; lootIdx < lootCount; ++lootIdx) {
                            MemorySegment itemStackInternal = ItemStack.asSlice(LootTableContext.generated_items(lootTableContext), lootIdx);
                            int itemId = Cubiomes.get_global_item_id(lootTableContext, ItemStack.item(itemStackInternal));
                            class_1792 item = ItemAndEnchantmentsPredicateArgument.ITEM_ID_TO_MC.get(itemId);
                            class_1799 itemStack = new class_1799((class_1935)item, ItemStack.count(itemStackInternal));
                            MemorySegment enchantments = ItemStack.enchantments(itemStackInternal);
                            int enchantmentCount = ItemStack.enchantment_count(itemStackInternal);
                            for (int enchantmentIdx = 0; enchantmentIdx < enchantmentCount; ++enchantmentIdx) {
                                MemorySegment enchantInstance = EnchantInstance.asSlice(enchantments, enchantmentIdx);
                                int itemEnchantment = EnchantInstance.enchantment(enchantInstance);
                                class_5321<class_1887> enchantmentResourceKey = ItemAndEnchantmentsPredicateArgument.ENCHANTMENT_ID_TO_MC.get(itemEnchantment);
                                class_6880.class_6883 enchantmentReference = this.enchantmentsRegistry.method_46747(enchantmentResourceKey);
                                itemStack.method_7978((class_6880)enchantmentReference, EnchantInstance.level(enchantInstance));
                            }
                            container.method_5491(itemStack);
                        }
                        chestLootDataList.add(new ChestLootData(structure, pieceName, chestPos, lootSeed, lootTableString, container));
                        continue;
                    }
                    finally {
                        Cubiomes.free_loot_table_pools(lootTableContext);
                    }
                }
            }
            if (!chestLootDataList.isEmpty()) {
                this.chestLootWidget = new ChestLootWidget(widget.x + widget.width() / 2, widget.y + widget.height() / 2, chestLootDataList);
            }
        }
    }

    private boolean handleMapMiddleClicked(class_11909 mouseButtonEvent, boolean doubleClick) {
        int button = mouseButtonEvent.method_74245();
        if (button != 2) {
            return false;
        }
        double mouseX = mouseButtonEvent.comp_4798();
        double mouseY = mouseButtonEvent.comp_4799();
        if (mouseX < 50.0 || mouseX > (double)(50 + this.seedMapWidth) || mouseY < 50.0 || mouseY > (double)(50 + this.seedMapHeight)) {
            return false;
        }
        this.field_22787.field_1774.method_1455("%d ~ %d".formatted(class_5742.method_33101((int)this.mouseQuart.x()), class_5742.method_33101((int)this.mouseQuart.z())));
        this.displayCoordinatesCopiedTicks = 20;
        return true;
    }

    private boolean handleMapRightClicked(class_11909 mouseButtonEvent, boolean doubleClick) {
        int button = mouseButtonEvent.method_74245();
        if (button != 1) {
            return false;
        }
        double mouseX = mouseButtonEvent.comp_4798();
        double mouseY = mouseButtonEvent.comp_4799();
        if (mouseX < 50.0 || mouseX > (double)(50 + this.seedMapWidth) || mouseY < 50.0 || mouseY > (double)(50 + this.seedMapHeight)) {
            return false;
        }
        this.markerWidget = new FeatureWidget(MapFeature.WAYPOINT, this.mouseQuart.toBlockPos().method_33096(63));
        return true;
    }

    public boolean method_25404(class_11908 keyEvent) {
        if (super.method_25404(keyEvent)) {
            return true;
        }
        if (this.handleTeleportFieldEnter(keyEvent)) {
            return true;
        }
        return this.handleWaypointNameFieldEnter(keyEvent);
    }

    private boolean handleTeleportFieldEnter(class_11908 keyEvent) {
        int z;
        int x;
        int keyCode = keyEvent.comp_4795();
        if (keyCode != 257) {
            return false;
        }
        if (!this.teleportEditBoxX.method_37303() && !this.teleportEditBoxZ.method_37303()) {
            return false;
        }
        try {
            x = Integer.parseInt(this.teleportEditBoxX.method_1882());
            z = Integer.parseInt(this.teleportEditBoxZ.method_1882());
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (x < -30000000 || x > 30000000) {
            return false;
        }
        if (z < -30000000 || z > 30000000) {
            return false;
        }
        this.moveCenter(new QuartPos2(class_5742.method_33100((int)x), class_5742.method_33100((int)z)));
        this.teleportEditBoxX.method_1852("");
        this.teleportEditBoxZ.method_1852("");
        return true;
    }

    private boolean handleWaypointNameFieldEnter(class_11908 keyEvent) {
        int keyCode = keyEvent.comp_4795();
        if (keyCode != 257) {
            return false;
        }
        if (this.markerWidget == null) {
            return false;
        }
        if (!this.waypointNameEditBox.method_37303()) {
            return false;
        }
        String waypointName = this.waypointNameEditBox.method_1882().trim();
        if (waypointName.isEmpty()) {
            return false;
        }
        SimpleWaypointsAPI waypointsApi = SimpleWaypointsAPI.getInstance();
        String identifier = waypointsApi.getWorldIdentifier(this.field_22787);
        if (identifier == null) {
            return false;
        }
        try {
            waypointsApi.addWaypoint(identifier, (class_5321)DIM_ID_TO_MC.get((Object)this.dimension), waypointName, this.markerWidget.featureLocation);
        }
        catch (CommandSyntaxException e) {
            class_746 player = this.field_22787.field_1724;
            if (player != null) {
                player.method_7353((class_2561)ChatBuilder.error((class_5250)e.getRawMessage()), false);
            }
            return false;
        }
        this.waypointNameEditBox.method_1852("");
        return true;
    }

    public void method_25419() {
        super.method_25419();
        this.biomeTileCache.values().forEach(Tile::close);
        this.slimeChunkTileCache.values().forEach(Tile::close);
        this.seedMapExecutor.close(this.arena::close);
        Configs.save();
    }

    private /* synthetic */ Tile lambda$render$14(TilePos tilePos, int[] biomeData, Object object) {
        return this.createBiomeTile(tilePos, biomeData);
    }

    static {
        SequenceLayout rgbLayout = MemoryLayout.sequenceLayout(3L, Cubiomes.C_CHAR);
        try (Arena arena = Arena.ofConfined();){
            MemorySegment biomeColoursInternal = arena.allocate(rgbLayout, biomeColours.length);
            Cubiomes.initBiomeColors(biomeColoursInternal);
            for (int biome = 0; biome < biomeColours.length; ++biome) {
                int colour;
                MemorySegment colourArray = biomeColoursInternal.asSlice((long)biome * rgbLayout.byteSize());
                int red = colourArray.getAtIndex(Cubiomes.C_CHAR, 0L) & 0xFF;
                int green = colourArray.getAtIndex(Cubiomes.C_CHAR, 1L) & 0xFF;
                int blue = colourArray.getAtIndex(Cubiomes.C_CHAR, 2L) & 0xFF;
                SeedMapScreen.biomeColours[biome] = colour = class_9848.method_61323((int)red, (int)green, (int)blue);
            }
        }
        TILE_SIZE_PIXELS = () -> 100 * Configs.PixelsPerBiome;
        biomeDataCache = new Object2ObjectOpenHashMap();
        structureDataCache = new Object2ObjectOpenHashMap();
        strongholdDataCache = new Object2ObjectOpenHashMap();
        oreVeinDataCache = new Object2ObjectOpenHashMap();
        canyonDataCache = new Object2ObjectOpenHashMap();
        slimeChunkDataCache = new Object2ObjectOpenHashMap();
        spawnDataCache = new Object2ObjectOpenHashMap();
        DIM_ID_TO_MC = ImmutableBiMap.of((Object)Cubiomes.DIM_OVERWORLD(), (Object)class_1937.field_25179, (Object)Cubiomes.DIM_NETHER(), (Object)class_1937.field_25180, (Object)Cubiomes.DIM_END(), (Object)class_1937.field_25181);
    }

    class FeatureWidget {
        private int x;
        private int y;
        private final MapFeature feature;
        private final class_2338 featureLocation;

        public FeatureWidget(MapFeature feature, class_2338 featureLocation) {
            this.feature = feature;
            this.featureLocation = featureLocation;
            this.updatePosition();
        }

        private void updatePosition() {
            this.x = SeedMapScreen.this.centerX + Configs.PixelsPerBiome * (class_5742.method_33100((int)this.featureLocation.method_10263()) - SeedMapScreen.this.centerQuart.x()) - this.feature.getTexture().width() / 2;
            this.y = SeedMapScreen.this.centerY + Configs.PixelsPerBiome * (class_5742.method_33100((int)this.featureLocation.method_10260()) - SeedMapScreen.this.centerQuart.z()) - this.feature.getTexture().height() / 2;
        }

        private int width() {
            return this.feature.getTexture().width();
        }

        private int height() {
            return this.feature.getTexture().height();
        }

        private boolean withinBounds() {
            int minX = this.x;
            int minY = this.y;
            int maxX = minX + this.width();
            int maxY = minY + this.height();
            if (maxX >= 50 + SeedMapScreen.this.seedMapWidth || maxY >= 50 + SeedMapScreen.this.seedMapHeight) {
                return false;
            }
            return minX >= 50 && minY >= 50;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.feature, this.featureLocation});
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeatureWidget that = (FeatureWidget)o;
            return this.feature == that.feature && Objects.equals(this.featureLocation, that.featureLocation);
        }

        static void drawFeatureIcon(class_332 guiGraphics, MapFeature.Texture texture, int minX, int minY, int colour) {
            int iconWidth = texture.width();
            int iconHeight = texture.height();
            guiGraphics.method_25291(class_10799.field_56883, texture.resourceLocation(), minX, minY, 0.0f, 0.0f, iconWidth, iconHeight, iconWidth, iconHeight, colour);
        }
    }
}

