/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.thread;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import dev.xpple.seedmapper.command.CommandExceptions;
import dev.xpple.seedmapper.util.ChatBuilder;
import dev.xpple.seedmapper.util.CheckedSupplier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.slf4j.Logger;

public final class LocatorThreadHelper {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ExecutorService locatingExecutor = Executors.newCachedThreadPool();
    private static Future<Integer> currentTask = null;
    public static final class_2561 STOP_TASK_COMPONENT = ChatBuilder.run(ChatBuilder.hover(ChatBuilder.format(class_2561.method_43471((String)"commands.exceptions.alreadyBusyLocating.stopTask"), class_124.field_1073), ChatBuilder.base(class_2561.method_43471((String)"commands.exceptions.alreadyBusyLocating.clickToStop"))), LocatorThreadHelper::stop);

    private LocatorThreadHelper() {
    }

    public static int submit(CheckedSupplier<Integer, CommandSyntaxException> task) throws CommandSyntaxException {
        if (currentTask != null && !currentTask.isDone()) {
            throw CommandExceptions.ALREADY_BUSY_LOCATING_EXCEPTION.create();
        }
        currentTask = locatingExecutor.submit(() -> {
            try {
                return (Integer)task.get();
            }
            catch (Throwable e) {
                class_746 player = class_310.method_1551().field_1724;
                if (e instanceof CommandSyntaxException) {
                    CommandSyntaxException cse = (CommandSyntaxException)e;
                    if (player != null) {
                        class_310.method_1551().method_63588(() -> LocatorThreadHelper.lambda$submit$0((class_1657)player, cse));
                    }
                } else {
                    LOGGER.error("An error occurred while executing one of SeedMapper's tasks!", e);
                    if (player != null) {
                        class_310.method_1551().method_63588(() -> LocatorThreadHelper.lambda$submit$1((class_1657)player));
                    }
                }
                return 0;
            }
        });
        class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"command.locate.taskStarted"), false);
        return 1;
    }

    public static void stop() {
        if (currentTask != null && !currentTask.isDone()) {
            currentTask.cancel(true);
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"command.locate.taskStopped"), false);
        } else {
            class_310.method_1551().field_1724.method_7353((class_2561)ChatBuilder.error(class_2561.method_43471((String)"command.locate.noTaskRunning")), false);
        }
    }

    private static /* synthetic */ void lambda$submit$1(class_1657 player) {
        player.method_7353((class_2561)ChatBuilder.error(class_2561.method_43471((String)"commands.exceptions.unknownError")), false);
    }

    private static /* synthetic */ void lambda$submit$0(class_1657 player, CommandSyntaxException cse) {
        player.method_7353((class_2561)ChatBuilder.error((class_5250)cse.getRawMessage()), false);
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(locatingExecutor::shutdownNow));
    }
}

