/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.thread;

import dev.xpple.seedmapper.thread.SeedMapExecutor;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectSets;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class SeedMapCache<K, V> {
    private final ObjectSet<K> pendingCalculations = ObjectSets.synchronize((ObjectSet)new ObjectOpenHashSet());
    private final Object2ObjectMap<K, V> cache;
    private final SeedMapExecutor executor;

    public SeedMapCache(Object2ObjectMap<K, V> cache, SeedMapExecutor executor) {
        this.cache = cache;
        this.executor = executor;
    }

    @Nullable
    public V computeIfAbsent(K key, Function<K, V> mappingFunction) {
        Object value = this.cache.get(key);
        if (value != null) {
            return (V)value;
        }
        if (!this.pendingCalculations.add(key)) {
            return null;
        }
        this.executor.submitCalculation(() -> mappingFunction.apply(key)).thenAccept(data -> {
            if (data != null) {
                this.cache.put(key, data);
                this.pendingCalculations.remove(key);
            }
        });
        return null;
    }
}

