/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import org.slf4j.Logger;

public final class BuildInfo {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String VERSION;
    public static final String BRANCH;
    public static final String SHORT_COMMIT_HASH;
    public static final String COMMIT_HASH;

    private BuildInfo() {
    }

    static {
        String commitHash = "unknown";
        String shortCommitHash = "unknown";
        String branch = "unknown";
        String version = "unknown";
        try (BufferedReader reader = Files.newBufferedReader((Path)((ModContainer)FabricLoader.getInstance().getModContainer("seedmapper").orElseThrow()).findPath("build_info.json").orElseThrow());){
            JsonObject object = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            version = object.get("version").getAsString();
            branch = object.get("branch").getAsString();
            shortCommitHash = object.get("shortCommitHash").getAsString();
            commitHash = object.get("commitHash").getAsString();
        }
        catch (IOException | RuntimeException e) {
            LOGGER.error("Error while reading build_info.json", (Throwable)e);
        }
        VERSION = version;
        BRANCH = branch;
        SHORT_COMMIT_HASH = shortCommitHash;
        COMMIT_HASH = commitHash;
    }
}

