/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.util;

import dev.xpple.seedmapper.seedmap.TilePos;
import dev.xpple.seedmapper.util.QuartPos2;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_4076;
import net.minecraft.class_5742;

public record RegionPos(int x, int z, int regionSizeChunks) {
    public static RegionPos fromBlockPos(class_2338 blockPos, int regionSizeChunks) {
        return new RegionPos(class_4076.method_18675((int)blockPos.method_10263()) / regionSizeChunks, class_4076.method_18675((int)blockPos.method_10260()) / regionSizeChunks, regionSizeChunks);
    }

    public class_2338 toBlockPos() {
        return new class_2338(class_4076.method_18688((int)(this.x * this.regionSizeChunks)), 0, class_4076.method_18688((int)(this.z * this.regionSizeChunks)));
    }

    public static RegionPos fromQuartPos(QuartPos2 quartPos, int regionSizeChunks) {
        return new RegionPos(class_5742.method_33103((int)quartPos.x()) / regionSizeChunks, class_5742.method_33103((int)quartPos.z()) / regionSizeChunks, regionSizeChunks);
    }

    public static RegionPos fromChunkPos(class_1923 chunkPos, int regionSizeChunks) {
        return new RegionPos(chunkPos.field_9181 / regionSizeChunks, chunkPos.field_9180 / regionSizeChunks, regionSizeChunks);
    }

    public class_1923 toChunkPos() {
        return new class_1923(this.x * this.regionSizeChunks, this.z * this.regionSizeChunks);
    }

    public static RegionPos fromTilePos(TilePos tilePos, int regionSize) {
        return new RegionPos(25 * tilePos.x() / regionSize, 25 * tilePos.z() / regionSize, regionSize);
    }

    public RegionPos add(RegionPos regionPos) {
        this.checkRegionSize(regionPos.regionSizeChunks);
        return this.add(regionPos.x, regionPos.z);
    }

    public RegionPos add(int regionX, int regionZ) {
        return new RegionPos(this.x + regionX, this.z + regionZ, this.regionSizeChunks);
    }

    public RegionPos subtract(RegionPos regionPos) {
        this.checkRegionSize(regionPos.regionSizeChunks);
        return this.add(-regionPos.x, -regionPos.z);
    }

    private void checkRegionSize(int regionSizeChunks) {
        if (this.regionSizeChunks != regionSizeChunks) {
            throw new IllegalArgumentException("Region sizes must match (expected %d , got %d)".formatted(this.regionSizeChunks, regionSizeChunks));
        }
    }
}

