/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper;

import com.google.gson.TypeAdapter;
import com.mojang.brigadier.CommandDispatcher;
import dev.xpple.betterconfig.api.ModConfigBuilder;
import dev.xpple.seedmapper.command.arguments.SeedResolutionArgument;
import dev.xpple.seedmapper.command.commands.BuildInfoCommand;
import dev.xpple.seedmapper.command.commands.CheckSeedCommand;
import dev.xpple.seedmapper.command.commands.ClearCommand;
import dev.xpple.seedmapper.command.commands.HighlightCommand;
import dev.xpple.seedmapper.command.commands.LocateCommand;
import dev.xpple.seedmapper.command.commands.SourceCommand;
import dev.xpple.seedmapper.config.Configs;
import dev.xpple.seedmapper.config.SeedResolutionAdapter;
import dev.xpple.seedmapper.render.RenderManager;
import dev.xpple.seedmapper.util.SeedDatabaseHelper;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_7157;

public class SeedMapper
implements ClientModInitializer {
    public static final String MOD_ID = "seedmapper";
    public static final Path modConfigPath;

    public void onInitializeClient() {
        new ModConfigBuilder(MOD_ID, Configs.class).registerType(SeedResolutionArgument.SeedResolution.class, (TypeAdapter)new SeedResolutionAdapter(), SeedResolutionArgument::seedResolution).build();
        SeedDatabaseHelper.fetchSeeds();
        ClientCommandRegistrationCallback.EVENT.register(SeedMapper::registerCommands);
        RenderManager.registerEvents();
    }

    private static void registerCommands(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 context) {
        LocateCommand.register(dispatcher);
        SourceCommand.register(dispatcher);
        CheckSeedCommand.register(dispatcher);
        BuildInfoCommand.register(dispatcher);
        HighlightCommand.register(dispatcher);
        ClearCommand.register(dispatcher);
    }

    static {
        Path tempFile;
        modConfigPath = FabricLoader.getInstance().getConfigDir().resolve(MOD_ID);
        String libraryName = System.mapLibraryName("cubiomes");
        ModContainer modContainer = (ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).orElseThrow();
        try {
            tempFile = Files.createTempFile(libraryName, "", new FileAttribute[0]);
            Files.copy((Path)modContainer.findPath(libraryName).orElseThrow(), tempFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.load(tempFile.toAbsolutePath().toString());
    }
}

