/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import dev.xpple.seedmapper.command.CommandExceptions;
import dev.xpple.seedmapper.command.arguments.DimensionArgument;
import dev.xpple.seedmapper.command.arguments.SeedResolutionArgument;
import dev.xpple.seedmapper.command.arguments.VersionArgument;
import dev.xpple.seedmapper.config.Configs;
import dev.xpple.seedmapper.util.SeedDatabaseHelper;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_155;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_637;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class CustomClientCommandSource
extends class_637
implements FabricClientCommandSource {
    private final class_310 client;
    private final class_1297 entity;
    private final class_243 position;
    private final class_241 rotation;
    private final class_638 world;
    private final Map<String, Object> meta;

    public CustomClientCommandSource(class_634 listener, class_310 minecraft, class_1297 entity, class_243 position, class_241 rotation, class_638 world, Map<String, Object> meta) {
        super(listener, minecraft);
        this.client = minecraft;
        this.entity = entity;
        this.position = position;
        this.rotation = rotation;
        this.world = world;
        this.meta = meta;
    }

    public static CustomClientCommandSource of(FabricClientCommandSource source) {
        if (source instanceof CustomClientCommandSource) {
            CustomClientCommandSource custom = (CustomClientCommandSource)source;
            return custom;
        }
        return new CustomClientCommandSource(source.getClient().method_1562(), source.getClient(), source.getEntity(), source.getPosition(), source.getRotation(), source.getWorld(), new HashMap<String, Object>());
    }

    public void sendFeedback(class_2561 message) {
        this.client.field_1705.method_1743().method_1812(message);
        this.client.method_44713().method_37015(message);
    }

    public void sendError(class_2561 message) {
        this.sendFeedback((class_2561)class_2561.method_43473().method_10852(message).method_27692(class_124.field_1061));
    }

    public class_310 getClient() {
        return this.client;
    }

    public class_746 getPlayer() {
        return this.getClient().field_1724;
    }

    public class_1297 getEntity() {
        return this.entity;
    }

    public class_243 getPosition() {
        return this.position;
    }

    public class_241 getRotation() {
        return this.rotation;
    }

    public class_638 getWorld() {
        return this.world;
    }

    public Object getMeta(String key) {
        return this.meta.get(key);
    }

    public CustomClientCommandSource withEntity(class_1297 entity) {
        return new CustomClientCommandSource(this.client.method_1562(), this.client, entity, this.position, this.rotation, this.world, this.meta);
    }

    public CustomClientCommandSource withPosition(class_243 position) {
        return new CustomClientCommandSource(this.client.method_1562(), this.client, this.entity, position, this.rotation, this.world, this.meta);
    }

    public CustomClientCommandSource withRotation(class_241 rotation) {
        return new CustomClientCommandSource(this.client.method_1562(), this.client, this.entity, this.position, rotation, this.world, this.meta);
    }

    public CustomClientCommandSource withWorld(class_638 world) {
        return new CustomClientCommandSource(this.client.method_1562(), this.client, this.entity, this.position, this.rotation, world, this.meta);
    }

    public CustomClientCommandSource withMeta(String key, Object value) {
        this.meta.put(key, value);
        return this;
    }

    public Pair<SeedResolutionArgument.SeedResolution.Method, Long> getSeed() throws CommandSyntaxException {
        for (SeedResolutionArgument.SeedResolution.Method method : Configs.SeedResolutionOrder) {
            Long seed;
            if ((seed = (switch (method) {
                default -> throw new MatchException(null, null);
                case SeedResolutionArgument.SeedResolution.Method.COMMAND_SOURCE -> (Long)this.getMeta("seed");
                case SeedResolutionArgument.SeedResolution.Method.SEED_CONFIG -> Configs.Seed;
                case SeedResolutionArgument.SeedResolution.Method.SAVED_SEEDS_CONFIG -> {
                    String key = this.client.method_1562().method_48296().method_10755().toString();
                    yield Configs.SavedSeeds.get(key);
                }
                case SeedResolutionArgument.SeedResolution.Method.ONLINE_DATABASE -> {
                    String key = this.client.method_1562().method_48296().method_10755().toString();
                    yield SeedDatabaseHelper.getSeed(key, this.getWorld().method_22385().field_20641);
                }
            })) == null) continue;
            return Pair.of((Object)((Object)method), (Object)seed);
        }
        throw CommandExceptions.NO_SEED_AVAILABLE_EXCEPTION.create();
    }

    public int getDimension() throws CommandSyntaxException {
        Object dimensionMeta = this.getMeta("dimension");
        if (dimensionMeta != null) {
            return (Integer)dimensionMeta;
        }
        return DimensionArgument.dimension().parse(new StringReader(this.getWorld().method_27983().method_29177().method_12832()));
    }

    public int getVersion() throws CommandSyntaxException {
        Object versionMeta = this.getMeta("version");
        if (versionMeta != null) {
            return (Integer)versionMeta;
        }
        return VersionArgument.version().parse(new StringReader(class_155.method_16673().method_48019()));
    }
}

