/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.command.arguments;

import com.github.cubiomes.Cubiomes;
import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.xpple.seedmapper.command.CommandExceptions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;

public class BiomeArgument
implements ArgumentType<Integer> {
    private static final Collection<String> EXAMPLES = Arrays.asList("desert", "crimson_forest", "giant_spruce_taiga_hills");
    static final Map<String, Integer> BIOMES = ImmutableMap.builder().put((Object)"ocean", (Object)Cubiomes.ocean()).put((Object)"plains", (Object)Cubiomes.plains()).put((Object)"desert", (Object)Cubiomes.desert()).put((Object)"mountains", (Object)Cubiomes.mountains()).put((Object)"forest", (Object)Cubiomes.forest()).put((Object)"taiga", (Object)Cubiomes.taiga()).put((Object)"swamp", (Object)Cubiomes.swamp()).put((Object)"river", (Object)Cubiomes.river()).put((Object)"nether_wastes", (Object)Cubiomes.nether_wastes()).put((Object)"the_end", (Object)Cubiomes.the_end()).put((Object)"frozen_ocean", (Object)Cubiomes.frozen_ocean()).put((Object)"frozen_river", (Object)Cubiomes.frozen_river()).put((Object)"snowy_tundra", (Object)Cubiomes.snowy_tundra()).put((Object)"snowy_mountains", (Object)Cubiomes.snowy_mountains()).put((Object)"mushroom_fields", (Object)Cubiomes.mushroom_fields()).put((Object)"mushroom_field_shore", (Object)Cubiomes.mushroom_field_shore()).put((Object)"beach", (Object)Cubiomes.beach()).put((Object)"desert_hills", (Object)Cubiomes.desert_hills()).put((Object)"wooded_hills", (Object)Cubiomes.wooded_hills()).put((Object)"taiga_hills", (Object)Cubiomes.taiga_hills()).put((Object)"mountain_edge", (Object)Cubiomes.mountain_edge()).put((Object)"jungle", (Object)Cubiomes.jungle()).put((Object)"jungle_hills", (Object)Cubiomes.jungle_hills()).put((Object)"jungle_edge", (Object)Cubiomes.jungle_edge()).put((Object)"deep_ocean", (Object)Cubiomes.deep_ocean()).put((Object)"stone_shore", (Object)Cubiomes.stone_shore()).put((Object)"snowy_beach", (Object)Cubiomes.snowy_beach()).put((Object)"birch_forest", (Object)Cubiomes.birch_forest()).put((Object)"birch_forest_hills", (Object)Cubiomes.birch_forest_hills()).put((Object)"dark_forest", (Object)Cubiomes.dark_forest()).put((Object)"snowy_taiga", (Object)Cubiomes.snowy_taiga()).put((Object)"snowy_taiga_hills", (Object)Cubiomes.snowy_taiga_hills()).put((Object)"giant_tree_taiga", (Object)Cubiomes.giant_tree_taiga()).put((Object)"giant_tree_taiga_hills", (Object)Cubiomes.giant_tree_taiga_hills()).put((Object)"wooded_mountains", (Object)Cubiomes.wooded_mountains()).put((Object)"savanna", (Object)Cubiomes.savanna()).put((Object)"savanna_plateau", (Object)Cubiomes.savanna_plateau()).put((Object)"badlands", (Object)Cubiomes.badlands()).put((Object)"wooded_badlands_plateau", (Object)Cubiomes.wooded_badlands_plateau()).put((Object)"badlands_plateau", (Object)Cubiomes.badlands_plateau()).put((Object)"small_end_islands", (Object)Cubiomes.small_end_islands()).put((Object)"end_midlands", (Object)Cubiomes.end_midlands()).put((Object)"end_highlands", (Object)Cubiomes.end_highlands()).put((Object)"end_barrens", (Object)Cubiomes.end_barrens()).put((Object)"warm_ocean", (Object)Cubiomes.warm_ocean()).put((Object)"lukewarm_ocean", (Object)Cubiomes.lukewarm_ocean()).put((Object)"cold_ocean", (Object)Cubiomes.cold_ocean()).put((Object)"deep_warm_ocean", (Object)Cubiomes.deep_warm_ocean()).put((Object)"deep_lukewarm_ocean", (Object)Cubiomes.deep_lukewarm_ocean()).put((Object)"deep_cold_ocean", (Object)Cubiomes.deep_cold_ocean()).put((Object)"deep_frozen_ocean", (Object)Cubiomes.deep_frozen_ocean()).put((Object)"seasonal_forest", (Object)Cubiomes.seasonal_forest()).put((Object)"rainforest", (Object)Cubiomes.rainforest()).put((Object)"shrubland", (Object)Cubiomes.shrubland()).put((Object)"the_void", (Object)Cubiomes.the_void()).put((Object)"sunflower_plains", (Object)Cubiomes.sunflower_plains()).put((Object)"desert_lakes", (Object)Cubiomes.desert_lakes()).put((Object)"gravelly_mountains", (Object)Cubiomes.gravelly_mountains()).put((Object)"flower_forest", (Object)Cubiomes.flower_forest()).put((Object)"taiga_mountains", (Object)Cubiomes.taiga_mountains()).put((Object)"swamp_hills", (Object)Cubiomes.swamp_hills()).put((Object)"ice_spikes", (Object)Cubiomes.ice_spikes()).put((Object)"modified_jungle", (Object)Cubiomes.modified_jungle()).put((Object)"modified_jungle_edge", (Object)Cubiomes.modified_jungle_edge()).put((Object)"tall_birch_forest", (Object)Cubiomes.tall_birch_forest()).put((Object)"tall_birch_hills", (Object)Cubiomes.tall_birch_hills()).put((Object)"dark_forest_hills", (Object)Cubiomes.dark_forest_hills()).put((Object)"snowy_taiga_mountains", (Object)Cubiomes.snowy_taiga_mountains()).put((Object)"giant_spruce_taiga", (Object)Cubiomes.giant_spruce_taiga()).put((Object)"giant_spruce_taiga_hills", (Object)Cubiomes.giant_spruce_taiga_hills()).put((Object)"modified_gravelly_mountains", (Object)Cubiomes.modified_gravelly_mountains()).put((Object)"shattered_savanna", (Object)Cubiomes.shattered_savanna()).put((Object)"shattered_savanna_plateau", (Object)Cubiomes.shattered_savanna_plateau()).put((Object)"eroded_badlands", (Object)Cubiomes.eroded_badlands()).put((Object)"modified_wooded_badlands_plateau", (Object)Cubiomes.modified_wooded_badlands_plateau()).put((Object)"modified_badlands_plateau", (Object)Cubiomes.modified_badlands_plateau()).put((Object)"bamboo_jungle", (Object)Cubiomes.bamboo_jungle()).put((Object)"bamboo_jungle_hills", (Object)Cubiomes.bamboo_jungle_hills()).put((Object)"soul_sand_valley", (Object)Cubiomes.soul_sand_valley()).put((Object)"crimson_forest", (Object)Cubiomes.crimson_forest()).put((Object)"warped_forest", (Object)Cubiomes.warped_forest()).put((Object)"basalt_deltas", (Object)Cubiomes.basalt_deltas()).put((Object)"dripstone_caves", (Object)Cubiomes.dripstone_caves()).put((Object)"lush_caves", (Object)Cubiomes.lush_caves()).put((Object)"meadow", (Object)Cubiomes.meadow()).put((Object)"grove", (Object)Cubiomes.grove()).put((Object)"snowy_slopes", (Object)Cubiomes.snowy_slopes()).put((Object)"jagged_peaks", (Object)Cubiomes.jagged_peaks()).put((Object)"frozen_peaks", (Object)Cubiomes.frozen_peaks()).put((Object)"stony_peaks", (Object)Cubiomes.stony_peaks()).put((Object)"old_growth_birch_forest", (Object)Cubiomes.old_growth_birch_forest()).put((Object)"old_growth_pine_taiga", (Object)Cubiomes.old_growth_pine_taiga()).put((Object)"old_growth_spruce_taiga", (Object)Cubiomes.old_growth_spruce_taiga()).put((Object)"snowy_plains", (Object)Cubiomes.snowy_plains()).put((Object)"sparse_jungle", (Object)Cubiomes.sparse_jungle()).put((Object)"stony_shore", (Object)Cubiomes.stony_shore()).put((Object)"windswept_hills", (Object)Cubiomes.windswept_hills()).put((Object)"windswept_forest", (Object)Cubiomes.windswept_forest()).put((Object)"windswept_gravelly_hills", (Object)Cubiomes.windswept_gravelly_hills()).put((Object)"windswept_savanna", (Object)Cubiomes.windswept_savanna()).put((Object)"wooded_badlands", (Object)Cubiomes.wooded_badlands()).put((Object)"deep_dark", (Object)Cubiomes.deep_dark()).put((Object)"mangrove_swamp", (Object)Cubiomes.mangrove_swamp()).put((Object)"cherry_grove", (Object)Cubiomes.cherry_grove()).put((Object)"pale_garden", (Object)Cubiomes.pale_garden()).build();

    public static BiomeArgument biome() {
        return new BiomeArgument();
    }

    public static int getBiome(CommandContext<FabricClientCommandSource> context, String name) {
        return (Integer)context.getArgument(name, Integer.class);
    }

    public Integer parse(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String biomeString = reader.readUnquotedString();
        Integer biome = BIOMES.get(biomeString);
        if (biome == null) {
            reader.setCursor(cursor);
            throw CommandExceptions.UNKNOWN_BIOME_EXCEPTION.create((Object)biomeString);
        }
        return biome;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(BIOMES.keySet(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

