/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.command.arguments;

import com.github.cubiomes.Cubiomes;
import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import dev.xpple.seedmapper.command.CommandExceptions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import net.minecraft.class_3620;

public class BlockArgument
implements ArgumentType<Pair<Integer, Integer>> {
    private static final Collection<String> EXAMPLES = Arrays.asList("diamond_ore", "gold_ore", "nether_quartz_ore");
    public static final Map<String, Pair<Integer, Integer>> BLOCKS = ImmutableMap.builder().put((Object)"ancient_debris", (Object)Pair.of((Object)Cubiomes.ANCIENT_DEBRIS(), (Object)class_3620.field_15992.field_16011)).put((Object)"andesite", (Object)Pair.of((Object)Cubiomes.ANDESITE(), (Object)class_3620.field_16023.field_16011)).put((Object)"basalt", (Object)Pair.of((Object)Cubiomes.BASALT(), (Object)class_3620.field_16009.field_16011)).put((Object)"blackstone", (Object)Pair.of((Object)Cubiomes.BLACKSTONE(), (Object)class_3620.field_16009.field_16011)).put((Object)"clay", (Object)Pair.of((Object)Cubiomes.CLAY(), (Object)class_3620.field_15976.field_16011)).put((Object)"coal_ore", (Object)Pair.of((Object)Cubiomes.COAL_ORE(), (Object)class_3620.field_16009.field_16011)).put((Object)"copper_ore", (Object)Pair.of((Object)Cubiomes.COPPER_ORE(), (Object)class_3620.field_15987.field_16011)).put((Object)"deepslate", (Object)Pair.of((Object)Cubiomes.DEEPSLATE(), (Object)class_3620.field_33532.field_16011)).put((Object)"diamond_ore", (Object)Pair.of((Object)Cubiomes.DIAMOND_ORE(), (Object)class_3620.field_15983.field_16011)).put((Object)"diorite", (Object)Pair.of((Object)Cubiomes.DIORITE(), (Object)class_3620.field_16025.field_16011)).put((Object)"dirt", (Object)Pair.of((Object)Cubiomes.DIRT(), (Object)class_3620.field_16000.field_16011)).put((Object)"emerald_ore", (Object)Pair.of((Object)Cubiomes.EMERALD_ORE(), (Object)class_3620.field_16001.field_16011)).put((Object)"gold_ore", (Object)Pair.of((Object)Cubiomes.GOLD_ORE(), (Object)class_3620.field_15994.field_16011)).put((Object)"granite", (Object)Pair.of((Object)Cubiomes.GRANITE(), (Object)class_3620.field_16000.field_16011)).put((Object)"gravel", (Object)Pair.of((Object)Cubiomes.GRAVEL(), (Object)class_3620.field_16023.field_16011)).put((Object)"iron_ore", (Object)Pair.of((Object)Cubiomes.IRON_ORE(), (Object)class_3620.field_33533.field_16011)).put((Object)"lapis_ore", (Object)Pair.of((Object)Cubiomes.LAPIS_ORE(), (Object)class_3620.field_15980.field_16011)).put((Object)"magma_block", (Object)Pair.of((Object)Cubiomes.MAGMA_BLOCK(), (Object)class_3620.field_16012.field_16011)).put((Object)"netherrack", (Object)Pair.of((Object)Cubiomes.NETHERRACK(), (Object)class_3620.field_16012.field_16011)).put((Object)"nether_gold_ore", (Object)Pair.of((Object)Cubiomes.NETHER_GOLD_ORE(), (Object)class_3620.field_15994.field_16011)).put((Object)"nether_quartz_ore", (Object)Pair.of((Object)Cubiomes.NETHER_QUARTZ_ORE(), (Object)class_3620.field_16025.field_16011)).put((Object)"redstone_ore", (Object)Pair.of((Object)Cubiomes.REDSTONE_ORE(), (Object)class_3620.field_16002.field_16011)).put((Object)"soul_sand", (Object)Pair.of((Object)Cubiomes.SOUL_SAND(), (Object)class_3620.field_15977.field_16011)).put((Object)"stone", (Object)Pair.of((Object)Cubiomes.STONE(), (Object)class_3620.field_16023.field_16011)).put((Object)"tuff", (Object)Pair.of((Object)Cubiomes.TUFF(), (Object)class_3620.field_15978.field_16011)).build();

    public static BlockArgument block() {
        return new BlockArgument();
    }

    public static Pair<Integer, Integer> getBlock(CommandContext<FabricClientCommandSource> context, String name) {
        return (Pair)context.getArgument(name, Pair.class);
    }

    public Pair<Integer, Integer> parse(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String blockString = reader.readUnquotedString();
        Pair<Integer, Integer> blockPair = BLOCKS.get(blockString);
        if (blockPair == null) {
            reader.setCursor(cursor);
            throw CommandExceptions.UNKNOWN_BLOCK_EXCEPTION.create((Object)blockString);
        }
        return blockPair;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(BLOCKS.keySet(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

