/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.command.arguments;

import com.github.cubiomes.Cubiomes;
import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.xpple.seedmapper.command.CommandExceptions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;

public class DimensionArgument
implements ArgumentType<Integer> {
    private static final Collection<String> EXAMPLES = Arrays.asList("overworld", "the_nether", "the_end");
    private static final Map<String, Integer> DIMENSIONS = ImmutableMap.builder().put((Object)"overworld", (Object)Cubiomes.DIM_OVERWORLD()).put((Object)"the_nether", (Object)Cubiomes.DIM_NETHER()).put((Object)"the_end", (Object)Cubiomes.DIM_END()).build();

    public static DimensionArgument dimension() {
        return new DimensionArgument();
    }

    public static int getDimension(CommandContext<FabricClientCommandSource> context, String name) {
        return (Integer)context.getArgument(name, Integer.class);
    }

    public Integer parse(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String dimensionString = reader.readUnquotedString();
        Integer dimension = DIMENSIONS.get(dimensionString);
        if (dimension == null) {
            reader.setCursor(cursor);
            throw CommandExceptions.UNKNOWN_DIMENSION_EXCEPTION.create((Object)dimensionString);
        }
        return dimension;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(DIMENSIONS.keySet(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

