/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.command.arguments;

import com.github.cubiomes.Cubiomes;
import com.github.cubiomes.Piece;
import com.github.cubiomes.StructureVariant;
import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import dev.xpple.seedmapper.command.CommandExceptions;
import dev.xpple.seedmapper.command.arguments.BiomeArgument;
import java.lang.foreign.MemorySegment;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;

public class StructurePredicateArgument
implements ArgumentType<StructureAndPredicate> {
    private static final Collection<String> EXAMPLES = Arrays.asList("village", "end_city[end_ship]", "ruined_portal{giant=true, underground=true}", "fortress[bridge_spawner, corridor_nether_wart]");
    private static final Map<String, Integer> STRUCTURES = ImmutableMap.builder().put((Object)"feature", (Object)Cubiomes.Feature()).put((Object)"desert_pyramid", (Object)Cubiomes.Desert_Pyramid()).put((Object)"jungle_pyramid", (Object)Cubiomes.Jungle_Pyramid()).put((Object)"swamp_hut", (Object)Cubiomes.Swamp_Hut()).put((Object)"igloo", (Object)Cubiomes.Igloo()).put((Object)"village", (Object)Cubiomes.Village()).put((Object)"ocean_ruin", (Object)Cubiomes.Ocean_Ruin()).put((Object)"shipwreck", (Object)Cubiomes.Shipwreck()).put((Object)"monument", (Object)Cubiomes.Monument()).put((Object)"mansion", (Object)Cubiomes.Mansion()).put((Object)"pillager_outpost", (Object)Cubiomes.Outpost()).put((Object)"ruined_portal", (Object)Cubiomes.Ruined_Portal()).put((Object)"ruined_portal_nether", (Object)Cubiomes.Ruined_Portal_N()).put((Object)"ancient_city", (Object)Cubiomes.Ancient_City()).put((Object)"buried_treasure", (Object)Cubiomes.Treasure()).put((Object)"mineshaft", (Object)Cubiomes.Mineshaft()).put((Object)"desert_well", (Object)Cubiomes.Desert_Well()).put((Object)"geode", (Object)Cubiomes.Geode()).put((Object)"fortress", (Object)Cubiomes.Fortress()).put((Object)"bastion_remnant", (Object)Cubiomes.Bastion()).put((Object)"end_city", (Object)Cubiomes.End_City()).put((Object)"end_gateway", (Object)Cubiomes.End_Gateway()).put((Object)"end_island", (Object)Cubiomes.End_Island()).put((Object)"trail_ruins", (Object)Cubiomes.Trail_Ruins()).put((Object)"trial_chambers", (Object)Cubiomes.Trial_Chambers()).build();
    public static final Map<Integer, Map<String, Integer>> STRUCTURE_PIECES = ImmutableMap.builder().put((Object)Cubiomes.End_City(), (Object)ImmutableMap.builder().put((Object)"base_floor", (Object)Cubiomes.BASE_FLOOR()).put((Object)"base_roof", (Object)Cubiomes.BASE_ROOF()).put((Object)"bridge_end", (Object)Cubiomes.BRIDGE_END()).put((Object)"bridge_gentle_stairs", (Object)Cubiomes.BRIDGE_GENTLE_STAIRS()).put((Object)"bridge_piece", (Object)Cubiomes.BRIDGE_PIECE()).put((Object)"bridge_steep_stairs", (Object)Cubiomes.BRIDGE_STEEP_STAIRS()).put((Object)"fat_tower_base", (Object)Cubiomes.FAT_TOWER_BASE()).put((Object)"fat_tower_middle", (Object)Cubiomes.FAT_TOWER_MIDDLE()).put((Object)"fat_tower_top", (Object)Cubiomes.FAT_TOWER_TOP()).put((Object)"second_floor_1", (Object)Cubiomes.SECOND_FLOOR_1()).put((Object)"second_floor_2", (Object)Cubiomes.SECOND_FLOOR_2()).put((Object)"second_roof", (Object)Cubiomes.SECOND_ROOF()).put((Object)"end_ship", (Object)Cubiomes.END_SHIP()).put((Object)"third_floor_1", (Object)Cubiomes.THIRD_FLOOR_1()).put((Object)"third_floor_2", (Object)Cubiomes.THIRD_FLOOR_2()).put((Object)"third_roof", (Object)Cubiomes.THIRD_ROOF()).put((Object)"tower_base", (Object)Cubiomes.TOWER_BASE()).put((Object)"tower_floor", (Object)Cubiomes.TOWER_FLOOR()).put((Object)"tower_piece", (Object)Cubiomes.TOWER_PIECE()).put((Object)"tower_top", (Object)Cubiomes.TOWER_TOP()).build()).put((Object)Cubiomes.Fortress(), (Object)ImmutableMap.builder().put((Object)"fortress_start", (Object)Cubiomes.FORTRESS_START()).put((Object)"bridge_straight", (Object)Cubiomes.BRIDGE_STRAIGHT()).put((Object)"bridge_crossing", (Object)Cubiomes.BRIDGE_CROSSING()).put((Object)"bridge_fortified_crossing", (Object)Cubiomes.BRIDGE_FORTIFIED_CROSSING()).put((Object)"bridge_stairs", (Object)Cubiomes.BRIDGE_STAIRS()).put((Object)"bridge_spawner", (Object)Cubiomes.BRIDGE_SPAWNER()).put((Object)"bridge_corridor_entrance", (Object)Cubiomes.BRIDGE_CORRIDOR_ENTRANCE()).put((Object)"corridor_straight", (Object)Cubiomes.CORRIDOR_STRAIGHT()).put((Object)"corridor_crossing", (Object)Cubiomes.CORRIDOR_CROSSING()).put((Object)"corridor_turn_right", (Object)Cubiomes.CORRIDOR_TURN_RIGHT()).put((Object)"corridor_turn_left", (Object)Cubiomes.CORRIDOR_TURN_LEFT()).put((Object)"corridor_stairs", (Object)Cubiomes.CORRIDOR_STAIRS()).put((Object)"corridor_t_crossing", (Object)Cubiomes.CORRIDOR_T_CROSSING()).put((Object)"corridor_nether_wart", (Object)Cubiomes.CORRIDOR_NETHER_WART()).put((Object)"fortress_end", (Object)Cubiomes.FORTRESS_END()).build()).build();
    private static final Map<String, Pair<Map<String, Integer>, Function<MemorySegment, Integer>>> GENERAL_VARIANTS = ImmutableMap.builder().put((Object)"biome", (Object)Pair.of(BiomeArgument.BIOMES, m -> StructureVariant.biome(m))).put((Object)"rotation", (Object)Pair.of((Object)ImmutableMap.builder().put((Object)"north", (Object)0).put((Object)"east", (Object)1).put((Object)"south", (Object)2).put((Object)"west", (Object)3).build(), m -> StructureVariant.rotation(m))).put((Object)"mirrored", (Object)Pair.of(Map.of("true", 1, "false", 0), m -> StructureVariant.mirror(m))).build();
    private static final Map<String, Pair<Map<String, Integer>, Function<MemorySegment, Integer>>> RUINED_PORTAL_VARIANTS = ImmutableMap.builder().put((Object)"start", (Object)Pair.of((Object)ImmutableMap.builder().put((Object)"ruined_portal.giant_portal_1", (Object)1).put((Object)"ruined_portal.giant_portal_2", (Object)2).put((Object)"ruined_portal.giant_portal_3", (Object)3).put((Object)"ruined_portal.portal_1", (Object)1).put((Object)"ruined_portal.portal_2", (Object)2).put((Object)"ruined_portal.portal_3", (Object)3).put((Object)"ruined_portal.portal_4", (Object)4).put((Object)"ruined_portal.portal_5", (Object)5).put((Object)"ruined_portal.portal_6", (Object)6).put((Object)"ruined_portal.portal_7", (Object)7).put((Object)"ruined_portal.portal_8", (Object)8).put((Object)"ruined_portal.portal_9", (Object)9).put((Object)"ruined_portal.portal_10", (Object)10).build(), m -> StructureVariant.start(m))).put((Object)"giant", (Object)Pair.of(Map.of("true", 1, "false", 0), m -> StructureVariant.giant(m))).put((Object)"underground", (Object)Pair.of(Map.of("true", 1, "false", 0), m -> StructureVariant.underground(m))).put((Object)"air_pocket", (Object)Pair.of(Map.of("true", 1, "false", 0), m -> StructureVariant.airpocket(m))).build();
    public static final Map<Integer, Map<String, Pair<Map<String, Integer>, Function<MemorySegment, Integer>>>> STRUCTURE_VARIANTS = ImmutableMap.builder().put((Object)Cubiomes.Village(), (Object)ImmutableMap.builder().put((Object)"start", (Object)Pair.of((Object)ImmutableMap.builder().put((Object)"plains_fountain_01", (Object)0).put((Object)"plains_meeting_point_1", (Object)1).put((Object)"plains_meeting_point_2", (Object)2).put((Object)"plains_meeting_point_3", (Object)3).put((Object)"desert_meeting_point_1", (Object)1).put((Object)"desert_meeting_point_2", (Object)2).put((Object)"desert_meeting_point_3", (Object)3).put((Object)"savanna_meeting_point_1", (Object)1).put((Object)"savanna_meeting_point_2", (Object)2).put((Object)"savanna_meeting_point_3", (Object)3).put((Object)"savanna_meeting_point_4", (Object)4).put((Object)"taiga_meeting_point_1", (Object)1).put((Object)"taiga_meeting_point_2", (Object)2).put((Object)"snowy_meeting_point_1", (Object)1).put((Object)"snowy_meeting_point_2", (Object)2).put((Object)"snowy_meeting_point_3", (Object)3).build(), m -> StructureVariant.start(m))).put((Object)"abandoned", (Object)Pair.of(Map.of("true", 1, "false", 0), m -> StructureVariant.abandoned(m))).build()).put((Object)Cubiomes.Bastion(), (Object)ImmutableMap.builder().put((Object)"start", (Object)Pair.of((Object)ImmutableMap.builder().put((Object)"units.air_base", (Object)0).put((Object)"hoglin_stable.air_base", (Object)1).put((Object)"treasure.big_air_full", (Object)2).put((Object)"bridge.starting_pieces.entrance_base", (Object)3).build(), m -> StructureVariant.start(m))).build()).put((Object)Cubiomes.Ancient_City(), (Object)ImmutableMap.builder().put((Object)"start", (Object)Pair.of((Object)ImmutableMap.builder().put((Object)"city_center_1", (Object)1).put((Object)"city_center_2", (Object)2).put((Object)"city_center_3", (Object)3).build(), m -> StructureVariant.start(m))).build()).put((Object)Cubiomes.Ruined_Portal(), RUINED_PORTAL_VARIANTS).put((Object)Cubiomes.Ruined_Portal_N(), RUINED_PORTAL_VARIANTS).put((Object)Cubiomes.Igloo(), (Object)ImmutableMap.builder().put((Object)"size", (Object)Pair.of((Object)ImmutableMap.builder().put((Object)"4", (Object)4).put((Object)"5", (Object)5).put((Object)"6", (Object)6).put((Object)"7", (Object)7).put((Object)"8", (Object)8).put((Object)"9", (Object)9).put((Object)"10", (Object)10).put((Object)"11", (Object)11).build(), m -> StructureVariant.size(m))).put((Object)"basement", (Object)Pair.of(Map.of("true", 1, "false", 0), m -> StructureVariant.basement(m))).build()).put((Object)Cubiomes.Desert_Pyramid(), Collections.emptyMap()).put((Object)Cubiomes.Jungle_Temple(), Collections.emptyMap()).put((Object)Cubiomes.Swamp_Hut(), Collections.emptyMap()).put((Object)Cubiomes.Geode(), (Object)ImmutableMap.builder().put((Object)"size", (Object)Pair.of((Object)ImmutableMap.builder().put((Object)"3", (Object)3).put((Object)"4", (Object)4).put((Object)"5", (Object)5).build(), m -> StructureVariant.size(m))).put((Object)"cracked", (Object)Pair.of(Map.of("true", 1, "false", 0), m -> StructureVariant.cracked(m))).build()).put((Object)Cubiomes.Trial_Chambers(), (Object)ImmutableMap.builder().put((Object)"start", (Object)Pair.of((Object)ImmutableMap.builder().put((Object)"corridor.end_1", (Object)0).put((Object)"corridor.end_2", (Object)1).build(), m -> StructureVariant.size(m))).build()).build();

    public static StructurePredicateArgument structurePredicate() {
        return new StructurePredicateArgument();
    }

    public static StructureAndPredicate getStructurePredicate(CommandContext<FabricClientCommandSource> context, String name) {
        return (StructureAndPredicate)context.getArgument(name, StructureAndPredicate.class);
    }

    public StructureAndPredicate parse(StringReader reader) throws CommandSyntaxException {
        return new Parser(reader).parse();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        Parser parser = new Parser(reader);
        try {
            parser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (parser.suggestor != null) {
            parser.suggestor.accept(builder);
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public record StructureAndPredicate(int structure, PiecesPredicate piecesPredicate, VariantPredicate variantPredicate) {
    }

    private static final class Parser {
        private final StringReader reader;
        private Consumer<SuggestionsBuilder> suggestor;

        private Parser(StringReader reader) {
            this.reader = reader;
        }

        private StructureAndPredicate parse() throws CommandSyntaxException {
            int structure = this.parseStructure();
            PiecesPredicate piecesPredicate = this.parsePieces(structure);
            VariantPredicate variantPredicate = this.parseVariant(structure);
            return new StructureAndPredicate(structure, piecesPredicate, variantPredicate);
        }

        private int parseStructure() throws CommandSyntaxException {
            int cursor = this.reader.getCursor();
            this.suggestor = suggestions -> {
                SuggestionsBuilder builder = suggestions.createOffset(cursor);
                class_2172.method_9265(STRUCTURES.keySet(), (SuggestionsBuilder)builder);
                suggestions.add(builder);
            };
            String structureString = this.reader.readUnquotedString();
            Integer structure = STRUCTURES.get(structureString);
            if (structure == null) {
                this.reader.setCursor(cursor);
                throw CommandExceptions.UNKNOWN_STRUCTURE_EXCEPTION.create((Object)structureString);
            }
            return structure;
        }

        private PiecesPredicate parsePieces(int structure) throws CommandSyntaxException {
            Map<String, Integer> piecesMap = STRUCTURE_PIECES.get(structure);
            if (piecesMap == null) {
                return (n, memorySegment) -> true;
            }
            if (!this.reader.canRead()) {
                return (n, memorySegment) -> true;
            }
            HashSet<Integer> wantedPieces = new HashSet<Integer>();
            this.reader.expect('[');
            while (true) {
                int cursor = this.reader.getCursor();
                this.suggestor = suggestions -> {
                    SuggestionsBuilder builder = suggestions.createOffset(cursor);
                    class_2172.method_9265(piecesMap.keySet(), (SuggestionsBuilder)builder);
                    suggestions.add(builder);
                };
                if (!this.reader.canRead() || this.reader.canRead() && this.reader.peek() == ']') break;
                String pieceString = this.reader.readUnquotedString();
                Integer piece = piecesMap.get(pieceString);
                if (piece == null) {
                    this.reader.setCursor(cursor);
                    throw CommandExceptions.UNKNOWN_STRUCTURE_PIECE_EXCEPTION.create((Object)pieceString);
                }
                wantedPieces.add(piece);
                if (!this.reader.canRead() || this.reader.peek() != ',') break;
                this.reader.skip();
                this.reader.skipWhitespace();
            }
            this.reader.expect(']');
            return (n, p) -> {
                Iterator iterator = wantedPieces.iterator();
                while (iterator.hasNext()) {
                    int wantedPiece = (Integer)iterator.next();
                    boolean found = IntStream.range(0, n).mapToObj(i -> Piece.asSlice(p, i)).anyMatch(piece -> Piece.type(piece) == wantedPiece);
                    if (found) continue;
                    return false;
                }
                return true;
            };
        }

        private VariantPredicate parseVariant(int structure) throws CommandSyntaxException {
            VariantPredicate variantPredicate = memorySegment -> true;
            Map<String, Pair<Map<String, Integer>, Function<MemorySegment, Integer>>> specificVariantKeys = STRUCTURE_VARIANTS.get(structure);
            if (specificVariantKeys == null) {
                return variantPredicate;
            }
            if (!this.reader.canRead()) {
                return variantPredicate;
            }
            this.reader.expect('{');
            while (true) {
                int cursor = this.reader.getCursor();
                this.suggestor = suggestions -> {
                    SuggestionsBuilder builder = suggestions.createOffset(cursor);
                    class_2172.method_9265(GENERAL_VARIANTS.keySet(), (SuggestionsBuilder)builder);
                    class_2172.method_9265(specificVariantKeys.keySet(), (SuggestionsBuilder)builder);
                    suggestions.add(builder);
                };
                if (!this.reader.canRead() || this.reader.canRead() && this.reader.peek() == '}') break;
                String variantKeyString = this.reader.readUnquotedString();
                Pair<Map<String, Integer>, Function<MemorySegment, Integer>> variantsMap = GENERAL_VARIANTS.getOrDefault(variantKeyString, specificVariantKeys.get(variantKeyString));
                if (variantsMap == null) {
                    this.reader.setCursor(cursor);
                    throw CommandExceptions.UNKNOWN_VARIANT_KEY_EXCEPTION.create((Object)variantKeyString);
                }
                this.reader.expect('=');
                int value = this.parseVariantValue(variantsMap);
                variantPredicate = variantPredicate.and(v -> (Integer)((Function)variantsMap.getSecond()).apply(v) == value);
                if (!this.reader.canRead() || this.reader.peek() != ',') break;
                this.reader.skip();
                this.reader.skipWhitespace();
            }
            this.reader.expect('}');
            return variantPredicate;
        }

        private int parseVariantValue(Pair<Map<String, Integer>, Function<MemorySegment, Integer>> variantsMap) throws CommandSyntaxException {
            int cursor = this.reader.getCursor();
            this.suggestor = suggestions -> {
                SuggestionsBuilder builder = suggestions.createOffset(cursor);
                class_2172.method_9265(((Map)variantsMap.getFirst()).keySet(), (SuggestionsBuilder)builder);
                suggestions.add(builder);
            };
            String variantValueString = this.reader.readUnquotedString();
            Integer value = (Integer)((Map)variantsMap.getFirst()).get(variantValueString);
            if (value == null) {
                this.reader.setCursor(cursor);
                throw CommandExceptions.UNKNOWN_VARIANT_VALUE_EXCEPTION.create((Object)variantValueString);
            }
            return value;
        }
    }

    @FunctionalInterface
    public static interface VariantPredicate {
        public boolean test(MemorySegment var1);

        default public VariantPredicate and(VariantPredicate other) {
            return variant -> this.test(variant) && other.test(variant);
        }
    }

    @FunctionalInterface
    public static interface PiecesPredicate {
        public boolean test(int var1, MemorySegment var2);

        default public PiecesPredicate and(PiecesPredicate other) {
            return (numPieces, pieces) -> this.test(numPieces, pieces) && other.test(numPieces, pieces);
        }
    }
}

