/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.command.arguments;

import com.github.cubiomes.Cubiomes;
import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.xpple.seedmapper.command.CommandExceptions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;

public class VersionArgument
implements ArgumentType<Integer> {
    private static final Collection<String> EXAMPLES = Arrays.asList("1.21.1", "1.17.1", "1.15");
    private static final Map<String, Integer> VERSIONS = ImmutableMap.builder().put((Object)"b1.7.2", (Object)Cubiomes.MC_B1_7()).put((Object)"b1.7.3", (Object)Cubiomes.MC_B1_7()).put((Object)"b1.7", (Object)Cubiomes.MC_B1_7()).put((Object)"b1.8.1", (Object)Cubiomes.MC_B1_8()).put((Object)"b1.8", (Object)Cubiomes.MC_B1_8()).put((Object)"1.0", (Object)Cubiomes.MC_1_0()).put((Object)"1.1", (Object)Cubiomes.MC_1_1()).put((Object)"1.2.1", (Object)Cubiomes.MC_1_2_5()).put((Object)"1.2.2", (Object)Cubiomes.MC_1_2_5()).put((Object)"1.2.3", (Object)Cubiomes.MC_1_2_5()).put((Object)"1.2.4", (Object)Cubiomes.MC_1_2_5()).put((Object)"1.2.5", (Object)Cubiomes.MC_1_2_5()).put((Object)"1.2", (Object)Cubiomes.MC_1_2()).put((Object)"1.3.1", (Object)Cubiomes.MC_1_3_2()).put((Object)"1.3.2", (Object)Cubiomes.MC_1_3_2()).put((Object)"1.3", (Object)Cubiomes.MC_1_3()).put((Object)"1.4.2", (Object)Cubiomes.MC_1_4_7()).put((Object)"1.4.4", (Object)Cubiomes.MC_1_4_7()).put((Object)"1.4.5", (Object)Cubiomes.MC_1_4_7()).put((Object)"1.4.6", (Object)Cubiomes.MC_1_4_7()).put((Object)"1.4.7", (Object)Cubiomes.MC_1_4_7()).put((Object)"1.4", (Object)Cubiomes.MC_1_4()).put((Object)"1.5.1", (Object)Cubiomes.MC_1_5_2()).put((Object)"1.5.2", (Object)Cubiomes.MC_1_5_2()).put((Object)"1.5", (Object)Cubiomes.MC_1_5()).put((Object)"1.6.1", (Object)Cubiomes.MC_1_6_4()).put((Object)"1.6.2", (Object)Cubiomes.MC_1_6_4()).put((Object)"1.6.4", (Object)Cubiomes.MC_1_6_4()).put((Object)"1.6", (Object)Cubiomes.MC_1_6()).put((Object)"1.7.2", (Object)Cubiomes.MC_1_7_10()).put((Object)"1.7.3", (Object)Cubiomes.MC_1_7_10()).put((Object)"1.7.4", (Object)Cubiomes.MC_1_7_10()).put((Object)"1.7.5", (Object)Cubiomes.MC_1_7_10()).put((Object)"1.7.6", (Object)Cubiomes.MC_1_7_10()).put((Object)"1.7.7", (Object)Cubiomes.MC_1_7_10()).put((Object)"1.7.8", (Object)Cubiomes.MC_1_7_10()).put((Object)"1.7.9", (Object)Cubiomes.MC_1_7_10()).put((Object)"1.7.10", (Object)Cubiomes.MC_1_7_10()).put((Object)"1.7", (Object)Cubiomes.MC_1_7()).put((Object)"1.8.1", (Object)Cubiomes.MC_1_8_9()).put((Object)"1.8.2", (Object)Cubiomes.MC_1_8_9()).put((Object)"1.8.3", (Object)Cubiomes.MC_1_8_9()).put((Object)"1.8.4", (Object)Cubiomes.MC_1_8_9()).put((Object)"1.8.5", (Object)Cubiomes.MC_1_8_9()).put((Object)"1.8.6", (Object)Cubiomes.MC_1_8_9()).put((Object)"1.8.7", (Object)Cubiomes.MC_1_8_9()).put((Object)"1.8.8", (Object)Cubiomes.MC_1_8_9()).put((Object)"1.8.9", (Object)Cubiomes.MC_1_8_9()).put((Object)"1.8", (Object)Cubiomes.MC_1_8()).put((Object)"1.9.1", (Object)Cubiomes.MC_1_9_4()).put((Object)"1.9.2", (Object)Cubiomes.MC_1_9_4()).put((Object)"1.9.3", (Object)Cubiomes.MC_1_9_4()).put((Object)"1.9.4", (Object)Cubiomes.MC_1_9_4()).put((Object)"1.9", (Object)Cubiomes.MC_1_9()).put((Object)"1.10.1", (Object)Cubiomes.MC_1_10_2()).put((Object)"1.10.2", (Object)Cubiomes.MC_1_10_2()).put((Object)"1.10", (Object)Cubiomes.MC_1_10()).put((Object)"1.11.1", (Object)Cubiomes.MC_1_11_2()).put((Object)"1.11.2", (Object)Cubiomes.MC_1_11_2()).put((Object)"1.11", (Object)Cubiomes.MC_1_11()).put((Object)"1.12.1", (Object)Cubiomes.MC_1_12_2()).put((Object)"1.12.2", (Object)Cubiomes.MC_1_12_2()).put((Object)"1.12", (Object)Cubiomes.MC_1_12()).put((Object)"1.13.1", (Object)Cubiomes.MC_1_13_2()).put((Object)"1.13.2", (Object)Cubiomes.MC_1_13_2()).put((Object)"1.13", (Object)Cubiomes.MC_1_13()).put((Object)"1.14.1", (Object)Cubiomes.MC_1_14_4()).put((Object)"1.14.2", (Object)Cubiomes.MC_1_14_4()).put((Object)"1.14.3", (Object)Cubiomes.MC_1_14_4()).put((Object)"1.14.4", (Object)Cubiomes.MC_1_14_4()).put((Object)"1.14", (Object)Cubiomes.MC_1_14()).put((Object)"1.15.1", (Object)Cubiomes.MC_1_15_2()).put((Object)"1.15.2", (Object)Cubiomes.MC_1_15_2()).put((Object)"1.15", (Object)Cubiomes.MC_1_15()).put((Object)"1.16.1", (Object)Cubiomes.MC_1_16_1()).put((Object)"1.16.2", (Object)Cubiomes.MC_1_16_1()).put((Object)"1.16.3", (Object)Cubiomes.MC_1_16_1()).put((Object)"1.16.4", (Object)Cubiomes.MC_1_16_1()).put((Object)"1.16.5", (Object)Cubiomes.MC_1_16_5()).put((Object)"1.16", (Object)Cubiomes.MC_1_16()).put((Object)"1.17.1", (Object)Cubiomes.MC_1_17_1()).put((Object)"1.17", (Object)Cubiomes.MC_1_17()).put((Object)"1.18.1", (Object)Cubiomes.MC_1_18_2()).put((Object)"1.18.2", (Object)Cubiomes.MC_1_18_2()).put((Object)"1.18", (Object)Cubiomes.MC_1_18()).put((Object)"1.19.1", (Object)Cubiomes.MC_1_19_2()).put((Object)"1.19.2", (Object)Cubiomes.MC_1_19_2()).put((Object)"1.19.3", (Object)Cubiomes.MC_1_19_2()).put((Object)"1.19.4", (Object)Cubiomes.MC_1_19_4()).put((Object)"1.19", (Object)Cubiomes.MC_1_19()).put((Object)"1.20.1", (Object)Cubiomes.MC_1_20_6()).put((Object)"1.20.2", (Object)Cubiomes.MC_1_20_6()).put((Object)"1.20.3", (Object)Cubiomes.MC_1_20_6()).put((Object)"1.20.4", (Object)Cubiomes.MC_1_20_6()).put((Object)"1.20.5", (Object)Cubiomes.MC_1_20_6()).put((Object)"1.20.6", (Object)Cubiomes.MC_1_20_6()).put((Object)"1.20", (Object)Cubiomes.MC_1_20()).put((Object)"1.21.1", (Object)Cubiomes.MC_1_21_1()).put((Object)"1.21.2", (Object)Cubiomes.MC_1_21_1()).put((Object)"1.21.3", (Object)Cubiomes.MC_1_21_3()).put((Object)"1.21.4", (Object)Cubiomes.MC_1_21_3()).put((Object)"1.21.5", (Object)Cubiomes.MC_1_21_3()).put((Object)"1.21", (Object)Cubiomes.MC_1_21()).build();

    public static VersionArgument version() {
        return new VersionArgument();
    }

    public static int getVersion(CommandContext<FabricClientCommandSource> context, String name) {
        return (Integer)context.getArgument(name, Integer.class);
    }

    public Integer parse(StringReader reader) throws CommandSyntaxException {
        int cursor = reader.getCursor();
        String versionString = reader.readUnquotedString();
        Integer version = VERSIONS.get(versionString);
        if (version == null) {
            reader.setCursor(cursor);
            throw CommandExceptions.UNKNOWN_VERSION_EXCEPTION.create((Object)versionString);
        }
        return version;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2172.method_9265(VERSIONS.keySet(), (SuggestionsBuilder)builder);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

