/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.command.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import dev.xpple.seedmapper.SeedMapper;
import dev.xpple.seedmapper.command.CustomClientCommandSource;
import dev.xpple.seedmapper.command.arguments.SeedResolutionArgument;
import dev.xpple.seedmapper.util.ChatBuilder;
import dev.xpple.seedmapper.util.ComponentUtils;
import java.net.URI;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;

public class CheckSeedCommand {
    private static final URI DATABASE_URL = URI.create("https://docs.google.com/spreadsheets/d/1tuQiE-0leW88em9OHbZnH-RFNhVqgoHhIt9WQbeqqWw");

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sm:checkseed").executes(ctx -> CheckSeedCommand.checkSeed(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()))));
    }

    private static int checkSeed(CustomClientCommandSource source) throws CommandSyntaxException {
        Pair<SeedResolutionArgument.SeedResolution.Method, Long> seedPair = source.getSeed();
        long seed = (Long)seedPair.getSecond();
        switch ((SeedResolutionArgument.SeedResolution.Method)((Object)seedPair.getFirst())) {
            case COMMAND_SOURCE: {
                source.sendFeedback((class_2561)class_2561.method_43469((String)"command.checkSeed.using", (Object[])new Object[]{ComponentUtils.formatSeed(seed), ChatBuilder.format(ChatBuilder.suggest(class_2561.method_43471((String)"command.checkSeed.fromSource"), "/sm:source seeded %d run ".formatted(seed)), class_124.field_1073)}));
                break;
            }
            case SEED_CONFIG: {
                source.sendFeedback((class_2561)class_2561.method_43469((String)"command.checkSeed.using", (Object[])new Object[]{ComponentUtils.formatSeed(seed), ChatBuilder.format(ChatBuilder.file(class_2561.method_43471((String)"command.checkSeed.fromSeed"), SeedMapper.modConfigPath.resolve("config.json").toAbsolutePath().toString()), class_124.field_1073)}));
                break;
            }
            case SAVED_SEEDS_CONFIG: {
                source.sendFeedback((class_2561)class_2561.method_43469((String)"command.checkSeed.using", (Object[])new Object[]{ComponentUtils.formatSeed(seed), ChatBuilder.format(ChatBuilder.file(class_2561.method_43471((String)"command.checkSeed.fromSavedSeeds"), SeedMapper.modConfigPath.resolve("config.json").toAbsolutePath().toString()), class_124.field_1073)}));
                break;
            }
            case ONLINE_DATABASE: {
                source.sendFeedback((class_2561)class_2561.method_43469((String)"command.checkSeed.using", (Object[])new Object[]{ComponentUtils.formatSeed(seed), ChatBuilder.format(ChatBuilder.url(class_2561.method_43471((String)"command.checkSeed.fromDatabase"), DATABASE_URL), class_124.field_1073)}));
            }
        }
        return 1;
    }
}

