/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.command.commands;

import com.github.cubiomes.Cubiomes;
import com.github.cubiomes.Generator;
import com.github.cubiomes.OreConfig;
import com.github.cubiomes.Pos3;
import com.github.cubiomes.Pos3List;
import com.github.cubiomes.SurfaceNoise;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import dev.xpple.seedmapper.command.CustomClientCommandSource;
import dev.xpple.seedmapper.command.arguments.BlockArgument;
import dev.xpple.seedmapper.config.Configs;
import dev.xpple.seedmapper.feature.OreTypes;
import dev.xpple.seedmapper.render.RenderManager;
import dev.xpple.seedmapper.thread.ThreadingHelper;
import dev.xpple.seedmapper.util.ChatBuilder;
import dev.xpple.seedmapper.util.SpiralLoop;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2806;
import net.minecraft.class_2818;

public class HighlightCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sm:highlight").then(ClientCommandManager.literal((String)"block").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"block", (ArgumentType)BlockArgument.block()).executes(ctx -> HighlightCommand.highlightBlock(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()), BlockArgument.getBlock((CommandContext<FabricClientCommandSource>)ctx, "block")))).then(ClientCommandManager.argument((String)"chunks", (ArgumentType)IntegerArgumentType.integer((int)0, (int)20)).executes(ctx -> ThreadingHelper.submit(() -> HighlightCommand.highlightBlock(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()), BlockArgument.getBlock((CommandContext<FabricClientCommandSource>)ctx, "block"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"chunks"))))))));
    }

    private static int highlightBlock(CustomClientCommandSource source, Pair<Integer, Integer> blockPair) throws CommandSyntaxException {
        return HighlightCommand.highlightBlock(source, blockPair, 0);
    }

    private static int highlightBlock(CustomClientCommandSource source, Pair<Integer, Integer> blockPair, int chunkRange) throws CommandSyntaxException {
        int version = source.getVersion();
        int dimension = source.getDimension();
        long seed = (Long)source.getSeed().getSecond();
        try (Arena arena = Arena.ofConfined();){
            MemorySegment generator = Generator.allocate(arena);
            Cubiomes.setupGenerator(generator, version, 0);
            Cubiomes.applySeed(generator, dimension, seed);
            MemorySegment surfaceNoise = SurfaceNoise.allocate(arena);
            Cubiomes.initSurfaceNoise(surfaceNoise, dimension, seed);
            class_1923 center = new class_1923(class_2338.method_49638((class_2374)source.getPosition()));
            int[] count = new int[]{0};
            SpiralLoop.spiral(center.field_9181, center.field_9180, chunkRange, (chunkX, chunkZ) -> {
                class_2818 chunk = source.getWorld().method_2935().method_2857(chunkX, chunkZ, class_2806.field_12803, false);
                boolean doAirCheck = Configs.OreAirCheck && chunk != null;
                HashMap generatedOres = new HashMap();
                int biome = Cubiomes.getBiomeForOreGen(generator, chunkX, chunkZ);
                OreTypes.ORE_TYPES.stream().filter(oreType -> Cubiomes.isViableOreBiome(version, oreType, biome) != 0).mapMulti((oreType, consumer) -> {
                    MemorySegment oreConfig = OreConfig.allocate(arena);
                    if (Cubiomes.getOreConfig(oreType, version, biome, oreConfig) != 0) {
                        consumer.accept(oreConfig);
                    }
                }).sorted(Comparator.comparingInt(OreConfig::index)).forEachOrdered(oreConfig -> {
                    int oreBlock = OreConfig.oreBlock(oreConfig);
                    int numReplaceBlocks = OreConfig.numReplaceBlocks(oreConfig);
                    MemorySegment replaceBlocks = OreConfig.replaceBlocks(oreConfig);
                    MemorySegment pos3List = Cubiomes.generateOres(arena, generator, surfaceNoise, oreConfig, chunkX, chunkZ);
                    int size = Pos3List.size(pos3List);
                    MemorySegment pos3s = Pos3List.pos3s(pos3List);
                    for (int i = 0; i < size; ++i) {
                        MemorySegment pos3 = Pos3.asSlice(pos3s, i);
                        class_2338 pos = new class_2338(Pos3.x(pos3), Pos3.y(pos3), Pos3.z(pos3));
                        if (doAirCheck && chunk.method_8320(pos).method_26215()) continue;
                        Integer previouslyGeneratedOre = (Integer)generatedOres.get(pos);
                        if (previouslyGeneratedOre != null) {
                            boolean contains = false;
                            for (int j = 0; j < numReplaceBlocks; ++j) {
                                int replaceBlock = replaceBlocks.getAtIndex(Cubiomes.C_INT, (long)j);
                                if (replaceBlock != previouslyGeneratedOre) continue;
                                contains = true;
                                break;
                            }
                            if (!contains) continue;
                        }
                        generatedOres.put(pos, oreBlock);
                    }
                    Cubiomes.freePos3List(pos3List);
                });
                int block = (Integer)blockPair.getFirst();
                int colour = (Integer)blockPair.getSecond();
                List<class_2338> blockOres = generatedOres.entrySet().stream().filter(entry -> (Integer)entry.getValue() == block).map(Map.Entry::getKey).toList();
                count[0] = count[0] + blockOres.size();
                source.getClient().method_63588(() -> {
                    RenderManager.drawBoxes(blockOres, colour);
                    source.sendFeedback((class_2561)class_2561.method_43469((String)"command.highlight.chunkSuccess", (Object[])new Object[]{ChatBuilder.accent(String.valueOf(blockOres.size())), ChatBuilder.copy(ChatBuilder.hover(ChatBuilder.accent("%d %d".formatted(chunkX, chunkZ)), ChatBuilder.base(class_2561.method_43471((String)"chat.copy.click"))), "%d %d".formatted(chunkX, chunkZ))}));
                });
                return false;
            });
            source.getClient().method_63588(() -> source.sendFeedback((class_2561)class_2561.method_43469((String)"command.highlight.success", (Object[])new Object[]{ChatBuilder.accent(String.valueOf(count[0]))})));
            int n = count[0];
            return n;
        }
    }
}

