/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.command.commands;

import com.github.cubiomes.Cubiomes;
import com.github.cubiomes.Generator;
import com.github.cubiomes.Piece;
import com.github.cubiomes.Pos;
import com.github.cubiomes.Pos3;
import com.github.cubiomes.StrongholdIter;
import com.github.cubiomes.StructureConfig;
import com.github.cubiomes.StructureVariant;
import com.github.cubiomes.SurfaceNoise;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.xpple.seedmapper.command.CommandExceptions;
import dev.xpple.seedmapper.command.CustomClientCommandSource;
import dev.xpple.seedmapper.command.arguments.BiomeArgument;
import dev.xpple.seedmapper.command.arguments.StructurePredicateArgument;
import dev.xpple.seedmapper.feature.StructureChecks;
import dev.xpple.seedmapper.feature.StructureVariantFeedbackHelper;
import dev.xpple.seedmapper.thread.ThreadingHelper;
import dev.xpple.seedmapper.util.ChatBuilder;
import dev.xpple.seedmapper.util.SpiralLoop;
import dev.xpple.seedmapper.util.TwoDTree;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.List;
import java.util.stream.IntStream;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2919;
import net.minecraft.class_5819;

public class LocateCommand {
    private static final int BIOME_SEARCH_RADIUS = 6400;
    private static final Long2ObjectMap<TwoDTree> cachedStrongholds = new Long2ObjectOpenHashMap();

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"sm:locate").then(ClientCommandManager.literal((String)"biome").then(ClientCommandManager.argument((String)"biome", (ArgumentType)BiomeArgument.biome()).executes(ctx -> ThreadingHelper.submit(() -> LocateCommand.locateBiome(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()), BiomeArgument.getBiome((CommandContext<FabricClientCommandSource>)ctx, "biome"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"feature").then(ClientCommandManager.literal((String)"structure").then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"structure", (ArgumentType)StructurePredicateArgument.structurePredicate()).executes(ctx -> ThreadingHelper.submit(() -> LocateCommand.locateStructure(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()), StructurePredicateArgument.getStructurePredicate((CommandContext<FabricClientCommandSource>)ctx, "structure"))))).then(ClientCommandManager.argument((String)"variantdata", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> ThreadingHelper.submit(() -> LocateCommand.locateStructure(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()), StructurePredicateArgument.getStructurePredicate((CommandContext<FabricClientCommandSource>)ctx, "structure"), BoolArgumentType.getBool((CommandContext)ctx, (String)"variantdata")))))))).then(ClientCommandManager.literal((String)"stronghold").executes(ctx -> ThreadingHelper.submit(() -> LocateCommand.locateStronghold(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource())))))).then(ClientCommandManager.literal((String)"slimechunk").executes(ctx -> ThreadingHelper.submit(() -> LocateCommand.locateSlimeChunk(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()))))))).then(ClientCommandManager.literal((String)"spawn").executes(ctx -> ThreadingHelper.submit(() -> LocateCommand.locateSpawn(CustomClientCommandSource.of((FabricClientCommandSource)ctx.getSource()))))));
    }

    private static int locateBiome(CustomClientCommandSource source, int biome) throws CommandSyntaxException {
        int dimension = source.getDimension();
        if (Cubiomes.getDimension(biome) != dimension) {
            throw CommandExceptions.INVALID_DIMENSION_EXCEPTION.create();
        }
        try (Arena arena = Arena.ofConfined();){
            MemorySegment generator = Generator.allocate(arena);
            Cubiomes.setupGenerator(generator, source.getVersion(), 0);
            Cubiomes.applySeed(generator, dimension, (Long)source.getSeed().getSecond());
            class_2338 center = class_2338.method_49638((class_2374)source.getPosition());
            SpiralLoop.Coordinate pos = SpiralLoop.spiral(center.method_10263(), center.method_10260(), 6400, 32, (x, z) -> Cubiomes.getBiomeAt(generator, 1, x, 63, z) == biome);
            if (pos == null) {
                throw CommandExceptions.NO_BIOME_FOUND_EXCEPTION.create((Object)6400);
            }
            source.sendFeedback((class_2561)class_2561.method_43469((String)"command.locate.biome.foundAt", (Object[])new Object[]{ChatBuilder.copy(ChatBuilder.hover(ChatBuilder.accent("x: %d, z: %d".formatted(pos.x(), pos.z())), ChatBuilder.base(class_2561.method_43471((String)"chat.copy.click"))), "%d ~ %d".formatted(pos.x(), pos.z()))}));
            int n = 1;
            return n;
        }
    }

    private static int locateStructure(CustomClientCommandSource source, StructurePredicateArgument.StructureAndPredicate structureAndPredicate) throws CommandSyntaxException {
        return LocateCommand.locateStructure(source, structureAndPredicate, false);
    }

    private static int locateStructure(CustomClientCommandSource source, StructurePredicateArgument.StructureAndPredicate structureAndPredicate, boolean variantData) throws CommandSyntaxException {
        try (Arena arena = Arena.ofConfined();){
            int numPieces;
            int version = source.getVersion();
            int dimension = source.getDimension();
            int structure = structureAndPredicate.structure();
            MemorySegment structureConfig = StructureConfig.allocate(arena);
            int config = Cubiomes.getStructureConfig(structure, version, structureConfig);
            if (config == 0) {
                throw CommandExceptions.INCOMPATIBLE_PARAMETERS_EXCEPTION.create();
            }
            if (StructureConfig.dim(structureConfig) != dimension) {
                throw CommandExceptions.INVALID_DIMENSION_EXCEPTION.create();
            }
            long seed = (Long)source.getSeed().getSecond();
            MemorySegment generator = Generator.allocate(arena);
            Cubiomes.setupGenerator(generator, version, 0);
            Cubiomes.applySeed(generator, dimension, seed);
            MemorySegment surfaceNoise = SurfaceNoise.allocate(arena);
            Cubiomes.initSurfaceNoise(surfaceNoise, dimension, seed);
            StructureChecks.GenerationCheck generationCheck = StructureChecks.getGenerationCheck(structure);
            StructurePredicateArgument.PiecesPredicate piecesPredicate = structureAndPredicate.piecesPredicate();
            StructureChecks.PiecesPredicateCheck piecesPredicateCheck = StructureChecks.getPiecesPredicateCheck(structure);
            StructurePredicateArgument.VariantPredicate variantPredicate = structureAndPredicate.variantPredicate();
            StructureChecks.VariantPredicateCheck variantPredicateCheck = StructureChecks.getVariantPredicateCheck(structure);
            class_2338 center = class_2338.method_49638((class_2374)source.getPosition());
            int regionSize = StructureConfig.regionSize(structureConfig) << 4;
            MemorySegment structurePos = Pos.allocate(arena);
            MemorySegment pieces = Piece.allocateArray(StructureChecks.MAX_END_CITY_AND_FORTRESS_PIECES, arena);
            MemorySegment structureVariant = StructureVariant.allocate(arena);
            SpiralLoop.Coordinate pos = SpiralLoop.spiral(center.method_10263() / regionSize, center.method_10260() / regionSize, 30000000 / regionSize, (x, z) -> {
                if (!generationCheck.check(generator, surfaceNoise, x, z, structurePos)) {
                    return false;
                }
                if (!piecesPredicateCheck.check(piecesPredicate, pieces, generator, structurePos)) {
                    return false;
                }
                return variantPredicateCheck.check(variantPredicate, structureVariant, generator, structurePos);
            });
            if (pos == null) {
                throw CommandExceptions.NO_STRUCTURE_FOUND_EXCEPTION.create((Object)30000000);
            }
            source.sendFeedback((class_2561)class_2561.method_43469((String)"command.locate.feature.structure.foundAt", (Object[])new Object[]{ChatBuilder.copy(ChatBuilder.hover(ChatBuilder.accent("x: %d, z: %d".formatted(Pos.x(structurePos), Pos.z(structurePos))), ChatBuilder.base(class_2561.method_43471((String)"chat.copy.click"))), "%d ~ %d".formatted(Pos.x(structurePos), Pos.z(structurePos)))}));
            if (structure == Cubiomes.End_City()) {
                numPieces = Cubiomes.getEndCityPieces(pieces, seed, Pos.x(structurePos) >> 4, Pos.z(structurePos) >> 4);
                IntStream.range(0, numPieces).mapToObj(i -> Piece.asSlice(pieces, i)).filter(piece -> Piece.type(piece) == Cubiomes.END_SHIP()).findAny().map(Piece::pos).map(city -> new class_2338(Pos3.x(city), Pos3.y(city) + 60, Pos3.z(city))).ifPresent(city -> source.sendFeedback((class_2561)class_2561.method_43470((String)" - ").method_10852((class_2561)class_2561.method_43469((String)"command.locate.feature.structure.endCity.hasShip", (Object[])new Object[]{ChatBuilder.copy(ChatBuilder.hover(ChatBuilder.accent("x: %d, y: %d, z: %d".formatted(city.method_10263(), city.method_10264(), city.method_10260())), ChatBuilder.base(class_2561.method_43471((String)"chat.copy.click"))), "%d %d %d".formatted(city.method_10263(), city.method_10264(), city.method_10260()))}))));
            } else if (structure == Cubiomes.Fortress()) {
                numPieces = Cubiomes.getFortressPieces(pieces, 400, version, seed, Pos.x(structurePos) >> 4, Pos.z(structurePos) >> 4);
                IntStream.range(0, numPieces).mapToObj(i -> Piece.asSlice(pieces, i)).filter(piece -> Piece.type(piece) == Cubiomes.BRIDGE_SPAWNER()).map(Piece::pos).map(monsterThrone -> new class_2338(Pos3.x(monsterThrone), Pos3.y(monsterThrone) + 10, Pos3.z(monsterThrone))).forEach(spawnerPos -> source.sendFeedback((class_2561)class_2561.method_43470((String)" - ").method_10852((class_2561)class_2561.method_43469((String)"command.locate.feature.structure.fortress.hasSpawner", (Object[])new Object[]{ChatBuilder.copy(ChatBuilder.hover(ChatBuilder.accent("x: %d, y: %d, z: %d".formatted(spawnerPos.method_10263(), spawnerPos.method_10264(), spawnerPos.method_10260())), ChatBuilder.base(class_2561.method_43471((String)"chat.copy.click"))), "%d %d %d".formatted(spawnerPos.method_10263(), spawnerPos.method_10264(), spawnerPos.method_10260()))}))));
            }
            if (!variantData) {
                numPieces = 1;
                return numPieces;
            }
            int biome = Cubiomes.getBiomeAt(generator, 4, Pos.x(structurePos) >> 2, 80, Pos.z(structurePos) >> 2);
            Cubiomes.getVariant(structureVariant, structure, version, seed, Pos.x(structurePos), Pos.z(structurePos), biome);
            List<class_2561> components = StructureVariantFeedbackHelper.get(structure, structureVariant);
            if (components.isEmpty()) {
                int n = 1;
                return n;
            }
            source.sendFeedback((class_2561)class_2561.method_43471((String)"command.locate.feature.structure.variantData"));
            components.forEach(component -> source.sendFeedback((class_2561)class_2561.method_43470((String)" - ").method_10852(component)));
            int n = 1;
            return n;
        }
    }

    private static int locateStronghold(CustomClientCommandSource source) throws CommandSyntaxException {
        int dimension = source.getDimension();
        if (dimension != Cubiomes.DIM_OVERWORLD()) {
            throw CommandExceptions.INVALID_DIMENSION_EXCEPTION.create();
        }
        int version = source.getVersion();
        long seed = (Long)source.getSeed().getSecond();
        class_2338 position = class_2338.method_49638((class_2374)source.getPosition());
        TwoDTree tree = (TwoDTree)cachedStrongholds.computeIfAbsent(seed, l -> new TwoDTree());
        if (tree.isEmpty()) {
            try (Arena arena = Arena.ofConfined();){
                MemorySegment strongholdIter = StrongholdIter.allocate(arena);
                Cubiomes.initFirstStronghold(arena, strongholdIter, version, seed);
                MemorySegment generator = Generator.allocate(arena);
                Cubiomes.setupGenerator(generator, version, 0);
                Cubiomes.applySeed(generator, dimension, seed);
                int count = source.getVersion() <= Cubiomes.MC_1_8() ? 3 : 128;
                for (int i = 0; i < count; ++i) {
                    if (Cubiomes.nextStronghold(strongholdIter, generator) == 0) {
                        break;
                    }
                    MemorySegment pos = StrongholdIter.pos(strongholdIter);
                    tree.insert(new class_2338(Pos.x(pos), 0, Pos.z(pos)));
                }
            }
        }
        class_2338 pos = tree.nearestTo(position.method_33096(0));
        source.sendFeedback((class_2561)ChatBuilder.chain(new class_2561[]{ChatBuilder.highlight(class_2561.method_43469((String)"command.locate.feature.stronghold.success", (Object[])new Object[]{ChatBuilder.copy(ChatBuilder.hover(ChatBuilder.accent("x: %d, z: %d".formatted(pos.method_10263(), pos.method_10260())), ChatBuilder.base(class_2561.method_43471((String)"chat.copy.click"))), "%d ~ %d".formatted(pos.method_10263(), pos.method_10260()))}))}));
        return 1;
    }

    private static int locateSlimeChunk(CustomClientCommandSource source) throws CommandSyntaxException {
        if (source.getDimension() != Cubiomes.DIM_OVERWORLD()) {
            throw CommandExceptions.INVALID_DIMENSION_EXCEPTION.create();
        }
        long seed = (Long)source.getSeed().getSecond();
        class_1923 center = new class_1923(class_2338.method_49638((class_2374)source.getPosition()));
        SpiralLoop.Coordinate pos = SpiralLoop.spiral(center.field_9181, center.field_9180, 6400, (x, z) -> {
            class_5819 random = class_2919.method_12662((int)x, (int)z, (long)seed, (long)987234911L);
            return random.method_43048(10) == 0;
        });
        assert (pos != null);
        int blockPosX = (pos.x() << 4) + 9;
        int blockPosZ = (pos.z() << 4) + 9;
        source.sendFeedback((class_2561)class_2561.method_43469((String)"command.locate.feature.slimeChunk.foundAt", (Object[])new Object[]{ChatBuilder.copy(ChatBuilder.hover(ChatBuilder.accent("x: %d, z: %d".formatted(blockPosX, blockPosZ)), ChatBuilder.base(class_2561.method_43471((String)"command.locate.feature.slimeChunk.copy"))), "%d ~ %d".formatted(blockPosX, blockPosZ)), ChatBuilder.copy(ChatBuilder.hover(ChatBuilder.accent(pos.x() + " " + pos.z()), ChatBuilder.base(class_2561.method_43471((String)"command.locate.feature.slimeChunk.copyChunk"))), "%d %d".formatted(pos.x(), pos.z()))}));
        return 1;
    }

    private static int locateSpawn(CustomClientCommandSource source) throws CommandSyntaxException {
        try (Arena arena = Arena.ofConfined();){
            MemorySegment generator = Generator.allocate(arena);
            Cubiomes.setupGenerator(generator, source.getVersion(), 0);
            Cubiomes.applySeed(generator, source.getDimension(), (Long)source.getSeed().getSecond());
            MemorySegment pos = Cubiomes.getSpawn(arena, generator);
            source.sendFeedback((class_2561)ChatBuilder.chain(new class_2561[]{ChatBuilder.highlight(class_2561.method_43469((String)"command.locate.spawn.success", (Object[])new Object[]{ChatBuilder.copy(ChatBuilder.hover(ChatBuilder.accent("x: %d, z: %d".formatted(Pos.x(pos), Pos.z(pos))), ChatBuilder.base(class_2561.method_43471((String)"chat.copy.click"))), "%d ~ %d".formatted(Pos.x(pos), Pos.z(pos)))}))}));
            int n = 1;
            return n;
        }
    }
}

