/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.feature;

import com.github.cubiomes.Cubiomes;
import com.github.cubiomes.Generator;
import com.github.cubiomes.Pos;
import dev.xpple.seedmapper.command.arguments.StructurePredicateArgument;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.foreign.MemorySegment;
import java.util.function.IntFunction;

public final class StructureChecks {
    public static final int MAX_END_CITY_AND_FORTRESS_PIECES = Math.max(Cubiomes.END_CITY_PIECES_MAX(), 400);
    private static final Int2ObjectMap<IntFunction<GenerationCheck>> GENERATION_CHECKS;
    private static final Int2ObjectMap<PiecesPredicateCheck> PIECES_PREDICATE_CHECKS;
    private static final Int2ObjectMap<VariantPredicateCheck> VARIANT_PREDICATE_CHECKS;

    private StructureChecks() {
    }

    public static GenerationCheck getGenerationCheck(int structure) {
        return (GenerationCheck)((IntFunction)GENERATION_CHECKS.get(structure)).apply(structure);
    }

    public static PiecesPredicateCheck getPiecesPredicateCheck(int structure) {
        return (PiecesPredicateCheck)PIECES_PREDICATE_CHECKS.get(structure);
    }

    public static VariantPredicateCheck getVariantPredicateCheck(int structure) {
        return (VariantPredicateCheck)VARIANT_PREDICATE_CHECKS.get(structure);
    }

    private static IntFunction<GenerationCheck> baseGenerationCheck() {
        return structure -> (generator, memorySegment, regionX, regionZ, structurePos) -> {
            if (Cubiomes.getStructurePos(structure, Generator.mc(generator), Generator.seed(generator), regionX, regionZ, structurePos) == 0) {
                return false;
            }
            if (Cubiomes.isViableStructurePos(structure, generator, Pos.x(structurePos), Pos.z(structurePos), 0) == 0) {
                return false;
            }
            return Cubiomes.isViableStructureTerrain(structure, generator, Pos.x(structurePos), Pos.z(structurePos)) != 0;
        };
    }

    static {
        Int2ObjectOpenHashMap tempGenerationChecks = new Int2ObjectOpenHashMap();
        tempGenerationChecks.defaultReturnValue(StructureChecks.baseGenerationCheck());
        tempGenerationChecks.put(Cubiomes.End_City(), structure -> StructureChecks.baseGenerationCheck().apply(structure).and((generator, surfaceNoise, n, n2, structurePos) -> Cubiomes.isViableEndCityTerrain(generator, surfaceNoise, Pos.x(structurePos), Pos.z(structurePos)) != 0));
        GENERATION_CHECKS = Int2ObjectMaps.unmodifiable((Int2ObjectMap)tempGenerationChecks);
        Int2ObjectOpenHashMap tempPiecesPredicateChecks = new Int2ObjectOpenHashMap();
        tempPiecesPredicateChecks.defaultReturnValue((piecesPredicate, memorySegment, memorySegment2, memorySegment3) -> true);
        for (int structure2 : StructurePredicateArgument.STRUCTURE_PIECES.keySet()) {
            if (structure2 == Cubiomes.End_City()) {
                tempPiecesPredicateChecks.put(structure2, (piecesPredicate, pieces, generator, structurePos) -> {
                    int numPieces = Cubiomes.getEndCityPieces(pieces, Generator.seed(generator), Pos.x(structurePos) >> 4, Pos.z(structurePos) >> 4);
                    return piecesPredicate.test(numPieces, pieces);
                });
                continue;
            }
            if (structure2 == Cubiomes.Fortress()) {
                tempPiecesPredicateChecks.put(structure2, (piecesPredicate, pieces, generator, structurePos) -> {
                    int numPieces = Cubiomes.getFortressPieces(pieces, MAX_END_CITY_AND_FORTRESS_PIECES, Generator.mc(generator), Generator.seed(generator), Pos.x(structurePos) >> 4, Pos.z(structurePos) >> 4);
                    return piecesPredicate.test(numPieces, pieces);
                });
                continue;
            }
            throw new AssertionError();
        }
        PIECES_PREDICATE_CHECKS = Int2ObjectMaps.unmodifiable((Int2ObjectMap)tempPiecesPredicateChecks);
        Int2ObjectOpenHashMap tempVariantPredicateChecks = new Int2ObjectOpenHashMap();
        tempVariantPredicateChecks.defaultReturnValue((variantPredicate, memorySegment, memorySegment2, memorySegment3) -> true);
        for (int structure3 : StructurePredicateArgument.STRUCTURE_VARIANTS.keySet()) {
            tempVariantPredicateChecks.put(structure3, (variantPredicate, structureVariant, generator, structurePos) -> {
                int biome = Cubiomes.getBiomeAt(generator, 4, Pos.x(structurePos) >> 2, 80, Pos.z(structurePos) >> 2);
                Cubiomes.getVariant(structureVariant, structure3, Generator.mc(generator), Generator.seed(generator), Pos.x(structurePos), Pos.z(structurePos), biome);
                return variantPredicate.test(structureVariant);
            });
        }
        VARIANT_PREDICATE_CHECKS = Int2ObjectMaps.unmodifiable((Int2ObjectMap)tempVariantPredicateChecks);
    }

    @FunctionalInterface
    public static interface GenerationCheck {
        public boolean check(MemorySegment var1, MemorySegment var2, int var3, int var4, MemorySegment var5);

        default public GenerationCheck and(GenerationCheck other) {
            return (generator, surfaceNoise, regionX, regionZ, structurePos) -> this.check(generator, surfaceNoise, regionX, regionZ, structurePos) && other.check(generator, surfaceNoise, regionX, regionZ, structurePos);
        }
    }

    @FunctionalInterface
    public static interface PiecesPredicateCheck {
        public boolean check(StructurePredicateArgument.PiecesPredicate var1, MemorySegment var2, MemorySegment var3, MemorySegment var4);

        default public PiecesPredicateCheck and(PiecesPredicateCheck other) {
            return (piecesPredicate, pieces, generator, structurePos) -> this.check(piecesPredicate, pieces, generator, structurePos) && other.check(piecesPredicate, pieces, generator, structurePos);
        }
    }

    @FunctionalInterface
    public static interface VariantPredicateCheck {
        public boolean check(StructurePredicateArgument.VariantPredicate var1, MemorySegment var2, MemorySegment var3, MemorySegment var4);

        default public VariantPredicateCheck and(VariantPredicateCheck other) {
            return (variantPredicate, structureVariant, generator, structurePos) -> this.check(variantPredicate, structureVariant, generator, structurePos) && other.check(variantPredicate, structureVariant, generator, structurePos);
        }
    }
}

