/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.render;

import com.google.common.cache.CacheBuilder;
import dev.xpple.seedmapper.render.Line;
import dev.xpple.seedmapper.render.NoDepthLayer;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2806;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_9848;

public final class RenderManager {
    private static final Set<Line> lines = Collections.newSetFromMap(CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(5L)).build().asMap());

    private RenderManager() {
    }

    public static void drawBoxes(List<class_2338> posBatch, int colour) {
        HashSet lines = new HashSet();
        posBatch.forEach(pos -> {
            class_243 minPosition = new class_243((class_2382)pos);
            class_243 size = new class_243(1.0, 1.0, 1.0);
            RenderManager.addLine(new Line(minPosition, minPosition.method_1031(size.method_10216(), 0.0, 0.0), colour), lines);
            RenderManager.addLine(new Line(minPosition, minPosition.method_1031(0.0, size.method_10214(), 0.0), colour), lines);
            RenderManager.addLine(new Line(minPosition, minPosition.method_1031(0.0, 0.0, size.method_10215()), colour), lines);
            RenderManager.addLine(new Line(minPosition.method_1031(size.method_10216(), 0.0, size.method_10215()), minPosition.method_1031(size.method_10216(), 0.0, 0.0), colour), lines);
            RenderManager.addLine(new Line(minPosition.method_1031(size.method_10216(), 0.0, size.method_10215()), minPosition.method_1031(size.method_10216(), size.method_10214(), size.method_10215()), colour), lines);
            RenderManager.addLine(new Line(minPosition.method_1031(size.method_10216(), 0.0, size.method_10215()), minPosition.method_1031(0.0, 0.0, size.method_10215()), colour), lines);
            RenderManager.addLine(new Line(minPosition.method_1031(size.method_10216(), size.method_10214(), 0.0), minPosition.method_1031(size.method_10216(), 0.0, 0.0), colour), lines);
            RenderManager.addLine(new Line(minPosition.method_1031(size.method_10216(), size.method_10214(), 0.0), minPosition.method_1031(0.0, size.method_10214(), 0.0), colour), lines);
            RenderManager.addLine(new Line(minPosition.method_1031(size.method_10216(), size.method_10214(), 0.0), minPosition.method_1031(size.method_10216(), size.method_10214(), size.method_10215()), colour), lines);
            RenderManager.addLine(new Line(minPosition.method_1031(0.0, size.method_10214(), size.method_10215()), minPosition.method_1031(0.0, 0.0, size.method_10215()), colour), lines);
            RenderManager.addLine(new Line(minPosition.method_1031(0.0, size.method_10214(), size.method_10215()), minPosition.method_1031(0.0, size.method_10214(), 0.0), colour), lines);
            RenderManager.addLine(new Line(minPosition.method_1031(0.0, size.method_10214(), size.method_10215()), minPosition.method_1031(size.method_10216(), size.method_10214(), size.method_10215()), colour), lines);
        });
        RenderManager.lines.addAll(lines);
    }

    public static void clear() {
        lines.clear();
    }

    private static void addLine(Line line, Set<Line> lines) {
        if (!lines.add(line)) {
            lines.remove(line);
        }
    }

    public static void registerEvents() {
        WorldRenderEvents.AFTER_TRANSLUCENT.register(RenderManager::renderLines);
    }

    private static void renderLines(WorldRenderContext context) {
        lines.forEach(line -> {
            class_1923 chunkPos = new class_1923(class_2338.method_49638((class_2374)line.start()));
            if (context.world().method_8402(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, false) == null) {
                return;
            }
            Line relativeLine = line.offset(context.camera().method_19326().method_1021(-1.0));
            class_243 start = relativeLine.start();
            class_243 end = relativeLine.end();
            class_243 normal = end.method_1020(start).method_1029();
            int colour = line.colour();
            float red = class_9848.method_65101((int)colour);
            float green = class_9848.method_65102((int)colour);
            float blue = class_9848.method_65103((int)colour);
            class_4587 stack = context.matrixStack();
            stack.method_22903();
            class_4587.class_4665 pose = stack.method_23760();
            class_4588 buffer = context.consumers().getBuffer(NoDepthLayer.LINES_NO_DEPTH_LAYER);
            buffer.method_56824(pose, (float)start.field_1352, (float)start.field_1351, (float)start.field_1350).method_22915(red, green, blue, 1.0f).method_60831(pose, (float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350);
            buffer.method_56824(pose, (float)end.field_1352, (float)end.field_1351, (float)end.field_1350).method_22915(red, green, blue, 1.0f).method_60831(pose, (float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350);
            stack.method_22909();
        });
    }
}

