/*
 * Decompiled with CFR 0.152.
 */
package dev.xpple.seedmapper.util;

import org.jetbrains.annotations.Nullable;

public final class SpiralLoop {
    private SpiralLoop() {
    }

    @Nullable
    public static Coordinate spiral(int centerX, int centerZ, int radius, CoordinateCallback callback) {
        return SpiralLoop.spiral(centerX, centerZ, radius, 1, callback);
    }

    @Nullable
    public static Coordinate spiral(int centerX, int centerZ, int radius, int step, CoordinateCallback callback) {
        int x = centerX;
        int dx = 0;
        int z = centerZ;
        int dz = -step;
        int leftBoundX = centerX - radius;
        int rightBoundX = centerX + radius;
        int bottomBoundZ = centerZ - radius;
        int topBoundZ = centerZ + radius;
        long max = (2L * (long)radius + 1L) * (2L * (long)radius + 1L);
        int i = 0;
        while ((long)i < max) {
            if (leftBoundX <= x && x <= rightBoundX && bottomBoundZ <= z && z <= topBoundZ && callback.consume(x, z)) {
                return new Coordinate(x, z);
            }
            if (x - centerX == z - centerZ || x < centerX && x - centerX == centerZ - z || x > centerX && x - centerX == centerZ + step - z) {
                int temp = dx;
                dx = -dz;
                dz = temp;
            }
            x += dx;
            z += dz;
            ++i;
        }
        return null;
    }

    @FunctionalInterface
    public static interface CoordinateCallback {
        public boolean consume(int var1, int var2);
    }

    public record Coordinate(int x, int z) {
    }
}

