/*
 * Decompiled with CFR 0.152.
 */
package net.deathban;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import net.deathban.DeathBanPlugin;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class DeathBanConfig {
    private final DeathBanPlugin plugin;
    private final Logger logger;
    private File configFile;
    private FileConfiguration config;
    private String banMessage;
    private int banDuration;
    private int banDelay;
    private int deathsUntilBan;
    private boolean deathBanEnabled;
    private boolean discordWebhookEnabled;
    private String discordWebhookUrl;

    public DeathBanConfig(DeathBanPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    public void load() {
        this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        if (!this.configFile.exists()) {
            this.plugin.saveDefaultConfig();
            this.logger.info("Created default config file");
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.banMessage = this.config.getString("ban_message", "You died! This is a hardcore server.");
        this.banDuration = this.config.getInt("ban_duration", -1);
        this.banDelay = this.config.getInt("ban_delay", 0);
        this.deathsUntilBan = this.config.getInt("deaths_until_ban", 1);
        this.deathBanEnabled = this.config.getBoolean("death_ban_enabled", true);
        this.discordWebhookEnabled = this.config.getBoolean("discord_webhook_enabled", false);
        this.discordWebhookUrl = this.config.getString("discord_webhook_url", "");
        this.logger.info("Config loaded successfully");
    }

    public void save() {
        try {
            this.config.set("ban_message", (Object)this.banMessage);
            this.config.set("ban_duration", (Object)this.banDuration);
            this.config.set("ban_delay", (Object)this.banDelay);
            this.config.set("deaths_until_ban", (Object)this.deathsUntilBan);
            this.config.set("death_ban_enabled", (Object)this.deathBanEnabled);
            this.config.set("discord_webhook_enabled", (Object)this.discordWebhookEnabled);
            this.config.set("discord_webhook_url", (Object)this.discordWebhookUrl);
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.logger.severe("Failed to save config: " + e.getMessage());
        }
    }

    public String getBanMessage() {
        return this.banMessage;
    }

    public int getBanDuration() {
        return this.banDuration;
    }

    public int getBanDelay() {
        return this.banDelay;
    }

    public int getDeathsUntilBan() {
        return this.deathsUntilBan;
    }

    public boolean isDeathBanEnabled() {
        return this.deathBanEnabled;
    }

    public boolean isDiscordWebhookEnabled() {
        return this.discordWebhookEnabled;
    }

    public String getDiscordWebhookUrl() {
        return this.discordWebhookUrl;
    }
}

