/*
 * Decompiled with CFR 0.152.
 */
package net.deathban;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.deathban.DeathBanConfig;
import net.deathban.DiscordWebhook;
import net.kyori.adventure.text.Component;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DeathBanPlugin
extends JavaPlugin
implements Listener {
    private DeathBanConfig config;
    private DiscordWebhook webhook;
    private final Map<UUID, Integer> deathCounts = new HashMap<UUID, Integer>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = new DeathBanConfig(this);
        this.config.load();
        if (this.config.isDiscordWebhookEnabled()) {
            this.webhook = new DiscordWebhook(this.config.getDiscordWebhookUrl(), this.getLogger());
            this.getLogger().info("Discord webhook enabled");
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("DeathBan plugin enabled!");
    }

    public void onDisable() {
        this.getLogger().info("DeathBan plugin disabled!");
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!this.config.isDeathBanEnabled()) {
            return;
        }
        Player player = event.getPlayer();
        UUID playerUUID = player.getUniqueId();
        String playerName = player.getName();
        int deaths = this.deathCounts.getOrDefault(playerUUID, 0) + 1;
        this.deathCounts.put(playerUUID, deaths);
        this.getLogger().info("Player " + playerName + " has died " + deaths + " time(s). Deaths until ban: " + this.config.getDeathsUntilBan());
        if (deaths < this.config.getDeathsUntilBan()) {
            player.sendMessage((Component)Component.text((String)("\u00a7cYou have died " + deaths + " time(s). " + (this.config.getDeathsUntilBan() - deaths) + " more death(s) until ban!")));
            return;
        }
        this.getLogger().info("Player " + playerName + " will be banned");
        if (this.config.isDiscordWebhookEnabled() && this.webhook != null) {
            Player killer = player.getKiller();
            int x = player.getLocation().getBlockX();
            int y = player.getLocation().getBlockY();
            int z = player.getLocation().getBlockZ();
            if (killer != null) {
                this.webhook.sendDeathMessage(playerName, killer.getName(), true, x, y, z);
            } else {
                String cause = this.getDeathCause(player);
                this.webhook.sendDeathMessage(playerName, cause, false, x, y, z);
            }
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this, () -> {
            if (this.config.getBanDelay() > 0) {
                try {
                    Thread.sleep((long)this.config.getBanDelay() * 1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            player.kick((Component)Component.text((String)this.config.getBanMessage()));
            Date expiryDate = null;
            if (this.config.getBanDuration() > 0) {
                long durationMs = (long)this.config.getBanDuration() * 60L * 60L * 1000L;
                expiryDate = new Date(System.currentTimeMillis() + durationMs);
            }
            BanList banList = Bukkit.getBanList((BanList.Type)BanList.Type.NAME);
            banList.addBan(playerName, this.config.getBanMessage(), expiryDate, "Server");
            this.deathCounts.remove(playerUUID);
            if (this.config.getBanDuration() > 0) {
                this.getLogger().info("Player " + playerName + " has been banned for " + this.config.getBanDuration() + " hour(s)");
            } else {
                this.getLogger().info("Player " + playerName + " has been permanently banned");
            }
        }, (long)this.config.getBanDelay() * 20L);
    }

    private String getDeathCause(Player player) {
        if (player.getLastDamageCause() == null) {
            return "Unknown";
        }
        EntityDamageEvent.DamageCause cause = player.getLastDamageCause().getCause();
        switch (cause) {
            case CONTACT: {
                return "Cactus";
            }
            case ENTITY_ATTACK: 
            case ENTITY_SWEEP_ATTACK: {
                if (player.getLastDamageCause().getEntity() != null) {
                    return this.getMobName(player.getLastDamageCause().getEntity());
                }
                return "Mob";
            }
            case PROJECTILE: {
                if (player.getLastDamageCause().getEntity() != null) {
                    return this.getProjectileName(player.getLastDamageCause().getEntity());
                }
                return "Arrow";
            }
            case SUFFOCATION: {
                return "Suffocation";
            }
            case FALL: {
                return "Fall Damage";
            }
            case FIRE: {
                return "Fire";
            }
            case FIRE_TICK: {
                return "Fire";
            }
            case LAVA: {
                return "Lava";
            }
            case DROWNING: {
                return "Drowning";
            }
            case BLOCK_EXPLOSION: 
            case ENTITY_EXPLOSION: {
                return "Explosion";
            }
            case VOID: {
                return "The Void";
            }
            case LIGHTNING: {
                return "Lightning";
            }
            case SUICIDE: {
                return "Suicide";
            }
            case STARVATION: {
                return "Starvation";
            }
            case POISON: {
                return "Poison";
            }
            case MAGIC: {
                return "Magic";
            }
            case WITHER: {
                return "Wither";
            }
            case FALLING_BLOCK: {
                return "Falling Block";
            }
            case THORNS: {
                return "Thorns";
            }
            case DRAGON_BREATH: {
                return "Dragon Breath";
            }
            case CUSTOM: {
                return "Unknown";
            }
            case FLY_INTO_WALL: {
                return "Kinetic Energy";
            }
            case HOT_FLOOR: {
                return "Magma Block";
            }
            case CRAMMING: {
                return "Cramming";
            }
            case DRYOUT: {
                return "Dryout";
            }
            case FREEZE: {
                return "Freezing";
            }
            case SONIC_BOOM: {
                return "Sonic Boom";
            }
            case KILL: {
                return "Kill Command";
            }
            case WORLD_BORDER: {
                return "World Border";
            }
            case MELTING: {
                return "Snow Golem Melting";
            }
            case CAMPFIRE: {
                return "Campfire";
            }
        }
        return "Unknown";
    }

    private String getMobName(Entity entity) {
        switch (entity.getType()) {
            case ZOMBIE: {
                return "Zombie";
            }
            case CREEPER: {
                return "Creeper";
            }
            case SKELETON: {
                return "Skeleton";
            }
            case SPIDER: {
                return "Spider";
            }
            case CAVE_SPIDER: {
                return "Cave Spider";
            }
            case ENDERMAN: {
                return "Enderman";
            }
            case BLAZE: {
                return "Blaze";
            }
            case GHAST: {
                return "Ghast";
            }
            case SILVERFISH: {
                return "Silverfish";
            }
            case WITHER: {
                return "Wither";
            }
            case ENDER_DRAGON: {
                return "Ender Dragon";
            }
            case SLIME: {
                return "Slime";
            }
            case MAGMA_CUBE: {
                return "Magma Cube";
            }
            case WITCH: {
                return "Witch";
            }
            case ENDERMITE: {
                return "Endermite";
            }
            case GUARDIAN: {
                return "Guardian";
            }
            case ELDER_GUARDIAN: {
                return "Elder Guardian";
            }
            case WITHER_SKELETON: {
                return "Wither Skeleton";
            }
            case STRAY: {
                return "Stray";
            }
            case HUSK: {
                return "Husk";
            }
            case ZOMBIE_VILLAGER: {
                return "Zombie Villager";
            }
            case DROWNED: {
                return "Drowned";
            }
            case PHANTOM: {
                return "Phantom";
            }
            case PIGLIN: {
                return "Piglin";
            }
            case PIGLIN_BRUTE: {
                return "Piglin Brute";
            }
            case ZOMBIFIED_PIGLIN: {
                return "Zombified Piglin";
            }
            case STRIDER: {
                return "Strider";
            }
            case HOGLIN: {
                return "Hoglin";
            }
            case ZOGLIN: {
                return "Zoglin";
            }
            case WARDEN: {
                return "Warden";
            }
            case BREEZE: {
                return "Breeze";
            }
            case BOGGED: {
                return "Bogged";
            }
            case SHULKER: {
                return "Shulker";
            }
            case IRON_GOLEM: {
                return "Iron Golem";
            }
            case BEE: {
                return "Bee";
            }
            case WOLF: {
                return "Wolf";
            }
            case AXOLOTL: {
                return "Axolotl";
            }
            case FROG: {
                return "Frog";
            }
            case ALLAY: {
                return "Allay";
            }
            case GOAT: {
                return "Goat";
            }
            case POLAR_BEAR: {
                return "Polar Bear";
            }
            case PANDA: {
                return "Panda";
            }
            case LLAMA: {
                return "Llama";
            }
            case TRADER_LLAMA: {
                return "Trader Llama";
            }
            case VINDICATOR: {
                return "Vindicator";
            }
            case PILLAGER: {
                return "Pillager";
            }
            case EVOKER: {
                return "Evoker";
            }
            case RAVAGER: {
                return "Ravager";
            }
            case VEX: {
                return "Vex";
            }
            case VILLAGER: {
                return "Villager";
            }
            case WANDERING_TRADER: {
                return "Wandering Trader";
            }
            case PLAYER: {
                if (entity instanceof Player) {
                    return ((Player)entity).getName();
                }
                return "Player";
            }
            case DOLPHIN: {
                return "Dolphin";
            }
            case DONKEY: {
                return "Donkey";
            }
            case HORSE: {
                return "Horse";
            }
            case MULE: {
                return "Mule";
            }
            case OCELOT: {
                return "Ocelot";
            }
            case PARROT: {
                return "Parrot";
            }
            case RABBIT: {
                return "Rabbit";
            }
            case SHEEP: {
                return "Sheep";
            }
            case SKELETON_HORSE: {
                return "Skeleton Horse";
            }
            case TROPICAL_FISH: {
                return "Tropical Fish";
            }
            case TURTLE: {
                return "Turtle";
            }
            case ZOMBIE_HORSE: {
                return "Zombie Horse";
            }
        }
        String name = entity.getType().name().replace('_', ' ');
        return name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
    }

    private String getProjectileName(Entity entity) {
        switch (entity.getType()) {
            case ARROW: {
                return "Arrow";
            }
            case SPECTRAL_ARROW: {
                return "Spectral Arrow";
            }
            case TRIDENT: {
                return "Trident";
            }
            case FIREBALL: {
                return "Fireball";
            }
            case SMALL_FIREBALL: {
                return "Small Fireball";
            }
            case SHULKER_BULLET: {
                return "Shulker Bullet";
            }
            case SNOWBALL: {
                return "Snowball";
            }
            case EGG: {
                return "Egg";
            }
            case ENDER_PEARL: {
                return "Ender Pearl";
            }
            case WITHER_SKULL: {
                return "Wither Skull";
            }
            case BREEZE_WIND_CHARGE: {
                return "Wind Charge";
            }
        }
        return entity.getType().name();
    }
}

