/*
 * Decompiled with CFR 0.152.
 */
package net.deathban;

import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import net.deathban.libs.gson.JsonArray;
import net.deathban.libs.gson.JsonObject;

public class DiscordWebhook {
    private final String webhookUrl;
    private final Logger logger;

    public DiscordWebhook(String webhookUrl, Logger logger) {
        this.webhookUrl = webhookUrl;
        this.logger = logger;
    }

    public void sendDeathMessage(String playerName, String killer, boolean isPvP, int x, int y, int z) {
        if (this.webhookUrl == null || this.webhookUrl.isEmpty()) {
            return;
        }
        new Thread(() -> {
            try {
                int color;
                String description;
                JsonObject embed = new JsonObject();
                embed.addProperty("title", "Player Eliminated");
                if (isPvP) {
                    description = "**" + playerName + "** has been eliminated by **" + killer + "**!";
                    color = 0xFF0000;
                } else {
                    description = "**" + playerName + "** has been eliminated by **" + killer + "**!";
                    color = 65280;
                }
                embed.addProperty("description", description);
                embed.addProperty("color", color);
                JsonObject coordsField = new JsonObject();
                coordsField.addProperty("name", "Coordinates");
                coordsField.addProperty("value", x + " " + y + " " + z);
                coordsField.addProperty("inline", true);
                JsonObject timeField = new JsonObject();
                timeField.addProperty("name", "Time of Death");
                long unixTime = System.currentTimeMillis() / 1000L;
                timeField.addProperty("value", "<t:" + unixTime + ":f>");
                timeField.addProperty("inline", true);
                JsonArray fields = new JsonArray();
                fields.add(coordsField);
                fields.add(timeField);
                embed.add("fields", fields);
                JsonArray embeds = new JsonArray();
                embeds.add(embed);
                JsonObject payload = new JsonObject();
                payload.add("embeds", embeds);
                this.sendWebhook(payload.toString());
            }
            catch (Exception e) {
                this.logger.warning("Failed to send Discord webhook: " + e.getMessage());
            }
        }).start();
    }

    private void sendWebhook(String jsonPayload) throws Exception {
        URL url = new URL(this.webhookUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "DeathBan-Plugin");
        connection.setDoOutput(true);
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = jsonPayload.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
        int responseCode = connection.getResponseCode();
        if (responseCode < 200 || responseCode >= 300) {
            this.logger.warning("Discord webhook returned code: " + responseCode);
        }
        connection.disconnect();
    }
}

