/*
 * Decompiled with CFR 0.152.
 */
package net.deathban;

import com.mojang.authlib.GameProfile;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.deathban.DeathBanConfig;
import net.deathban.DiscordWebhook;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3330;
import net.minecraft.class_3336;
import net.minecraft.class_5250;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeathBan
implements ModInitializer {
    public static final String MOD_ID = "deathban";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"deathban");
    private static DeathBanConfig config;
    private static DiscordWebhook webhook;
    private static final Map<UUID, Integer> deathCounts;

    public void onInitialize() {
        LOGGER.info("DeathBan mod initialized!");
        config = new DeathBanConfig();
        config.load(FabricLoader.getInstance().getConfigDir());
        if (config.isDiscordWebhookEnabled()) {
            webhook = new DiscordWebhook(config.getDiscordWebhookUrl());
            LOGGER.info("Discord webhook enabled");
        }
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (!(entity instanceof class_3222)) {
                return;
            }
            class_3222 player = (class_3222)entity;
            if (!config.isDeathBanEnabled()) {
                return;
            }
            String playerName = player.method_5477().getString();
            UUID playerUUID = player.method_5667();
            int deaths = deathCounts.getOrDefault(playerUUID, 0) + 1;
            deathCounts.put(playerUUID, deaths);
            LOGGER.info("Player {} has died {} time(s). Deaths until ban: {}", new Object[]{playerName, deaths, config.getDeathsUntilBan()});
            if (deaths < config.getDeathsUntilBan()) {
                player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7cYou have died " + deaths + " time(s). " + (config.getDeathsUntilBan() - deaths) + " more death(s) until ban!")));
                return;
            }
            LOGGER.info("Player {} will be banned", (Object)playerName);
            if (config.isDiscordWebhookEnabled() && webhook != null) {
                int x = (int)player.method_23317();
                int y = (int)player.method_23318();
                int z = (int)player.method_23321();
                class_1297 patt0$temp = damageSource.method_5529();
                if (patt0$temp instanceof class_1657) {
                    class_1657 killer = (class_1657)patt0$temp;
                    webhook.sendDeathMessage(playerName, killer.method_5477().getString(), true, x, y, z);
                } else {
                    String cause = this.getDeathCause(damageSource);
                    webhook.sendDeathMessage(playerName, cause, false, x, y, z);
                }
            }
            new Thread(() -> {
                if (config.getBanDelay() > 0) {
                    try {
                        Thread.sleep((long)config.getBanDelay() * 1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
                player.method_5682().execute(() -> {
                    class_5250 banReason = class_2561.method_43470((String)config.getBanMessage());
                    player.field_13987.method_52396((class_2561)banReason);
                    GameProfile profile = new GameProfile(playerUUID, playerName);
                    Date expiryDate = null;
                    if (config.getBanDuration() > 0) {
                        long durationMs = (long)config.getBanDuration() * 60L * 60L * 1000L;
                        expiryDate = new Date(System.currentTimeMillis() + durationMs);
                    }
                    class_3336 bannedEntry = new class_3336(profile, null, "Server", expiryDate, config.getBanMessage());
                    player.method_5682().method_3760().method_14563().method_14633((class_3330)bannedEntry);
                    deathCounts.remove(playerUUID);
                    if (config.getBanDuration() > 0) {
                        LOGGER.info("Player {} has been banned for {} hour(s)", (Object)playerName, (Object)config.getBanDuration());
                    } else {
                        LOGGER.info("Player {} has been permanently banned", (Object)playerName);
                    }
                });
            }).start();
        });
    }

    private String getDeathCause(class_1282 source) {
        String name = source.method_5525();
        if (name.contains("fall")) {
            return "Fall Damage";
        }
        if (name.contains("lava")) {
            return "Lava";
        }
        if (name.contains("fire")) {
            return "Fire";
        }
        if (name.contains("drown")) {
            return "Drowning";
        }
        if (name.contains("suffocation")) {
            return "Suffocation";
        }
        if (name.contains("cactus")) {
            return "Cactus";
        }
        if (name.contains("explosion")) {
            return "Explosion";
        }
        if (name.contains("void")) {
            return "The Void";
        }
        if (name.contains("lightning")) {
            return "Lightning";
        }
        if (name.contains("starve")) {
            return "Starvation";
        }
        if (name.contains("poison")) {
            return "Poison";
        }
        if (name.contains("magic")) {
            return "Magic";
        }
        if (name.contains("wither")) {
            return "Wither";
        }
        if (name.contains("anvil")) {
            return "Anvil";
        }
        if (name.contains("fallingBlock")) {
            return "Falling Block";
        }
        if (name.contains("dragon")) {
            return "Dragon Breath";
        }
        if (name.contains("flyIntoWall")) {
            return "Kinetic Energy";
        }
        if (name.contains("hotFloor")) {
            return "Magma Block";
        }
        if (name.contains("cramming")) {
            return "Cramming";
        }
        if (name.contains("dryout")) {
            return "Dryout";
        }
        if (name.contains("freeze")) {
            return "Freezing";
        }
        if (name.contains("sonic")) {
            return "Sonic Boom";
        }
        if (name.contains("mob") || name.contains("player")) {
            if (source.method_5529() != null) {
                return source.method_5529().method_5477().getString();
            }
            return "Mob";
        }
        return "Unknown";
    }

    public static DeathBanConfig getConfig() {
        return config;
    }

    static {
        deathCounts = new HashMap<UUID, Integer>();
    }
}

