/*
 * Decompiled with CFR 0.152.
 */
package net.deathban;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeathBanConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"deathban-config");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE = "deathban.json";
    private String banMessage = "You died! This is a hardcore server.";
    private int banDuration = -1;
    private int banDelay = 0;
    private int deathsUntilBan = 1;
    private boolean deathBanEnabled = true;
    private boolean discordWebhookEnabled = false;
    private String discordWebhookUrl = "";

    public void load(Path configDir) {
        Path configPath = configDir.resolve(CONFIG_FILE);
        try {
            if (!Files.exists(configPath, new LinkOption[0])) {
                this.createDefaultConfig(configPath);
                return;
            }
            try (FileReader reader = new FileReader(configPath.toFile());){
                ConfigData data = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                if (data == null) {
                    this.createDefaultConfig(configPath);
                    return;
                }
                this.banMessage = data.ban_message;
                this.banDuration = data.ban_duration;
                this.banDelay = data.ban_delay;
                this.deathsUntilBan = data.deaths_until_ban;
                this.deathBanEnabled = data.death_ban_enabled;
                this.discordWebhookEnabled = data.discord_webhook_enabled;
                this.discordWebhookUrl = data.discord_webhook_url;
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to load config, using defaults", (Throwable)e);
            this.loadDefaults();
        }
    }

    private void createDefaultConfig(Path configPath) {
        try {
            ConfigData data = new ConfigData();
            try (FileWriter writer = new FileWriter(configPath.toFile());){
                GSON.toJson((Object)data, (Appendable)writer);
            }
            this.loadDefaults();
        }
        catch (Exception e) {
            LOGGER.error("Failed to create default config", (Throwable)e);
            this.loadDefaults();
        }
    }

    private void loadDefaults() {
        this.banMessage = "You died! This is a hardcore server.";
        this.banDuration = -1;
        this.banDelay = 0;
        this.deathsUntilBan = 1;
        this.deathBanEnabled = true;
        this.discordWebhookEnabled = false;
        this.discordWebhookUrl = "";
    }

    public String getBanMessage() {
        return this.banMessage;
    }

    public int getBanDuration() {
        return this.banDuration;
    }

    public int getBanDelay() {
        return this.banDelay;
    }

    public int getDeathsUntilBan() {
        return this.deathsUntilBan;
    }

    public boolean isDeathBanEnabled() {
        return this.deathBanEnabled;
    }

    public boolean isDiscordWebhookEnabled() {
        return this.discordWebhookEnabled;
    }

    public String getDiscordWebhookUrl() {
        return this.discordWebhookUrl;
    }

    public static class ConfigData {
        public String ban_message = "You died! This is a hardcore server.";
        public int ban_duration = -1;
        public int ban_delay = 0;
        public int deaths_until_ban = 1;
        public boolean death_ban_enabled = true;
        public boolean discord_webhook_enabled = false;
        public String discord_webhook_url = "";
    }
}

