/*
 * Decompiled with CFR 0.152.
 */
package net.deathban;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscordWebhook {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"discord-webhook");
    private final String webhookUrl;

    public DiscordWebhook(String webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public void sendDeathMessage(String playerName, String killer, boolean isPvP, int x, int y, int z) {
        if (this.webhookUrl == null || this.webhookUrl.isEmpty()) {
            return;
        }
        new Thread(() -> {
            try {
                int color;
                String description;
                JsonObject embed = new JsonObject();
                embed.addProperty("title", "Player Eliminated");
                if (isPvP) {
                    description = "**" + playerName + "** has been eliminated by **" + killer + "**!";
                    color = 0xFF0000;
                } else {
                    description = "**" + playerName + "** has been eliminated by **" + killer + "**!";
                    color = 65280;
                }
                embed.addProperty("description", description);
                embed.addProperty("color", (Number)color);
                JsonObject coordsField = new JsonObject();
                coordsField.addProperty("name", "Coordinates");
                coordsField.addProperty("value", x + " " + y + " " + z);
                coordsField.addProperty("inline", Boolean.valueOf(true));
                JsonObject timeField = new JsonObject();
                timeField.addProperty("name", "Time of Death");
                long unixTime = System.currentTimeMillis() / 1000L;
                timeField.addProperty("value", "<t:" + unixTime + ":f>");
                timeField.addProperty("inline", Boolean.valueOf(true));
                JsonArray fields = new JsonArray();
                fields.add((JsonElement)coordsField);
                fields.add((JsonElement)timeField);
                embed.add("fields", (JsonElement)fields);
                JsonArray embeds = new JsonArray();
                embeds.add((JsonElement)embed);
                JsonObject payload = new JsonObject();
                payload.add("embeds", (JsonElement)embeds);
                this.sendWebhook(payload.toString());
            }
            catch (Exception e) {
                LOGGER.warn("Failed to send Discord webhook: " + e.getMessage());
            }
        }).start();
    }

    private void sendWebhook(String jsonPayload) throws Exception {
        URL url = new URL(this.webhookUrl);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("User-Agent", "DeathBan-Fabric");
        connection.setDoOutput(true);
        try (OutputStream os = connection.getOutputStream();){
            byte[] input = jsonPayload.getBytes(StandardCharsets.UTF_8);
            os.write(input, 0, input.length);
        }
        int responseCode = connection.getResponseCode();
        if (responseCode < 200 || responseCode >= 300) {
            LOGGER.warn("Discord webhook returned code: " + responseCode);
        }
        connection.disconnect();
    }
}

