/*
 * Decompiled with CFR 0.152.
 */
package net.deathban;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.deathban.DeathBanConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3330;
import net.minecraft.class_3336;
import net.minecraft.class_5250;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeathBan
implements ModInitializer {
    public static final String MOD_ID = "deathban";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"deathban");
    private static DeathBanConfig config;
    private static final Set<UUID> usedItems;

    public void onInitialize() {
        LOGGER.info("DeathBan mod initialized!");
        config = new DeathBanConfig();
        config.load(FabricLoader.getInstance().getConfigDir());
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (entity instanceof class_3222) {
                class_3222 player = (class_3222)entity;
                String playerName = player.method_5477().getString();
                LOGGER.info("Player {} died and will be permanently banned", (Object)playerName);
                class_5250 banReason = class_2561.method_43470((String)config.getBanMessage());
                player.method_5682().execute(() -> DeathBan.lambda$onInitialize$0(player, (class_2561)banReason, playerName));
            }
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"givef").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"payload", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("stab");
            builder.suggest("nuke");
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(context -> {
            String payload = StringArgumentType.getString((CommandContext)context, (String)"payload");
            int amount = IntegerArgumentType.getInteger((CommandContext)context, (String)"amount");
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            class_1799 item = null;
            if (payload.equalsIgnoreCase("stab")) {
                item = DeathBan.createStabShot();
            } else if (payload.equalsIgnoreCase("nuke")) {
                item = DeathBan.createNukeShot();
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43470((String)"Invalid payload! Use 'stab' or 'nuke'"));
                return 0;
            }
            item.method_7939(amount);
            player.method_7270(item);
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)("Gave " + amount + "x " + payload + " shot to " + player.method_5477().getString())), true);
            return 1;
        })))));
        UseItemCallback.EVENT.register((player, world, hand) -> {
            if (world.field_9236 || !(player instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 serverPlayer = (class_3222)player;
            class_1799 stack = player.method_5998(hand);
            if (stack.method_7909() != class_1802.field_8378) {
                return class_1269.field_5811;
            }
            class_2561 name = (class_2561)stack.method_58694(class_9334.field_49631);
            if (name == null) {
                return class_1269.field_5811;
            }
            String itemName = name.getString();
            if (!itemName.equals("Stab Shot") && !itemName.equals("Nuke Shot")) {
                return class_1269.field_5811;
            }
            class_9279 customData = (class_9279)stack.method_58694(class_9334.field_49628);
            if (customData == null) {
                return class_1269.field_5811;
            }
            class_2487 nbt = customData.method_57461();
            if (!nbt.method_10545("item_uuid")) {
                return class_1269.field_5811;
            }
            Optional uuidOptional = nbt.method_10558("item_uuid");
            if (uuidOptional.isEmpty()) {
                return class_1269.field_5811;
            }
            UUID itemUUID = UUID.fromString((String)uuidOptional.get());
            if (usedItems.contains(itemUUID)) {
                return class_1269.field_5811;
            }
            usedItems.add(itemUUID);
            String playerName = serverPlayer.method_5477().getString();
            String command = itemName.equals("Stab Shot") ? "execute as " + playerName + " run orbitalstrike crosshair stab" : "execute as " + playerName + " run orbitalstrike crosshair nuke";
            serverPlayer.method_5682().execute(() -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                serverPlayer.method_5682().method_3734().method_44252(serverPlayer.method_5682().method_3739(), command);
            });
            stack.method_7934(1);
            return class_1269.field_5812;
        });
    }

    private static class_1799 createStabShot() {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8378);
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Stab Shot").method_27692(class_124.field_1065));
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_43470((String)"s").method_27692(class_124.field_1080))));
        stack.method_7974(stack.method_7936() - 1);
        class_2487 nbt = new class_2487();
        nbt.method_10582("item_uuid", UUID.randomUUID().toString());
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
        return stack;
    }

    private static class_1799 createNukeShot() {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8378);
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)"Nuke Shot").method_27692(class_124.field_1061));
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(List.of(class_2561.method_43470((String)"n").method_27692(class_124.field_1080))));
        stack.method_7974(stack.method_7936() - 1);
        class_2487 nbt = new class_2487();
        nbt.method_10582("item_uuid", UUID.randomUUID().toString());
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)nbt));
        return stack;
    }

    private static /* synthetic */ void lambda$onInitialize$0(class_3222 player, class_2561 banReason, String playerName) {
        player.field_13987.method_52396(banReason);
        GameProfile profile = new GameProfile(player.method_5667(), playerName);
        class_3336 bannedEntry = new class_3336(profile, null, "Server", null, config.getBanMessage());
        player.method_5682().method_3760().method_14563().method_14633((class_3330)bannedEntry);
        LOGGER.info("Player {} has been permanently banned", (Object)playerName);
    }

    static {
        usedItems = new HashSet<UUID>();
    }
}

