/*
 * Decompiled with CFR 0.152.
 */
package net.deathban;

import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeathBanConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"DeathBan Config");
    private static final String CONFIG_FILE = "deathban.toml";
    private String banMessage = "You died! This is a hardcore server.";

    public void load(Path configDir) {
        File configFile = configDir.resolve(CONFIG_FILE).toFile();
        if (!configFile.exists()) {
            this.save(configDir);
            LOGGER.info("Created default config file at {}", (Object)configFile.getAbsolutePath());
            return;
        }
        try {
            Toml toml = new Toml().read(configFile);
            this.banMessage = toml.getString("ban_message", "You died! This is a hardcore server.");
            LOGGER.info("Loaded config from {}", (Object)configFile.getAbsolutePath());
        }
        catch (Exception e) {
            LOGGER.error("Failed to load config, using defaults", (Throwable)e);
        }
    }

    public void save(Path configDir) {
        File configFile = configDir.resolve(CONFIG_FILE).toFile();
        try {
            configFile.getParentFile().mkdirs();
            HashMap<String, String> config = new HashMap<String, String>();
            config.put("ban_message", this.banMessage);
            TomlWriter writer = new TomlWriter();
            writer.write(config, configFile);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public String getBanMessage() {
        return this.banMessage;
    }
}

