/*
 * Decompiled with CFR 0.152.
 */
package net.deathban;

import com.moandjiezana.toml.Toml;
import com.moandjiezana.toml.TomlWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeathBanConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"DeathBan Config");
    private static final String CONFIG_FILE = "deathban.toml";
    private String banMessage = "You died! This is a hardcore server.";
    private int banDuration = -1;
    private int banDelay = 0;
    private int deathsUntilBan = 1;
    private boolean deathBanEnabled = true;

    public void load(Path configDir) {
        File configFile = configDir.resolve(CONFIG_FILE).toFile();
        if (!configFile.exists()) {
            this.save(configDir);
            LOGGER.info("Created default config file at {}", (Object)configFile.getAbsolutePath());
            return;
        }
        try {
            Toml toml = new Toml().read(configFile);
            this.banMessage = toml.getString("ban_message", "You died! This is a hardcore server.");
            this.banDuration = toml.getLong("ban_duration", Long.valueOf(-1L)).intValue();
            this.banDelay = toml.getLong("ban_delay", Long.valueOf(0L)).intValue();
            this.deathsUntilBan = toml.getLong("deaths_until_ban", Long.valueOf(1L)).intValue();
            this.deathBanEnabled = toml.getBoolean("death_ban_enabled", Boolean.valueOf(true));
            LOGGER.info("Loaded config from {}", (Object)configFile.getAbsolutePath());
        }
        catch (Exception e) {
            LOGGER.error("Failed to load config, using defaults", (Throwable)e);
        }
    }

    public void save(Path configDir) {
        File configFile = configDir.resolve(CONFIG_FILE).toFile();
        try {
            configFile.getParentFile().mkdirs();
            HashMap<String, Object> config = new HashMap<String, Object>();
            config.put("ban_message", this.banMessage);
            config.put("ban_duration", this.banDuration);
            config.put("ban_delay", this.banDelay);
            config.put("deaths_until_ban", this.deathsUntilBan);
            config.put("death_ban_enabled", this.deathBanEnabled);
            TomlWriter writer = new TomlWriter();
            writer.write(config, configFile);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public String getBanMessage() {
        return this.banMessage;
    }

    public int getBanDuration() {
        return this.banDuration;
    }

    public int getBanDelay() {
        return this.banDelay;
    }

    public int getDeathsUntilBan() {
        return this.deathsUntilBan;
    }

    public boolean isDeathBanEnabled() {
        return this.deathBanEnabled;
    }
}

