/*
 * Decompiled with CFR 0.152.
 */
package de.scholle.timer;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.TabExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Timer
extends JavaPlugin
implements TabExecutor {
    private TimerTask timerTask;
    private long secondsElapsed;
    private ChatColor baseColor;
    private static final Map<String, ChatColor> COLOR_NAMES = Map.ofEntries(Map.entry("black", ChatColor.BLACK), Map.entry("dark_blue", ChatColor.DARK_BLUE), Map.entry("dark_green", ChatColor.DARK_GREEN), Map.entry("dark_aqua", ChatColor.DARK_AQUA), Map.entry("dark_red", ChatColor.DARK_RED), Map.entry("dark_purple", ChatColor.DARK_PURPLE), Map.entry("gold", ChatColor.GOLD), Map.entry("gray", ChatColor.GRAY), Map.entry("dark_gray", ChatColor.DARK_GRAY), Map.entry("blue", ChatColor.BLUE), Map.entry("green", ChatColor.GREEN), Map.entry("aqua", ChatColor.AQUA), Map.entry("red", ChatColor.RED), Map.entry("light_purple", ChatColor.LIGHT_PURPLE), Map.entry("yellow", ChatColor.YELLOW), Map.entry("white", ChatColor.WHITE));

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfigValues();
        this.getCommand("timer").setExecutor((CommandExecutor)this);
        this.getCommand("timer").setTabCompleter((TabCompleter)this);
    }

    private void loadConfigValues() {
        FileConfiguration config = this.getConfig();
        String colorName = config.getString("base-color", "dark_green").toLowerCase();
        this.baseColor = COLOR_NAMES.getOrDefault(colorName, ChatColor.DARK_GREEN);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("Timer.op")) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Du hast keine Berechtigung!");
            return true;
        }
        if (args.length == 0) {
            return false;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                this.reloadConfig();
                this.loadConfigValues();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Config reloaded!");
                return true;
            }
            case "colour": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /timer colour <color>");
                    return true;
                }
                String colorName = args[1].toLowerCase();
                if (!COLOR_NAMES.containsKey(colorName)) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Unbekannte Farbe!");
                    return true;
                }
                this.getConfig().set("base-color", (Object)colorName);
                this.saveConfig();
                this.loadConfigValues();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Farbe ge\u00e4ndert!");
                return true;
            }
            case "start": {
                this.startTimer();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Timer gestartet!");
                return true;
            }
            case "pause": {
                this.pauseTimer();
                sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Timer pausiert!");
                return true;
            }
            case "restart": {
                this.restartTimer();
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Timer neu gestartet!");
                return true;
            }
            case "stop": {
                this.stopTimer();
                sender.sendMessage(String.valueOf(this.baseColor) + "Timer beendet nach " + this.formatTime(this.secondsElapsed));
                return true;
            }
            case "goal": {
                if (args.length < 2) {
                    sender.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /timer goal <advancement>");
                    return true;
                }
                sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Advancement gesetzt: " + args[1]);
                return true;
            }
        }
        return false;
    }

    private void startTimer() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timerTask = new TimerTask();
        this.timerTask.runTaskTimer((Plugin)this, 0L, 20L);
    }

    private void pauseTimer() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
    }

    private void restartTimer() {
        this.startTimer();
    }

    private void stopTimer() {
        if (this.timerTask != null) {
            this.timerTask.cancel();
        }
        this.timerTask = null;
    }

    private String formatTime(long totalSeconds) {
        long days = totalSeconds / 86400L;
        long hours = totalSeconds % 86400L / 3600L;
        long minutes = totalSeconds % 3600L / 60L;
        long seconds = totalSeconds % 60L;
        StringBuilder sb = new StringBuilder();
        if (days > 0L) {
            sb.append(days).append("d ");
        }
        if (hours > 0L) {
            sb.append(hours).append("h ");
        }
        if (minutes > 0L) {
            sb.append(minutes).append("m ");
        }
        sb.append(seconds).append("s");
        return sb.toString().trim();
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("reload", "colour", "start", "pause", "restart", "stop", "goal").stream().filter(s -> s.startsWith(args[0].toLowerCase())).collect(Collectors.toList());
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("colour")) {
            return COLOR_NAMES.keySet().stream().filter(s -> s.startsWith(args[1].toLowerCase())).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private class TimerTask
    extends BukkitRunnable {
        private TimerTask() {
        }

        public void run() {
            ++Timer.this.secondsElapsed;
            String timerText = Timer.this.formatTime(Timer.this.secondsElapsed);
            Component component = this.buildGradient(timerText, Timer.this.baseColor);
            for (Player player : Bukkit.getOnlinePlayers()) {
                player.sendActionBar(component);
            }
        }

        private Component buildGradient(String text, ChatColor base) {
            Color startColor = this.chatColorToColor(base);
            Color endColor = startColor.darker().darker();
            int len = text.length();
            TextComponent comp = Component.empty();
            for (int i = 0; i < len; ++i) {
                float ratio = (float)i / (float)(len - 1);
                Color c = this.blendColors(startColor, endColor, ratio);
                comp = comp.append(Component.text((String)String.valueOf(text.charAt(i)), (TextColor)TextColor.color((int)c.getRed(), (int)c.getGreen(), (int)c.getBlue())).decorate(TextDecoration.BOLD));
            }
            return comp;
        }

        private Color chatColorToColor(ChatColor c) {
            return switch (c) {
                case ChatColor.GREEN, ChatColor.DARK_GREEN -> new Color(0, 170, 0);
                case ChatColor.DARK_BLUE -> new Color(0, 0, 170);
                case ChatColor.DARK_AQUA -> new Color(0, 170, 170);
                case ChatColor.DARK_RED -> new Color(170, 0, 0);
                case ChatColor.DARK_PURPLE -> new Color(170, 0, 170);
                case ChatColor.GOLD -> new Color(255, 170, 0);
                case ChatColor.GRAY -> new Color(170, 170, 170);
                case ChatColor.DARK_GRAY -> new Color(85, 85, 85);
                case ChatColor.BLUE -> new Color(85, 85, 255);
                case ChatColor.AQUA -> new Color(85, 255, 255);
                case ChatColor.RED -> new Color(255, 85, 85);
                case ChatColor.LIGHT_PURPLE -> new Color(255, 85, 255);
                case ChatColor.YELLOW -> new Color(255, 255, 85);
                case ChatColor.WHITE -> new Color(255, 255, 255);
                default -> new Color(0, 170, 0);
            };
        }

        private Color blendColors(Color start, Color end, float ratio) {
            int r = (int)((float)start.getRed() * (1.0f - ratio) + (float)end.getRed() * ratio);
            int g = (int)((float)start.getGreen() * (1.0f - ratio) + (float)end.getGreen() * ratio);
            int b = (int)((float)start.getBlue() * (1.0f - ratio) + (float)end.getBlue() * ratio);
            return new Color(r, g, b);
        }
    }
}

