/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.GUI;

import com.google.common.collect.Lists;
import java.util.List;
import mypals.ml.GUI.BlueprintResultButton;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_361;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8666;

public class BlueprintBookResults {
    public static final class_8666 PAGE_FORWARD_TEXTURES = new class_8666(class_2960.method_60656((String)"recipe_book/page_forward"), class_2960.method_60656((String)"recipe_book/page_forward_highlighted"));
    public static final class_8666 PAGE_BACKWARD_TEXTURES = new class_8666(class_2960.method_60656((String)"recipe_book/page_backward"), class_2960.method_60656((String)"recipe_book/page_backward_highlighted"));
    private final List<BlueprintResultButton> resultButtons = Lists.newArrayListWithCapacity((int)20);
    private BlueprintResultButton hoveredResultButton;
    private class_361 nextPageButton;
    private class_361 prevPageButton;
    private int pageCount;
    private int currentPage;
    private int parentLeft;
    private int parentTop;
    private List<class_1799> itemStacks = Lists.newArrayList();

    public BlueprintBookResults() {
        for (int i = 0; i < 20; ++i) {
            this.resultButtons.add(new BlueprintResultButton());
        }
    }

    public void setItems(List<class_1799> itemStacks, boolean resetCurrentPage) {
        this.itemStacks = itemStacks;
        this.pageCount = (int)Math.ceil((double)itemStacks.size() / 25.0);
        if (this.pageCount <= this.currentPage || resetCurrentPage) {
            this.currentPage = 0;
        }
        this.refreshResultButtons();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.nextPageButton.method_25402(mouseX, mouseY, button);
        this.prevPageButton.method_25402(mouseX, mouseY, button);
        return false;
    }

    public void refreshResultButtons() {
        int startIndex = 25 * this.currentPage;
        this.resultButtons.clear();
        while (this.resultButtons.size() < 25) {
            this.resultButtons.add(new BlueprintResultButton());
        }
        this.setItemPos(this.parentLeft, this.parentTop);
        for (int i = 0; i < 25; ++i) {
            BlueprintResultButton button = this.resultButtons.get(i);
            if (startIndex + i < this.itemStacks.size()) {
                button.setItemStack(this.itemStacks.get(startIndex + i));
                button.visible = true;
                continue;
            }
            button.visible = false;
        }
        if (this.nextPageButton != null && this.prevPageButton != null) {
            this.updatePageButtons();
        }
    }

    void updatePageButtons() {
        this.nextPageButton.field_22764 = this.pageCount > 1 && this.currentPage < this.pageCount - 1;
        this.prevPageButton.field_22764 = this.pageCount > 1 && this.currentPage > 0;
    }

    public void draw(class_332 context, int x, int y, int mouseX, int mouseY, float delta) {
        if (this.pageCount > 1) {
            class_5250 pageText = class_2561.method_43469((String)"gui.recipebook.page", (Object[])new Object[]{this.currentPage + 1, this.pageCount});
            int textWidth = class_310.method_1551().field_1772.method_27525((class_5348)pageText);
            context.method_51439(class_310.method_1551().field_1772, (class_2561)pageText, x - textWidth / 2 + 73 + 35, y + 141, -1, false);
        }
        this.hoveredResultButton = null;
        for (BlueprintResultButton button : this.resultButtons) {
            button.method_25394(context, mouseX, mouseY, delta);
            if (!button.visible || !button.method_25405(mouseX, mouseY)) continue;
            this.hoveredResultButton = button;
        }
        this.prevPageButton.method_25394(context, mouseX, mouseY, delta);
        this.nextPageButton.method_25394(context, mouseX, mouseY, delta);
    }

    public void drawTooltip(class_332 context, int x, int y) {
        if (class_310.method_1551().field_1755 != null && this.hoveredResultButton != null) {
            context.method_51434(class_310.method_1551().field_1772, this.hoveredResultButton.$getTooltip(), x, y);
        }
    }

    public void initialize(class_310 client, int parentLeft, int parentTop) {
        this.setItemPos(parentLeft, parentTop);
        this.nextPageButton = new class_361(parentLeft + 93 + 35, parentTop + 137, 12, 17, false){

            public void method_25348(double mouseX, double mouseY) {
                if (BlueprintBookResults.this.currentPage < BlueprintBookResults.this.pageCount) {
                    ++BlueprintBookResults.this.currentPage;
                    BlueprintBookResults.this.refreshResultButtons();
                }
            }
        };
        this.nextPageButton.method_1962(PAGE_FORWARD_TEXTURES);
        this.nextPageButton.field_22764 = false;
        this.prevPageButton = new class_361(parentLeft + 38 + 35, parentTop + 137, 12, 17, true){

            public void method_25348(double mouseX, double mouseY) {
                if (BlueprintBookResults.this.currentPage > 0) {
                    --BlueprintBookResults.this.currentPage;
                    BlueprintBookResults.this.refreshResultButtons();
                }
            }
        };
        this.prevPageButton.method_1962(PAGE_BACKWARD_TEXTURES);
        this.prevPageButton.field_22764 = false;
    }

    public void setItemPos(int parentLeft, int parentTop) {
        this.parentLeft = parentLeft;
        this.parentTop = parentTop;
        for (int i = 0; i < this.resultButtons.size(); ++i) {
            this.resultButtons.get(i).method_48229(parentLeft + 11 + 25 * (i % 5), parentTop + 10 + 25 * (i / 5));
        }
    }
}

