/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.GUI;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6382;

public class BlueprintResultButton
extends class_339 {
    private int x;
    private int y;
    private class_1799 itemStack;
    public boolean visible = false;
    private static final int BUTTON_SIZE = 25;
    private static final class_2960 SLOT_MATCH = class_2960.method_60656((String)"recipe_book/slot_many_craftable");
    private static final class_2960 SLOT_OK = class_2960.method_60656((String)"recipe_book/slot_craftable");
    private static final class_2960 SLOT_MISSING = class_2960.method_60656((String)"recipe_book/slot_uncraftable");

    public BlueprintResultButton() {
        super(0, 0, 25, 25, class_5244.field_39003);
    }

    public void method_48229(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setItemStack(class_1799 stack) {
        this.itemStack = stack;
    }

    public List<class_2561> $getTooltip() {
        ArrayList<class_2561> list = new ArrayList<class_2561>(class_437.method_25408((class_310)class_310.method_1551(), (class_1799)this.itemStack));
        list.add(class_2561.method_30163((String)BlueprintResultButton.formatToBoxStackCount(BlueprintResultButton.getMissingItemCount(class_310.method_1551(), this.itemStack.method_7909(), this.itemStack.method_7947()), this.itemStack.method_7914()).replace("/", "")));
        return list;
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.itemStack != null) {
            boolean enough = BlueprintResultButton.hasItemInInventory(class_310.method_1551(), this.itemStack.method_7909(), this.itemStack.method_7947());
            if (this.itemStack.method_7947() >= 1) {
                String text;
                int missingCount = BlueprintResultButton.getMissingItemCount(class_310.method_1551(), this.itemStack.method_7909(), this.itemStack.method_7947());
                if (enough) {
                    RenderSystem.setShaderColor((float)0.8f, (float)1.0f, (float)0.8f, (float)1.0f);
                    context.method_52706(SLOT_OK, this.x, this.y, 25, 25);
                    text = "\u221a";
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                } else {
                    text = BlueprintResultButton.formatToBoxStackCount(missingCount, this.itemStack.method_7914());
                    if (missingCount >= this.itemStack.method_7947()) {
                        RenderSystem.setShaderColor((float)1.0f, (float)0.8f, (float)0.8f, (float)1.0f);
                        context.method_52706(SLOT_MISSING, this.x, this.y, 25, 25);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    } else {
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)0.8f, (float)1.0f);
                        context.method_52706(SLOT_MATCH, this.x, this.y, 25, 25);
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                }
                RenderSystem.disableDepthTest();
                if (missingCount < this.itemStack.method_7914()) {
                    context.method_51445(this.itemStack, this.x + 4, this.y + 4);
                } else if (missingCount >= this.itemStack.method_7914() && missingCount < this.itemStack.method_7914() * 27) {
                    context.method_51445(this.itemStack, this.x + 2, this.y + 2);
                    context.method_51445(this.itemStack, this.x + 6, this.y + 6);
                } else {
                    context.method_51445(this.itemStack, this.x + 4, this.y + 4);
                    context.method_51448().method_22903();
                    context.method_51448().method_22905(0.5f, 0.5f, 0.5f);
                    context.method_51448().method_46416((float)(this.x + 23), (float)(this.y - 2), 200.0f);
                    context.method_51445(class_1802.field_8545.method_7854(), this.x + 6, this.y + 6);
                    context.method_51448().method_22909();
                }
                RenderSystem.enableDepthTest();
                this.drawItemCount(context, class_310.method_1551().field_1772, this.x + 4, this.y + 4, text);
            }
        }
        if (this.isHovered(mouseX, mouseY) && this.visible) {
            context.method_51434(class_310.method_1551().field_1772, this.$getTooltip(), mouseX, mouseY);
        }
    }

    protected void method_47399(class_6382 builder) {
    }

    public static String formatToBoxStackCount(int number, int maxStackCount) {
        if (number < 0) {
            return "0";
        }
        int box = number / (maxStackCount * 27);
        int remaining = number % (maxStackCount * 27);
        int stack = remaining / maxStackCount;
        int c = remaining % maxStackCount;
        StringBuilder result = new StringBuilder();
        if (box > 0) {
            result.append(box).append("Box(es) + ");
        }
        if (stack > 0 || box > 0) {
            if (!result.isEmpty()) {
                result.append("/");
            }
            result.append(stack).append("Stack(s) + ");
        }
        if (c > 0 || stack > 0 || box > 0) {
            if (!result.isEmpty()) {
                result.append("/");
            }
            result.append(c);
        }
        return !result.isEmpty() ? result.toString() : "0";
    }

    public void drawItemCount(class_332 drawContext, class_327 textRenderer, int x, int y, String text) {
        drawContext.method_51448().method_22903();
        text = text.replace("Box(es) + ", "|");
        text = text.replace("Stack(s) + ", "|");
        if (text.getBytes().length > 3) {
            if (text.split("/").length == 2) {
                drawContext.method_51448().method_46416((float)x, (float)y, 200.0f);
                drawContext.method_51448().method_22905(0.5f, 0.5f, 0.5f);
                BlueprintResultButton.drawMultiColorText(drawContext, 40 - textRenderer.method_1727(text), 28, text.split("/"), new int[]{Color.CYAN.getRGB(), Color.WHITE.getRGB()});
            } else {
                drawContext.method_51448().method_46416((float)x, (float)y, 200.0f);
                drawContext.method_51448().method_22905(0.5f, 0.5f, 0.5f);
                BlueprintResultButton.drawMultiColorText(drawContext, 48 - textRenderer.method_1727(text), 28, text.split("/"), new int[]{Color.GREEN.getRGB(), Color.CYAN.getRGB(), Color.WHITE.getRGB()});
            }
        } else {
            drawContext.method_51448().method_46416((float)x, (float)y, 200.0f);
            drawContext.method_51433(textRenderer, text, 18 - textRenderer.method_1727(text), 10, 0xFFFFFF, true);
        }
        drawContext.method_51448().method_22909();
    }

    private boolean isHovered(int mouseX, int mouseY) {
        return mouseX >= this.x && mouseX < this.x + 25 && mouseY >= this.y && mouseY < this.y + 25;
    }

    public static void drawMultiColorText(class_332 context, int x, int y, String[] parts, int[] colors) {
        if (parts.length == 0 || colors.length == 0) {
            return;
        }
        int currentX = x;
        int lastColor = colors[colors.length - 1];
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            int color = i < colors.length ? colors[i] : lastColor;
            context.method_51433(class_310.method_1551().field_1772, part, currentX, y, color, true);
            currentX += class_310.method_1551().field_1772.method_1727(part);
        }
    }

    public static int getMissingItemCount(class_310 client, class_1792 itemToCheck, int requiredCount) {
        if (client == null || client.field_1724 == null) {
            return requiredCount;
        }
        class_1661 inventory = client.field_1724.method_31548();
        int totalCount = 0;
        for (int i = 0; i < inventory.method_5439(); ++i) {
            class_1799 stack = inventory.method_5438(i);
            if (stack.method_7960() || !stack.method_7909().equals(itemToCheck)) continue;
            totalCount += stack.method_7947();
        }
        return Math.max(0, requiredCount - totalCount);
    }

    public static boolean hasItemInInventory(class_310 client, class_1792 itemToCheck, int requiredCount) {
        return BlueprintResultButton.getMissingItemCount(client, itemToCheck, requiredCount) == 0;
    }
}

