/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml.GUI;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.materials.MaterialListEntry;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import mypals.ml.GUI.BlueprintBookResults;
import mypals.ml.GUI.BlueprintGroup;
import mypals.ml.GUI.BlueprintGroupButtonWidget;
import mypals.ml.MaterialBreakdown;
import mypals.ml.TellMeWhatINeed;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1714;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_361;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import net.minecraft.class_8666;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class BlueprintWidget
implements class_4068,
class_364,
class_6379 {
    protected static final class_2960 TEXTURE = class_2960.method_60656((String)"textures/gui/recipe_book.png");
    private static final Logger log = LoggerFactory.getLogger(BlueprintWidget.class);
    private int leftOffset;
    private int parentWidth;
    private int parentHeight;
    private final int LOADING_TIMEOUT = 5000;
    private class_361 toggleMaterialBreakDownButton;
    public class_342 depthField;
    private class_310 client;
    private class_1714 craftingScreenHandler;
    public final BlueprintBookResults materialArea = new BlueprintBookResults();
    private boolean narrow;
    public boolean open;
    private List<SchematicPlacement> placements;
    private final List<BlueprintGroupButtonWidget> tabButtons = Lists.newArrayList();
    private int x;
    private int y;
    private int loadingTime = 0;
    private class_361 nextTabPageButton;
    private class_361 prevTabPageButton;
    private int tabPageCount;
    private int currentTabPage;
    public BlueprintGroupButtonWidget currentTab;
    public static final class_8666 BLUEPRINT_BUTTON_TEXTURES = new class_8666(class_2960.method_60655((String)"tellmewhatineed", (String)"textures/blueprint_button.png"), class_2960.method_60655((String)"tellmewhatineed", (String)"textures/blueprint_button_highlighted.png"));
    private static final class_8666 BREAKDOWN_BUTTON_TEXTURES = new class_8666(class_2960.method_60655((String)"tellmewhatineed", (String)"textures/breakdown_enabled.png"), class_2960.method_60655((String)"tellmewhatineed", (String)"textures/breakdown_disabled.png"), class_2960.method_60655((String)"tellmewhatineed", (String)"textures/breakdown_enabled_highlighted.png"), class_2960.method_60655((String)"tellmewhatineed", (String)"textures/breakdown_disabled_highlighted.png"));

    public void initialize(final int parentWidth, final int parentHeight, class_310 client, boolean narrow) {
        this.parentWidth = parentWidth;
        this.parentHeight = parentHeight;
        this.client = client;
        this.narrow = narrow;
        this.leftOffset = narrow ? 0 : 86;
        this.x = (parentWidth - 147) / 2 - this.leftOffset;
        this.y = (parentHeight - 166) / 2;
        this.placements = this.getPlacements();
        this.open = false;
        this.loadingTime = 0;
        int buttonX = (this.parentWidth - 147) / 2 - this.leftOffset - 30;
        int buttonY = (this.parentHeight - 166) / 2 + 166 - 17;
        this.nextTabPageButton = new class_361(buttonX + 20, buttonY, 12, 17, false){

            public void method_25348(double mouseX, double mouseY) {
                if (BlueprintWidget.this.currentTabPage < BlueprintWidget.this.tabPageCount) {
                    ++BlueprintWidget.this.currentTabPage;
                    BlueprintWidget.this.refreshTabButtons();
                    BlueprintWidget.this.refreshItems();
                }
            }
        };
        this.nextTabPageButton.method_1962(BlueprintBookResults.PAGE_FORWARD_TEXTURES);
        this.prevTabPageButton = new class_361(buttonX - 15, buttonY, 12, 17, true){

            public void method_25348(double mouseX, double mouseY) {
                if (BlueprintWidget.this.currentTabPage > 0) {
                    --BlueprintWidget.this.currentTabPage;
                    BlueprintWidget.this.refreshTabButtons();
                    BlueprintWidget.this.refreshItems();
                }
            }
        };
        this.prevTabPageButton.method_1962(BlueprintBookResults.PAGE_BACKWARD_TEXTURES);
        this.toggleMaterialBreakDownButton = new class_361(buttonX + 40, buttonY - 11, 26, 16, false){

            public void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
                int i = (parentWidth - 147) / 2 - BlueprintWidget.this.leftOffset;
                int j = (parentHeight - 166) / 2;
                if (this.field_45390 != null) {
                    RenderSystem.disableDepthTest();
                    context.method_25290(this.field_45390.method_52729(this.field_2194, this.method_25367()), this.method_46426(), this.method_46427(), 0.0f, 0.0f, 26, 16, 26, 16);
                    RenderSystem.enableDepthTest();
                }
            }

            public void method_25348(double mouseX, double mouseY) {
                BlueprintWidget.this.toggleBreakdownMaterials();
                BlueprintWidget.this.updateTooltip();
                BlueprintWidget.this.refreshItems();
            }
        };
        this.toggleMaterialBreakDownButton.method_1962(BREAKDOWN_BUTTON_TEXTURES);
        this.depthField = new class_342(this, class_310.method_1551().field_1772, buttonX + 70, buttonY - 11, 20, 16, (class_2561)class_2561.method_43470((String)"Target Depth")){

            public void method_25348(double mouseX, double mouseY) {
                this.method_25365(true);
            }
        };
        this.depthField.method_1852("-1");
        this.depthField.method_1868(0xFFFFFF);
        this.depthField.method_47404(class_2561.method_30163((String)"-1"));
        this.updateTooltip();
    }

    private void updateTooltip() {
        this.toggleMaterialBreakDownButton.method_47400(this.toggleMaterialBreakDownButton.method_1965() ? class_7919.method_47407((class_2561)class_2561.method_30163((String)"Break down into base materials.")) : class_7919.method_47407((class_2561)class_2561.method_30163((String)"Display actual materials.")));
    }

    private void toggleBreakdownMaterials() {
        this.toggleMaterialBreakDownButton.method_1964(!this.toggleMaterialBreakDownButton.method_1965());
    }

    public void toggleOpen() {
        boolean bl = this.open = !this.open;
        if (this.open) {
            this.reset();
        }
        TellMeWhatINeed.bluePrintBookEnabled = this.open;
    }

    public boolean isOpen() {
        return this.open;
    }

    public int findLeftEdge(int width, int backgroundWidth) {
        int i = this.isOpen() && !this.narrow ? 177 + (width - backgroundWidth - 200) / 2 : (width - backgroundWidth) / 2;
        return i;
    }

    public void drawTooltip(class_332 context, int mouseX, int mouseY) {
        if (this.isOpen()) {
            this.materialArea.drawTooltip(context, mouseX, mouseY);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.isOpen()) {
            context.method_51448().method_22903();
            context.method_51448().method_46416(0.0f, 0.0f, 100.0f);
            int i = (this.parentWidth - 147) / 2 - this.leftOffset;
            int j = (this.parentHeight - 166) / 2;
            context.method_25302(TEXTURE, i, j, 1, 1, 147, 166);
            for (BlueprintGroupButtonWidget blueprintGroupButtonWidget : this.tabButtons) {
                blueprintGroupButtonWidget.method_25394(context, mouseX, mouseY, delta);
            }
            if (this.currentTab != null) {
                if (this.currentTab.getBlueprintGroup().getState() == BlueprintGroup.BlueprintState.LOADING) {
                    class_327 class_3272 = class_310.method_1551().field_1772;
                    int n = i + 73 - this.client.field_1772.method_1727("Load Timeout") / 2;
                    Objects.requireNonNull(this.client.field_1772);
                    context.method_51433(class_3272, "Loading materials...", n, j + 83 - 9 / 2, 0x555555, false);
                    this.tryLoadItems();
                } else if (this.currentTab.getBlueprintGroup().getState() == BlueprintGroup.BlueprintState.LOADED) {
                    this.materialArea.draw(context, i, j, mouseX, mouseY, delta);
                    this.depthField.method_25394(context, mouseX, mouseY, delta);
                } else if (this.currentTab.getBlueprintGroup().getState() == BlueprintGroup.BlueprintState.TIMEOUT) {
                    class_327 class_3273 = class_310.method_1551().field_1772;
                    int n = i + 73 - this.client.field_1772.method_1727("Load Timeout") / 2;
                    Objects.requireNonNull(this.client.field_1772);
                    context.method_51433(class_3273, "Load Timeout", n, j + 83 - 9 / 2, 0xFF5555, false);
                }
            }
            context.method_51448().method_22909();
            this.nextTabPageButton.method_25394(context, mouseX, mouseY, delta);
            if (this.tabPageCount > 1) {
                context.method_51433(class_310.method_1551().field_1772, this.currentTabPage + 1 + "/" + this.tabPageCount, this.nextTabPageButton.method_46426() - 18, this.nextTabPageButton.method_46427() + 5, -1, false);
            }
            this.prevTabPageButton.method_25394(context, mouseX, mouseY, delta);
            this.toggleMaterialBreakDownButton.method_25394(context, mouseX, mouseY, delta);
        }
    }

    private void refreshTabButtons() {
        int i = (this.parentWidth - 147) / 2 - this.leftOffset - 30;
        int j = (this.parentHeight - 166) / 2 + 3;
        this.tabPageCount = (int)Math.ceil((double)this.tabButtons.size() / 5.0);
        if (this.currentTabPage >= this.tabPageCount) {
            this.currentTabPage = Math.max(0, this.tabPageCount - 1);
        }
        int startIndex = this.currentTabPage * 5;
        int endIndex = Math.min(startIndex + 5, this.tabButtons.size());
        int l = 0;
        this.tabButtons.forEach(button -> {
            button.method_1964(false);
            button.field_22764 = false;
        });
        for (int k = startIndex; k < endIndex; ++k) {
            BlueprintGroupButtonWidget button2 = this.tabButtons.get(k);
            button2.method_48229(i, j + 27 * l++);
            button2.field_22764 = true;
        }
        if (!this.tabButtons.isEmpty()) {
            this.currentTab = this.tabButtons.get(startIndex);
            this.currentTab.method_1964(true);
        }
        this.nextTabPageButton.field_22764 = this.tabPageCount > 1 && this.currentTabPage < this.tabPageCount - 1;
        this.prevTabPageButton.field_22764 = this.tabPageCount > 1 && this.currentTabPage > 0;
    }

    private List<SchematicPlacement> getPlacements() {
        ArrayList<SchematicPlacement> placementList = new ArrayList<SchematicPlacement>();
        class_310 client = class_310.method_1551();
        class_243 playerPos = client.field_1724.method_19538();
        int viewDistance = (Integer)client.field_1690.method_42503().method_41753();
        int playerChunkX = class_3532.method_15357((double)(playerPos.field_1352 / 16.0));
        int playerChunkZ = class_3532.method_15357((double)(playerPos.field_1350 / 16.0));
        if (client.field_1724 == null) {
            return placementList;
        }
        SchematicPlacementManager manager = DataManager.getSchematicPlacementManager();
        manager.getAllSchematicsPlacements().forEach(placement -> {
            Set touchedChunks = placement.getTouchedChunks();
            if (touchedChunks == null || touchedChunks.isEmpty()) {
                return;
            }
            boolean allInView = touchedChunks.stream().allMatch(chunkPos -> {
                int chunkX = chunkPos.field_9181;
                int chunkZ = chunkPos.field_9180;
                int chunkDistance = Math.max(Math.abs(chunkX - playerChunkX), Math.abs(chunkZ - playerChunkZ));
                return chunkDistance <= viewDistance;
            });
            if (allInView || !placement.getMaterialList().getMaterialsAll().isEmpty()) {
                placementList.add((SchematicPlacement)placement);
            }
        });
        return placementList;
    }

    public class_6379.class_6380 method_37018() {
        return this.open ? class_6379.class_6380.field_33785 : class_6379.class_6380.field_33784;
    }

    public boolean equals(Object obj) {
        return false;
    }

    public int hashCode() {
        return 0;
    }

    public void method_37020(class_6382 builder) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.isOpen()) {
            this.materialArea.mouseClicked(mouseX, mouseY, button);
            this.nextTabPageButton.method_25402(mouseX, mouseY, button);
            this.prevTabPageButton.method_25402(mouseX, mouseY, button);
            this.toggleMaterialBreakDownButton.method_25402(mouseX, mouseY, button);
            if (!this.depthField.method_25402(mouseX, mouseY, button)) {
                this.depthField.method_25365(false);
            }
            int startIndex = this.currentTabPage * 5;
            int endIndex = Math.min(startIndex + 5, this.tabButtons.size());
            for (int k = startIndex; k < endIndex; ++k) {
                BlueprintGroupButtonWidget tabButton = this.tabButtons.get(k);
                if (!tabButton.field_22764 || !tabButton.method_25402(mouseX, mouseY, button)) continue;
                if (this.currentTab != tabButton) {
                    if (this.currentTab != null) {
                        this.currentTab.method_1964(false);
                    }
                    this.currentTab = tabButton;
                    this.currentTab.method_1964(true);
                }
                this.refreshItems();
                return true;
            }
        }
        return false;
    }

    public void method_25365(boolean focused) {
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.depthField.method_25404(keyCode, scanCode, modifiers)) {
            this.refreshItems();
            return true;
        }
        return false;
    }

    public boolean method_25400(char chr, int modifiers) {
        if (this.depthField.method_25400(chr, modifiers)) {
            this.refreshItems();
            return true;
        }
        return super.method_25400(chr, modifiers);
    }

    public boolean method_25370() {
        return false;
    }

    public void reset() {
        this.loadingTime = 0;
        int i = (this.parentWidth - 147) / 2 - this.leftOffset;
        int j = (this.parentHeight - 166) / 2;
        this.placements = this.getPlacements();
        this.tabButtons.clear();
        for (SchematicPlacement placement : this.placements) {
            this.tabButtons.add(new BlueprintGroupButtonWidget(new BlueprintGroup(placement.getName(), placement)));
        }
        this.refreshTabButtons();
        this.refreshItems();
        this.materialArea.initialize(this.client, i, j);
        this.materialArea.updatePageButtons();
    }

    public void tryLoadItems() {
        if (this.currentTab != null) {
            if (this.loadingTime < 5000) {
                List<MaterialListEntry> entries = this.currentTab.getBlueprintGroup().getItems();
                if (!entries.isEmpty()) {
                    this.setItems(entries, (this.parentWidth - 147) / 2 - this.leftOffset, (this.parentHeight - 166) / 2);
                    this.loadingTime = 0;
                } else {
                    ++this.loadingTime;
                }
            } else {
                this.currentTab.getBlueprintGroup().setState(BlueprintGroup.BlueprintState.TIMEOUT);
                this.loadingTime = 0;
            }
        }
    }

    public void refreshItems() {
        int x = (this.parentWidth - 147) / 2 - this.leftOffset;
        int y = (this.parentHeight - 166) / 2;
        if (this.tabButtons.size() <= 0) {
            return;
        }
        List<MaterialListEntry> entries = this.currentTab.getBlueprintGroup().getItems();
        if (entries.isEmpty()) {
            this.currentTab.getBlueprintGroup().refreshList();
            this.currentTab.getBlueprintGroup().setState(BlueprintGroup.BlueprintState.LOADING);
        } else {
            this.setItems(entries, x, y);
        }
    }

    public void setItems(List<MaterialListEntry> entries, int x, int y) {
        ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
        entries.forEach(entry -> itemStacks.add(new class_1799((class_1935)entry.getStack().method_7909(), entry.getCountMissing())));
        if (this.toggleMaterialBreakDownButton.method_1965()) {
            int depth = -1;
            try {
                if (Integer.parseInt(this.depthField.method_1882()) > 0) {
                    depth = Integer.parseInt(this.depthField.method_1882());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            MaterialBreakdown.BreakdownResult result = MaterialBreakdown.getBaseMaterials(itemStacks, depth);
            this.materialArea.setItems(MaterialBreakdown.mergeItemStacks(result.getMaterials()), true);
            this.depthField.method_1862(true);
        } else {
            this.materialArea.setItems(itemStacks, true);
            this.depthField.method_1862(false);
        }
        this.materialArea.setItemPos(x, y);
        this.currentTab.getBlueprintGroup().setState(BlueprintGroup.BlueprintState.LOADED);
    }
}

