/*
 * Decompiled with CFR 0.152.
 */
package mypals.ml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1863;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_310;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterialBreakdown {
    private static final Logger log = LoggerFactory.getLogger(MaterialBreakdown.class);
    private static final Set<class_1792> BASE_MATERIALS = Set.of(class_1802.field_8620, class_1802.field_8695, class_1802.field_8477, class_1802.field_8600, class_1802.field_8713, class_1802.field_27022, class_1802.field_22020, class_1802.field_8725, class_1802.field_8759, class_1802.field_33401, class_1802.field_33402, class_1802.field_33400, class_1802.field_8675, class_1802.field_8397, class_1802.field_19044, class_1802.field_8258, class_1802.field_8745);
    private static final Set<class_1792> WOOL_VARIANTS = new HashSet<class_1792>(Arrays.asList(class_1802.field_19044, class_1802.field_19058, class_1802.field_19055, class_1802.field_19057, class_1802.field_19048, class_1802.field_19059, class_1802.field_19056, class_1802.field_19053, class_1802.field_19051, class_1802.field_19047, class_1802.field_19052, class_1802.field_19049, class_1802.field_19046, class_1802.field_19045, class_1802.field_19050, class_1802.field_19054));
    private static final Set<class_1792> BED_VARIANTS = new HashSet<class_1792>(Arrays.asList(class_1802.field_8258, class_1802.field_8789, class_1802.field_8893, class_1802.field_8368, class_1802.field_8863, class_1802.field_8112, class_1802.field_8464, class_1802.field_8390, class_1802.field_8754, class_1802.field_8286, class_1802.field_8146, class_1802.field_8679, class_1802.field_8349, class_1802.field_8059, class_1802.field_8417, class_1802.field_8262));

    public static BreakdownResult getBaseMaterials(List<class_1799> targetStacks, int targetDepth) {
        if (targetStacks == null || targetStacks.isEmpty()) {
            return new BreakdownResult(new ArrayList<class_1799>(), 0);
        }
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            log.warn("World is null, cannot access RecipeManager");
            return new BreakdownResult(new ArrayList<class_1799>(), 0);
        }
        class_1863 recipeManager = client.field_1687.method_8433();
        HashMap<class_1792, Integer> baseMaterials = new HashMap<class_1792, Integer>();
        HashSet<class_1792> visited = new HashSet<class_1792>();
        int[] maxDepth = new int[]{0};
        for (class_1799 stack : targetStacks) {
            if (stack.method_7960()) continue;
            MaterialBreakdown.breakdownItemStack(stack, recipeManager, baseMaterials, visited, 1, 0, targetDepth, maxDepth);
        }
        ArrayList<class_1799> result = new ArrayList<class_1799>();
        baseMaterials.forEach((item, count) -> {
            if (item != class_1802.field_8162) {
                result.add(new class_1799((class_1935)item, count.intValue()));
            }
        });
        return new BreakdownResult(result, maxDepth[0]);
    }

    private static void breakdownItemStack(class_1799 stack, class_1863 recipeManager, Map<class_1792, Integer> baseMaterials, Set<class_1792> visited, int multiplier, int currentDepth, int targetDepth, int[] maxDepth) {
        if (stack.method_7960() || stack.method_7909() == class_1802.field_8162) {
            return;
        }
        class_1792 item = stack.method_7909();
        maxDepth[0] = Math.max(maxDepth[0], currentDepth);
        if (targetDepth != -1 && currentDepth >= targetDepth || BASE_MATERIALS.contains(item)) {
            MaterialBreakdown.addBaseMaterial(item, baseMaterials, stack.method_7947() * multiplier);
            return;
        }
        if (visited.contains(item)) {
            MaterialBreakdown.addBaseMaterial(item, baseMaterials, stack.method_7947() * multiplier);
            return;
        }
        visited.add(item);
        if (WOOL_VARIANTS.contains(item)) {
            MaterialBreakdown.handleColoredItem(stack, class_1802.field_19044, baseMaterials, multiplier);
            visited.remove(item);
            return;
        }
        if (BED_VARIANTS.contains(item)) {
            MaterialBreakdown.handleColoredItem(stack, class_1802.field_8258, baseMaterials, multiplier);
            visited.remove(item);
            return;
        }
        Optional<class_3955> recipeOpt = MaterialBreakdown.findRecipeByOutput(stack, recipeManager);
        if (recipeOpt.isEmpty()) {
            MaterialBreakdown.addBaseMaterial(item, baseMaterials, stack.method_7947() * multiplier);
            return;
        }
        class_3955 recipe = recipeOpt.get();
        class_1799 output = recipe.method_8110(null);
        int outputCount = output.method_7947();
        int requiredCrafts = (int)Math.ceil((double)stack.method_7947() * (double)multiplier / (double)outputCount);
        class_2371 ingredients = recipe.method_8117();
        for (class_1856 ingredient : ingredients) {
            class_1799[] matchingStacks;
            if (ingredient.method_8103() || (matchingStacks = ingredient.method_8105()).length == 0) continue;
            class_1799 ingredientStack = matchingStacks[0].method_7972();
            ingredientStack.method_7939(requiredCrafts);
            MaterialBreakdown.breakdownItemStack(ingredientStack, recipeManager, baseMaterials, visited, 1, currentDepth + 1, targetDepth, maxDepth);
        }
        visited.remove(item);
    }

    private static void handleColoredItem(class_1799 stack, class_1792 baseItem, Map<class_1792, Integer> baseMaterials, int multiplier) {
        int count = stack.method_7947() * multiplier;
        class_1792 item = stack.method_7909();
        MaterialBreakdown.addBaseMaterial(baseItem, baseMaterials, count);
        class_1792 dye = MaterialBreakdown.getDyeForItem(item);
        if (dye != null) {
            MaterialBreakdown.addBaseMaterial(dye, baseMaterials, count);
        }
    }

    private static class_1792 getDyeForItem(class_1792 item) {
        if (item == class_1802.field_19058 || item == class_1802.field_8789) {
            return class_1802.field_8264;
        }
        if (item == class_1802.field_19055 || item == class_1802.field_8893) {
            return class_1802.field_8345;
        }
        if (item == class_1802.field_19057 || item == class_1802.field_8368) {
            return class_1802.field_8408;
        }
        if (item == class_1802.field_19048 || item == class_1802.field_8863) {
            return class_1802.field_8192;
        }
        if (item == class_1802.field_19059 || item == class_1802.field_8112) {
            return class_1802.field_8226;
        }
        if (item == class_1802.field_19056 || item == class_1802.field_8464) {
            return class_1802.field_8099;
        }
        if (item == class_1802.field_19053 || item == class_1802.field_8390) {
            return class_1802.field_8632;
        }
        if (item == class_1802.field_19051 || item == class_1802.field_8754) {
            return class_1802.field_8298;
        }
        if (item == class_1802.field_19047 || item == class_1802.field_8286) {
            return class_1802.field_8273;
        }
        if (item == class_1802.field_19052 || item == class_1802.field_8146) {
            return class_1802.field_8851;
        }
        if (item == class_1802.field_19049 || item == class_1802.field_8679) {
            return class_1802.field_8131;
        }
        if (item == class_1802.field_19046 || item == class_1802.field_8349) {
            return class_1802.field_8669;
        }
        if (item == class_1802.field_19045 || item == class_1802.field_8059) {
            return class_1802.field_8492;
        }
        if (item == class_1802.field_19050 || item == class_1802.field_8417) {
            return class_1802.field_8330;
        }
        if (item == class_1802.field_19054 || item == class_1802.field_8262) {
            return class_1802.field_8296;
        }
        return null;
    }

    private static Optional<class_3955> findRecipeByOutput(class_1799 output, class_1863 recipeManager) {
        return recipeManager.method_30027(class_3956.field_17545).stream().map(entry -> (class_3955)entry.comp_1933()).filter(recipe -> class_1799.method_7984((class_1799)recipe.method_8110(null), (class_1799)output)).findFirst();
    }

    private static void addBaseMaterial(class_1792 item, Map<class_1792, Integer> baseMaterials, int count) {
        baseMaterials.merge(item, count, Integer::sum);
    }

    public static List<class_1799> mergeItemStacks(List<class_1799> stacks) {
        if (stacks == null || stacks.isEmpty()) {
            return new ArrayList<class_1799>();
        }
        Map<class_1792, Integer> mergedStacks = stacks.stream().filter(stack -> !stack.method_7960()).collect(Collectors.groupingBy(class_1799::method_7909, Collectors.summingInt(class_1799::method_7947)));
        ArrayList<class_1799> result = new ArrayList<class_1799>();
        mergedStacks.forEach((item, totalCount) -> result.add(new class_1799((class_1935)item, totalCount.intValue())));
        return result;
    }

    public static class BreakdownResult {
        private final List<class_1799> materials;
        private final int maxDepth;

        public BreakdownResult(List<class_1799> materials, int maxDepth) {
            this.materials = materials;
            this.maxDepth = maxDepth;
        }

        public List<class_1799> getMaterials() {
            return this.materials;
        }

        public int getMaxDepth() {
            return this.maxDepth;
        }
    }
}

