/*
 * Decompiled with CFR 0.152.
 */
package de.artemis.laboratoryblocks.common.blocks;

import de.artemis.laboratoryblocks.common.blockentities.ChiseledLaboratoryBookShelfBlockEntity;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledLaboratoryBookShelfBlock
extends ChiseledBookShelfBlock {
    private final Supplier<ChiseledLaboratoryBookShelfBlock> block;

    public ChiseledLaboratoryBookShelfBlock(Supplier<ChiseledLaboratoryBookShelfBlock> block, BlockBehaviour.Properties properties) {
        super(properties);
        this.block = block;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof ChiseledLaboratoryBookShelfBlockEntity) {
            ChiseledLaboratoryBookShelfBlockEntity bookShelfBlockEntity = (ChiseledLaboratoryBookShelfBlockEntity)blockEntity;
            Optional<Vec2> optional = ChiseledLaboratoryBookShelfBlock.m_260871_(blockHitResult, (Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_));
            if (optional.isEmpty()) {
                return InteractionResult.PASS;
            }
            int hitSlot = ChiseledLaboratoryBookShelfBlock.m_261279_(optional.get());
            if (((Boolean)blockState.m_61143_((Property)f_260698_.get(hitSlot))).booleanValue()) {
                ChiseledLaboratoryBookShelfBlock.removeBook(level, blockPos, player, bookShelfBlockEntity, hitSlot);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            ItemStack itemInHand = player.m_21120_(interactionHand);
            if (itemInHand.m_204117_(ItemTags.f_244646_)) {
                ChiseledLaboratoryBookShelfBlock.addBook(level, blockPos, player, bookShelfBlockEntity, itemInHand, hitSlot);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    private static Optional<Vec2> m_260871_(BlockHitResult blockHitResult, Direction direction) {
        Direction blockHitResultDirection = blockHitResult.m_82434_();
        if (direction != blockHitResultDirection) {
            return Optional.empty();
        }
        BlockPos blockPos = blockHitResult.m_82425_().m_121945_(blockHitResultDirection);
        Vec3 vec3 = blockHitResult.m_82450_().m_82492_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_());
        double x = vec3.m_7096_();
        double y = vec3.m_7098_();
        double z = vec3.m_7094_();
        return switch (blockHitResultDirection) {
            case Direction.NORTH -> Optional.of(new Vec2((float)(1.0 - x), (float)y));
            case Direction.SOUTH -> Optional.of(new Vec2((float)x, (float)y));
            case Direction.WEST -> Optional.of(new Vec2((float)z, (float)y));
            case Direction.EAST -> Optional.of(new Vec2((float)(1.0 - z), (float)y));
            case Direction.DOWN, Direction.UP -> Optional.empty();
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private static int m_261279_(Vec2 pHitPos) {
        int $$1 = pHitPos.f_82471_ >= 0.5f ? 0 : 1;
        int $$2 = ChiseledLaboratoryBookShelfBlock.m_261181_(pHitPos.f_82470_);
        return $$2 + $$1 * 3;
    }

    private static int m_261181_(float pX) {
        float $$1 = 0.0625f;
        float $$2 = 0.375f;
        if (pX < 0.375f) {
            return 0;
        }
        float $$3 = 0.6875f;
        return pX < 0.6875f ? 1 : 2;
    }

    private static void addBook(Level level, BlockPos blockPos, Player player, ChiseledLaboratoryBookShelfBlockEntity blockEntity, ItemStack books, int slot) {
        if (!level.f_46443_) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)books.m_41720_()));
            SoundEvent soundEvent = books.m_150930_(Items.f_42690_) ? SoundEvents.f_256863_ : SoundEvents.f_256961_;
            blockEntity.m_6836_(slot, books.m_41620_(1));
            level.m_5594_((Player)null, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player.m_7500_()) {
                books.m_41769_(1);
            }
            level.m_142346_((Entity)player, GameEvent.f_157792_, blockPos);
        }
    }

    private static void removeBook(Level pLevel, BlockPos pPos, Player pPlayer, ChiseledLaboratoryBookShelfBlockEntity pBlockEntity, int pSlot) {
        if (!pLevel.f_46443_) {
            ItemStack $$5 = pBlockEntity.m_7407_(pSlot, 1);
            SoundEvent $$6 = $$5.m_150930_(Items.f_42690_) ? SoundEvents.f_257000_ : SoundEvents.f_256717_;
            pLevel.m_5594_((Player)null, pPos, $$6, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!pPlayer.m_150109_().m_36054_($$5)) {
                pPlayer.m_36176_($$5, false);
            }
            pLevel.m_142346_((Entity)pPlayer, GameEvent.f_157792_, pPos);
        }
    }

    @Nullable
    public BlockEntity m_142194_(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new ChiseledLaboratoryBookShelfBlockEntity(blockPos, blockState);
    }

    public void m_6810_(BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, BlockState newBlockState, boolean movedByPiston) {
        if (!blockState.m_60713_(newBlockState.m_60734_())) {
            ChiseledLaboratoryBookShelfBlockEntity bookShelfBlockEntity;
            BlockEntity blockEntity = level.m_7702_(blockPos);
            if (blockEntity instanceof ChiseledLaboratoryBookShelfBlockEntity && !(bookShelfBlockEntity = (ChiseledLaboratoryBookShelfBlockEntity)blockEntity).m_7983_()) {
                for (int i = 0; i < 6; ++i) {
                    ItemStack books = bookShelfBlockEntity.m_8020_(i);
                    if (books.m_41619_()) continue;
                    Containers.m_18992_((Level)level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (ItemStack)books);
                }
                bookShelfBlockEntity.m_6211_();
                level.m_46717_(blockPos, (Block)this);
            }
            super.m_6810_(blockState, level, blockPos, newBlockState, movedByPiston);
        }
    }

    public int m_6782_(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos) {
        if (level.m_5776_()) {
            return 0;
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof ChiseledLaboratoryBookShelfBlockEntity) {
            ChiseledLaboratoryBookShelfBlockEntity bookShelfBlockEntity = (ChiseledLaboratoryBookShelfBlockEntity)blockEntity;
            return bookShelfBlockEntity.getLastInteractedSlot() + 1;
        }
        return 0;
    }
}

