/*
 * Decompiled with CFR 0.152.
 */
package de.artemis.laboratoryblocks.common.blockentities;

import com.mojang.logging.LogUtils;
import de.artemis.laboratoryblocks.common.blocks.ChiseledLaboratoryBookShelfBlock;
import de.artemis.laboratoryblocks.common.registration.ModBlockEntities;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ChiseledLaboratoryBookShelfBlockEntity
extends BlockEntity
implements Container {
    public static final int MAX_BOOKS_IN_STORAGE = 6;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final NonNullList<ItemStack> items;
    private int lastInteractedSlot = -1;
    private LazyOptional<?> itemHandler = LazyOptional.of(this::createUnSidedHandler);

    public ChiseledLaboratoryBookShelfBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.CHISELED_LABORATORY_BOOKSHELF_BLOCK_ENTITY.get(), blockPos, blockState);
        this.items = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
    }

    protected IItemHandler createUnSidedHandler() {
        return new InvWrapper((Container)this);
    }

    private void updateState(int pSlot) {
        if (pSlot >= 0 && pSlot < 6) {
            this.lastInteractedSlot = pSlot;
            BlockState blockstate = this.getBlockState();
            for (int i = 0; i < ChiseledLaboratoryBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.size(); ++i) {
                boolean flag = !this.getItem(i).isEmpty();
                BooleanProperty booleanproperty = (BooleanProperty)ChiseledLaboratoryBookShelfBlock.SLOT_OCCUPIED_PROPERTIES.get(i);
                blockstate = (BlockState)blockstate.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(flag));
            }
            Objects.requireNonNull(this.level).setBlock(this.worldPosition, blockstate, 3);
            this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.worldPosition, GameEvent.Context.of((BlockState)blockstate));
        } else {
            LOGGER.error("Expected slot 0-5, got {}", (Object)pSlot);
        }
    }

    protected void loadAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items.clear();
        ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        this.lastInteractedSlot = tag.getInt("last_interacted_slot");
    }

    protected void saveAdditional(@NotNull CompoundTag tag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (boolean)true, (HolderLookup.Provider)registries);
        tag.putInt("last_interacted_slot", this.lastInteractedSlot);
    }

    public int count() {
        return (int)this.items.stream().filter(Predicate.not(ItemStack::isEmpty)).count();
    }

    public void clearContent() {
        this.items.clear();
    }

    public int getContainerSize() {
        return 6;
    }

    public boolean isEmpty() {
        return this.items.stream().allMatch(ItemStack::isEmpty);
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack itemstack = Objects.requireNonNullElse((ItemStack)this.items.get(slot), ItemStack.EMPTY);
        this.items.set(slot, (Object)ItemStack.EMPTY);
        if (!itemstack.isEmpty()) {
            this.updateState(slot);
        }
        return itemstack;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        return this.removeItem(slot, 1);
    }

    public void setItem(int pSlot, ItemStack pStack) {
        if (pStack.is(ItemTags.BOOKSHELF_BOOKS)) {
            this.items.set(pSlot, (Object)pStack);
            this.updateState(pSlot);
        } else if (pStack.isEmpty()) {
            this.removeItem(pSlot, 1);
        }
    }

    public boolean canTakeItem(Container container, int slot, @NotNull ItemStack itemStack) {
        return container.hasAnyMatching(p_327306_ -> p_327306_.isEmpty() ? true : ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)p_327306_) && p_327306_.getCount() + itemStack.getCount() <= container.getMaxStackSize(p_327306_));
    }

    public int getMaxStackSize() {
        return 1;
    }

    public boolean stillValid(@NotNull Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public boolean canPlaceItem(int slot, ItemStack itemStack) {
        return itemStack.is(ItemTags.BOOKSHELF_BOOKS) && this.getItem(slot).isEmpty() && itemStack.getCount() == this.getMaxStackSize();
    }

    public int getLastInteractedSlot() {
        return this.lastInteractedSlot;
    }

    protected void collectImplicitComponents(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.items));
    }

    public void removeComponentsFromTag(CompoundTag pTag) {
        pTag.remove("Items");
    }

    public <T> @NotNull LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && !this.remove) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemHandler = LazyOptional.of(this::createUnSidedHandler);
    }
}

