/*
 * Decompiled with CFR 0.152.
 */
package de.artemis.laboratoryblocks.common.blocks;

import de.artemis.laboratoryblocks.common.blockentities.ChiseledLaboratoryBookShelfBlockEntity;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChiseledBookShelfBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChiseledLaboratoryBookShelfBlock
extends ChiseledBookShelfBlock {
    public ChiseledLaboratoryBookShelfBlock(Supplier<ChiseledLaboratoryBookShelfBlock> block, BlockBehaviour.Properties properties) {
        super(properties);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack itemStack, @NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos, @NotNull Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof ChiseledLaboratoryBookShelfBlockEntity) {
            ChiseledLaboratoryBookShelfBlockEntity chiseledbookshelfblockentity = (ChiseledLaboratoryBookShelfBlockEntity)blockEntity;
            if (!itemStack.is(ItemTags.BOOKSHELF_BOOKS)) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            OptionalInt optionalint = this.getHitSlot(blockHitResult, blockState);
            if (optionalint.isEmpty()) {
                return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
            }
            if (((Boolean)blockState.getValue((Property)SLOT_OCCUPIED_PROPERTIES.get(optionalint.getAsInt()))).booleanValue()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            ChiseledLaboratoryBookShelfBlock.addBook(level, blockPos, player, chiseledbookshelfblockentity, itemStack, optionalint.getAsInt());
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION;
    }

    private static Optional<Vec2> getRelativeHitCoordinatesForBlockFace(BlockHitResult blockHitResult, Direction direction) {
        Direction blockHitResultDirection = blockHitResult.getDirection();
        if (direction != blockHitResultDirection) {
            return Optional.empty();
        }
        BlockPos blockPos = blockHitResult.getBlockPos().relative(blockHitResultDirection);
        Vec3 vec3 = blockHitResult.getLocation().subtract((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ());
        double x = vec3.x();
        double y = vec3.y();
        double z = vec3.z();
        return switch (blockHitResultDirection) {
            case Direction.NORTH -> Optional.of(new Vec2((float)(1.0 - x), (float)y));
            case Direction.SOUTH -> Optional.of(new Vec2((float)x, (float)y));
            case Direction.WEST -> Optional.of(new Vec2((float)z, (float)y));
            case Direction.EAST -> Optional.of(new Vec2((float)(1.0 - z), (float)y));
            case Direction.DOWN, Direction.UP -> Optional.empty();
            default -> throw new IncompatibleClassChangeError();
        };
    }

    private OptionalInt getHitSlot(BlockHitResult pHitReselt, BlockState pState) {
        return ChiseledLaboratoryBookShelfBlock.getRelativeHitCoordinatesForBlockFace(pHitReselt, (Direction)pState.getValue((Property)HorizontalDirectionalBlock.FACING)).map(p_327255_ -> {
            int i = p_327255_.y >= 0.5f ? 0 : 1;
            int j = ChiseledLaboratoryBookShelfBlock.getSection(p_327255_.x);
            return OptionalInt.of(j + i * 3);
        }).orElseGet(OptionalInt::empty);
    }

    private static int getSection(float pX) {
        float $$1 = 0.0625f;
        float $$2 = 0.375f;
        if (pX < 0.375f) {
            return 0;
        }
        float $$3 = 0.6875f;
        return pX < 0.6875f ? 1 : 2;
    }

    private static void addBook(Level level, BlockPos blockPos, Player player, ChiseledLaboratoryBookShelfBlockEntity blockEntity, ItemStack books, int slot) {
        if (!level.isClientSide) {
            player.awardStat(Stats.ITEM_USED.get((Object)books.getItem()));
            SoundEvent soundEvent = books.is(Items.ENCHANTED_BOOK) ? SoundEvents.CHISELED_BOOKSHELF_INSERT_ENCHANTED : SoundEvents.CHISELED_BOOKSHELF_INSERT;
            blockEntity.setItem(slot, books.split(1));
            level.playSound((Player)null, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (player.isCreative()) {
                books.grow(1);
            }
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, blockPos);
        }
    }

    private static void removeBook(Level pLevel, BlockPos pPos, Player pPlayer, ChiseledLaboratoryBookShelfBlockEntity pBlockEntity, int pSlot) {
        if (!pLevel.isClientSide) {
            ItemStack $$5 = pBlockEntity.removeItem(pSlot, 1);
            SoundEvent $$6 = $$5.is(Items.ENCHANTED_BOOK) ? SoundEvents.CHISELED_BOOKSHELF_PICKUP_ENCHANTED : SoundEvents.CHISELED_BOOKSHELF_PICKUP;
            pLevel.playSound((Player)null, pPos, $$6, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!pPlayer.getInventory().add($$5)) {
                pPlayer.drop($$5, false);
            }
            pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.BLOCK_CHANGE, pPos);
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new ChiseledLaboratoryBookShelfBlockEntity(blockPos, blockState);
    }

    public void onRemove(BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, BlockState newBlockState, boolean movedByPiston) {
        if (!blockState.is(newBlockState.getBlock())) {
            ChiseledLaboratoryBookShelfBlockEntity bookShelfBlockEntity;
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            if (blockEntity instanceof ChiseledLaboratoryBookShelfBlockEntity && !(bookShelfBlockEntity = (ChiseledLaboratoryBookShelfBlockEntity)blockEntity).isEmpty()) {
                for (int i = 0; i < 6; ++i) {
                    ItemStack books = bookShelfBlockEntity.getItem(i);
                    if (books.isEmpty()) continue;
                    Containers.dropItemStack((Level)level, (double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), (ItemStack)books);
                }
                bookShelfBlockEntity.clearContent();
                level.updateNeighbourForOutputSignal(blockPos, (Block)this);
            }
            super.onRemove(blockState, level, blockPos, newBlockState, movedByPiston);
        }
    }

    public int getAnalogOutputSignal(@NotNull BlockState blockState, Level level, @NotNull BlockPos blockPos) {
        if (level.isClientSide()) {
            return 0;
        }
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof ChiseledLaboratoryBookShelfBlockEntity) {
            ChiseledLaboratoryBookShelfBlockEntity bookShelfBlockEntity = (ChiseledLaboratoryBookShelfBlockEntity)blockEntity;
            return bookShelfBlockEntity.getLastInteractedSlot() + 1;
        }
        return 0;
    }
}

