/*
 * Decompiled with CFR 0.152.
 */
package de.artemis.laboratoryblocks.common.blocks;

import de.artemis.laboratoryblocks.common.registration.ModItems;
import de.artemis.laboratoryblocks.common.registration.ModKeyBindings;
import de.artemis.laboratoryblocks.common.registration.ModParticles;
import de.artemis.laboratoryblocks.common.registration.ModSoundEvents;
import de.artemis.laboratoryblocks.common.util.KeyBindingUtil;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class LaboratoryBlock
extends Block {
    private final Supplier<LaboratoryBlock> block;

    public LaboratoryBlock(Supplier<LaboratoryBlock> block, BlockBehaviour.Properties properties) {
        super(properties);
        this.block = block;
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack itemStack, @NotNull BlockState blockState, @NotNull Level level, @NotNull BlockPos blockPos, Player player, @NotNull InteractionHand interactionHand, @NotNull BlockHitResult blockHitResult) {
        ItemStack itemStackInHand = player.getItemInHand(interactionHand);
        if (itemStackInHand.is((Item)ModItems.GLOWSTONE_PARTICLES.get()) || itemStackInHand.is((Item)ModItems.CONFIGURATION_TOOL.get())) {
            if (itemStackInHand.is((Item)ModItems.GLOWSTONE_PARTICLES.get()) && !((ResourceKey)blockState.getBlock().builtInRegistryHolder().unwrapKey().get()).toString().contains("enlighted")) {
                if (!player.isCreative()) {
                    itemStackInHand.shrink(1);
                }
                level.setBlock(blockPos, this.block.get().defaultBlockState(), 3);
                level.playSound(player, blockPos, SoundEvents.RESPAWN_ANCHOR_CHARGE, SoundSource.BLOCKS, 1.0f, 1.0f);
                for (float i = 0.0f; i <= 1.0f; i += 0.2f) {
                    level.addParticle((ParticleOptions)ModParticles.APPLYING_GLOWSTONE_PARTICLE.get(), (double)((float)blockPos.getX() + i), (double)blockPos.getY(), (double)blockPos.getZ(), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.APPLYING_GLOWSTONE_PARTICLE.get(), (double)((float)blockPos.getX() + i), (double)(blockPos.getY() + 1), (double)blockPos.getZ(), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.APPLYING_GLOWSTONE_PARTICLE.get(), (double)blockPos.getX(), (double)((float)blockPos.getY() + i), (double)blockPos.getZ(), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.APPLYING_GLOWSTONE_PARTICLE.get(), (double)(blockPos.getX() + 1), (double)((float)blockPos.getY() + i), (double)blockPos.getZ(), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.APPLYING_GLOWSTONE_PARTICLE.get(), (double)((float)blockPos.getX() + i), (double)blockPos.getY(), (double)(blockPos.getZ() + 1), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.APPLYING_GLOWSTONE_PARTICLE.get(), (double)((float)blockPos.getX() + i), (double)(blockPos.getY() + 1), (double)(blockPos.getZ() + 1), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.APPLYING_GLOWSTONE_PARTICLE.get(), (double)blockPos.getX(), (double)((float)blockPos.getY() + i), (double)(blockPos.getZ() + 1), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.APPLYING_GLOWSTONE_PARTICLE.get(), (double)(blockPos.getX() + 1), (double)((float)blockPos.getY() + i), (double)(blockPos.getZ() + 1), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.APPLYING_GLOWSTONE_PARTICLE.get(), (double)blockPos.getX(), (double)blockPos.getY(), (double)((float)blockPos.getZ() + i), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.APPLYING_GLOWSTONE_PARTICLE.get(), (double)(blockPos.getX() + 1), (double)blockPos.getY(), (double)((float)blockPos.getZ() + i), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.APPLYING_GLOWSTONE_PARTICLE.get(), (double)blockPos.getX(), (double)(blockPos.getY() + 1), (double)((float)blockPos.getZ() + i), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.APPLYING_GLOWSTONE_PARTICLE.get(), (double)(blockPos.getX() + 1), (double)(blockPos.getY() + 1), (double)((float)blockPos.getZ() + i), 0.0, 0.0, 0.0);
                }
                return ItemInteractionResult.SUCCESS;
            }
            if (itemStackInHand.is((Item)ModItems.CONFIGURATION_TOOL.get()) && ((ResourceKey)blockState.getBlock().builtInRegistryHolder().unwrapKey().get()).toString().contains("enlighted") && KeyBindingUtil.isKeyPressed(ModKeyBindings.REMOVE_GLOWSTONE_CONFIGURATION_TOOL_ACTION)) {
                if (!player.isCreative()) {
                    if (!player.getInventory().add(new ItemStack((ItemLike)ModItems.GLOWSTONE_PARTICLES.get()))) {
                        ItemEntity itemEntity = new ItemEntity(level, (double)((float)blockPos.getX() + 0.5f), (double)((float)blockPos.getY() + 1.0f), (double)((float)blockPos.getZ() + 0.5f), new ItemStack((ItemLike)ModItems.GLOWSTONE_PARTICLES.get()));
                        itemEntity.setDefaultPickUpDelay();
                        level.addFreshEntity((Entity)itemEntity);
                    }
                    itemStackInHand.hurtAndBreak(1, (LivingEntity)player, itemStackInHand.getEquipmentSlot());
                }
                level.setBlock(blockPos, this.block.get().defaultBlockState(), 3);
                level.playSound(player, blockPos, SoundEvents.AXE_WAX_OFF, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.playSound(player, blockPos, (SoundEvent)ModSoundEvents.CONFIGURATION_TOOL_USE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                for (float i = 0.0f; i <= 1.0f; i += 0.2f) {
                    level.addParticle((ParticleOptions)ModParticles.REMOVING_MODIFIER_PARTICLE.get(), (double)((float)blockPos.getX() + i), (double)blockPos.getY(), (double)blockPos.getZ(), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.REMOVING_MODIFIER_PARTICLE.get(), (double)((float)blockPos.getX() + i), (double)(blockPos.getY() + 1), (double)blockPos.getZ(), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.REMOVING_MODIFIER_PARTICLE.get(), (double)blockPos.getX(), (double)((float)blockPos.getY() + i), (double)blockPos.getZ(), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.REMOVING_MODIFIER_PARTICLE.get(), (double)(blockPos.getX() + 1), (double)((float)blockPos.getY() + i), (double)blockPos.getZ(), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.REMOVING_MODIFIER_PARTICLE.get(), (double)((float)blockPos.getX() + i), (double)blockPos.getY(), (double)(blockPos.getZ() + 1), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.REMOVING_MODIFIER_PARTICLE.get(), (double)((float)blockPos.getX() + i), (double)(blockPos.getY() + 1), (double)(blockPos.getZ() + 1), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.REMOVING_MODIFIER_PARTICLE.get(), (double)blockPos.getX(), (double)((float)blockPos.getY() + i), (double)(blockPos.getZ() + 1), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.REMOVING_MODIFIER_PARTICLE.get(), (double)(blockPos.getX() + 1), (double)((float)blockPos.getY() + i), (double)(blockPos.getZ() + 1), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.REMOVING_MODIFIER_PARTICLE.get(), (double)blockPos.getX(), (double)blockPos.getY(), (double)((float)blockPos.getZ() + i), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.REMOVING_MODIFIER_PARTICLE.get(), (double)(blockPos.getX() + 1), (double)blockPos.getY(), (double)((float)blockPos.getZ() + i), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.REMOVING_MODIFIER_PARTICLE.get(), (double)blockPos.getX(), (double)(blockPos.getY() + 1), (double)((float)blockPos.getZ() + i), 0.0, 0.0, 0.0);
                    level.addParticle((ParticleOptions)ModParticles.REMOVING_MODIFIER_PARTICLE.get(), (double)(blockPos.getX() + 1), (double)(blockPos.getY() + 1), (double)((float)blockPos.getZ() + i), 0.0, 0.0, 0.0);
                }
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.FAIL;
    }
}

