/*
 * Decompiled with CFR 0.152.
 */
package de.artemis.laboratoryblocks.common.data;

import de.artemis.laboratoryblocks.common.data.BlockLootTablesProvider;
import de.artemis.laboratoryblocks.common.data.FusionModelProvider;
import de.artemis.laboratoryblocks.common.data.ItemModelProvider;
import de.artemis.laboratoryblocks.common.data.LanguageProvider;
import de.artemis.laboratoryblocks.common.data.ModelAndBlockStateProvider;
import de.artemis.laboratoryblocks.common.data.RecipesProvider;
import de.artemis.laboratoryblocks.common.data.TagsProvider;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="laboratoryblocks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataProvider {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(true, (net.minecraft.data.DataProvider)new LanguageProvider(generator.getPackOutput(), "en_us"));
        generator.addProvider(event.includeServer(), (net.minecraft.data.DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(BlockLootTablesProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        generator.addProvider(event.includeServer(), (net.minecraft.data.DataProvider)new RecipesProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeClient(), (net.minecraft.data.DataProvider)new ModelAndBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (net.minecraft.data.DataProvider)new ItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(true, (net.minecraft.data.DataProvider)new TagsProvider.BlockTagsProvider(generator.getPackOutput(), lookupProvider, existingFileHelper));
        generator.addProvider(true, (net.minecraft.data.DataProvider)new TagsProvider.ItemTagsProvider(generator.getPackOutput(), lookupProvider, existingFileHelper));
        generator.addProvider(true, (net.minecraft.data.DataProvider)new FusionModelProvider(generator.getPackOutput()));
    }

    public static String getRegistryName(Item item) {
        return item.builtInRegistryHolder().key().location().toString();
    }

    public static String getRegistryName(Block block) {
        return block.builtInRegistryHolder().key().location().toString();
    }

    public static String getRawRegistryName(Item item) {
        return item.builtInRegistryHolder().key().location().getPath().toString();
    }

    public static String getRawRegistryName(Block block) {
        return block.builtInRegistryHolder().key().location().getPath().toString();
    }
}

