/*
 * Decompiled with CFR 0.152.
 */
package de.artemis.laboratoryblocks.common.data;

import de.artemis.laboratoryblocks.common.registration.ModBlocks;
import de.artemis.laboratoryblocks.common.registration.ModTags;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class TagsProvider {

    public static class ItemTagsProvider
    extends net.minecraft.data.tags.TagsProvider<Item> {
        private final PackOutput packOutput;

        protected ItemTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> future, ExistingFileHelper existingFileHelper) {
            super(packOutput, Registries.ITEM, future, "laboratoryblocks", existingFileHelper);
            this.packOutput = packOutput;
        }

        protected void addTags(@NotNull HolderLookup.Provider provider) {
            this.tag(ModTags.Item.STARCH_INGREDIENT).add(new ResourceKey[]{this.getKey(Items.SUGAR_CANE), this.getKey(Items.BEETROOT), this.getKey(Items.SUGAR), this.getKey(Items.WHEAT)});
        }

        private ResourceKey<Item> getKey(Item item) {
            return (ResourceKey)ForgeRegistries.ITEMS.getResourceKey((Object)item).get();
        }

        @NotNull
        protected Path getPath(ResourceLocation location) {
            return this.packOutput.getOutputFolder().resolve("data/" + location.getNamespace() + "/tags/item/" + location.getPath() + ".json");
        }

        @NotNull
        public String getName() {
            return "Item tags";
        }
    }

    public static class BlockTagsProvider
    extends net.minecraft.data.tags.TagsProvider<Block> {
        private final PackOutput packOutput;

        protected BlockTagsProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> future, ExistingFileHelper existingFileHelper) {
            super(packOutput, Registries.BLOCK, future, "laboratoryblocks", existingFileHelper);
            this.packOutput = packOutput;
        }

        protected void addTags(@NotNull HolderLookup.Provider provider) {
            this.tag(BlockTags.MINEABLE_WITH_PICKAXE).add(this.getKey((Block)ModBlocks.LABORATORY_LADDER.get())).add(this.getKey((Block)ModBlocks.LABORATORY_TRAPDOOR.get())).add(this.getKey((Block)ModBlocks.MESH_LABORATORY_TRAPDOOR.get())).add(this.getKey((Block)ModBlocks.GLASS_LABORATORY_TRAPDOOR.get())).add(this.getKey((Block)ModBlocks.GLASS_LABORATORY_DOOR.get())).add(this.getKey((Block)ModBlocks.MESH_LABORATORY_DOOR.get())).add(this.getKey((Block)ModBlocks.LABORATORY_DOOR.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_LABORATORY_VENT_CONNECTING.get())).add(this.getKey((Block)ModBlocks.LABORATORY_VENT_CONNECTING.get())).add(this.getKey((Block)ModBlocks.LABORATORY_FAN_REDSTONE_CONTROLLED.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_LABORATORY_FAN_REDSTONE_CONTROLLED.get())).add(this.getKey((Block)ModBlocks.LABORATORY_BLOCK.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_LABORATORY_BLOCK.get())).add(this.getKey((Block)ModBlocks.LABORATORY_TILES.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_LABORATORY_TILES.get())).add(this.getKey((Block)ModBlocks.GRAY_LABORATORY_TILES.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_GRAY_LABORATORY_TILES.get())).add(this.getKey((Block)ModBlocks.MIXED_LABORATORY_TILES.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_MIXED_LABORATORY_TILES.get())).add(this.getKey((Block)ModBlocks.LABORATORY_VENT.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_LABORATORY_VENT.get())).add(this.getKey((Block)ModBlocks.LEFT_FACED_BLUE_SIGNALING_LABORATORY_BLOCK.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_LEFT_FACED_BLUE_SIGNALING_LABORATORY_BLOCK.get())).add(this.getKey((Block)ModBlocks.RIGHT_FACED_BLUE_SIGNALING_LABORATORY_BLOCK.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_RIGHT_FACED_BLUE_SIGNALING_LABORATORY_BLOCK.get())).add(this.getKey((Block)ModBlocks.LEFT_FACED_RED_SIGNALING_LABORATORY_BLOCK.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_LEFT_FACED_RED_SIGNALING_LABORATORY_BLOCK.get())).add(this.getKey((Block)ModBlocks.RIGHT_FACED_RED_SIGNALING_LABORATORY_BLOCK.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_RIGHT_FACED_RED_SIGNALING_LABORATORY_BLOCK.get())).add(this.getKey((Block)ModBlocks.LEFT_FACED_GREEN_SIGNALING_LABORATORY_BLOCK.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_LEFT_FACED_GREEN_SIGNALING_LABORATORY_BLOCK.get())).add(this.getKey((Block)ModBlocks.RIGHT_FACED_GREEN_SIGNALING_LABORATORY_BLOCK.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_RIGHT_FACED_GREEN_SIGNALING_LABORATORY_BLOCK.get())).add(this.getKey((Block)ModBlocks.LABORATORY_FAN.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_LABORATORY_FAN.get())).add(this.getKey((Block)ModBlocks.SCREWED_LABORATORY_BLOCK.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_SCREWED_LABORATORY_BLOCK.get())).add(this.getKey((Block)ModBlocks.CLEAR_LABORATORY_SCREEN.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_CLEAR_LABORATORY_SCREEN.get())).add(this.getKey((Block)ModBlocks.WAVE_LABORATORY_SCREEN.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_WAVE_LABORATORY_SCREEN.get())).add(this.getKey((Block)ModBlocks.TEXT_LABORATORY_SCREEN.get())).add(this.getKey((Block)ModBlocks.QUANTUM_LABORATORY_SCREEN.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_QUANTUM_LABORATORY_SCREEN.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_TEXT_LABORATORY_SCREEN.get())).add(this.getKey((Block)ModBlocks.LABORATORY_PILLAR.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_LABORATORY_PILLAR.get())).add(this.getKey((Block)ModBlocks.GRAY_LABORATORY_PILLAR.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_GRAY_LABORATORY_PILLAR.get())).add(this.getKey((Block)ModBlocks.LABORATORY_BOOKSHELF.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_LABORATORY_BOOKSHELF.get())).add(this.getKey((Block)ModBlocks.CHISELED_LABORATORY_BOOKSHELF.get())).add(this.getKey((Block)ModBlocks.ENLIGHTED_CHISELED_LABORATORY_BOOKSHELF.get()));
            this.tag(BlockTags.MINEABLE_WITH_AXE).add(new ResourceKey[]{this.getKey((Block)ModBlocks.OAK_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.ENLIGHTED_OAK_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.SPRUCE_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.ENLIGHTED_SPRUCE_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.BIRCH_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.ENLIGHTED_BIRCH_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.DARK_OAK_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.ENLIGHTED_DARK_OAK_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.ACACIA_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.ENLIGHTED_ACACIA_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.JUNGLE_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.ENLIGHTED_JUNGLE_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.MANGROVE_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.ENLIGHTED_MANGROVE_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.CRIMSON_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.ENLIGHTED_CRIMSON_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.WARPED_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.ENLIGHTED_WARPED_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.OAK_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.ENLIGHTED_OAK_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.SPRUCE_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.ENLIGHTED_SPRUCE_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.BIRCH_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.ENLIGHTED_BIRCH_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.DARK_OAK_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.ENLIGHTED_DARK_OAK_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.ACACIA_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.ENLIGHTED_ACACIA_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.JUNGLE_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.ENLIGHTED_JUNGLE_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.MANGROVE_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.ENLIGHTED_MANGROVE_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.CRIMSON_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.ENLIGHTED_CRIMSON_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.WARPED_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.ENLIGHTED_WARPED_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.CHERRY_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.ENLIGHTED_CHERRY_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.CHERRY_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.ENLIGHTED_CHERRY_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.BAMBOO_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.ENLIGHTED_BAMBOO_LABORATORY_FLOOR.get()), this.getKey((Block)ModBlocks.BAMBOO_LABORATORY_TILES.get()), this.getKey((Block)ModBlocks.ENLIGHTED_BAMBOO_LABORATORY_TILES.get())});
            this.tag(BlockTags.ENCHANTMENT_POWER_PROVIDER).add(new ResourceKey[]{this.getKey((Block)ModBlocks.LABORATORY_BOOKSHELF.get()), this.getKey((Block)ModBlocks.ENLIGHTED_LABORATORY_BOOKSHELF.get())});
            this.tag(BlockTags.DOORS).add(this.getKey((Block)ModBlocks.GLASS_LABORATORY_DOOR.get())).add(this.getKey((Block)ModBlocks.MESH_LABORATORY_DOOR.get())).add(this.getKey((Block)ModBlocks.LABORATORY_DOOR.get()));
            this.tag(BlockTags.TRAPDOORS).add(this.getKey((Block)ModBlocks.LABORATORY_TRAPDOOR.get())).add(this.getKey((Block)ModBlocks.MESH_LABORATORY_TRAPDOOR.get())).add(this.getKey((Block)ModBlocks.GLASS_LABORATORY_TRAPDOOR.get()));
            this.tag(BlockTags.CLIMBABLE).add(this.getKey((Block)ModBlocks.LABORATORY_LADDER.get()));
        }

        private ResourceKey<Block> getKey(Block block) {
            return (ResourceKey)ForgeRegistries.BLOCKS.getResourceKey((Object)block).get();
        }

        @NotNull
        protected Path getPath(ResourceLocation location) {
            return this.packOutput.getOutputFolder().resolve("data/" + location.getNamespace() + "/tags/block/" + location.getPath() + ".json");
        }

        @NotNull
        public String getName() {
            return "Block tags";
        }
    }
}

