/*
 * Decompiled with CFR 0.152.
 */
package de.artemis.laboratoryblocks.common.util;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.settings.KeyModifier;
import org.lwjgl.glfw.GLFW;

public class KeyBindingUtil {
    public static boolean isKeyPressed(KeyMapping keyBinding) {
        if (keyBinding.isDown()) {
            return true;
        }
        if (keyBinding.getKeyConflictContext().isActive() && keyBinding.getKeyModifier().isActive(keyBinding.getKeyConflictContext())) {
            return KeyBindingUtil.isKeyDown(keyBinding);
        }
        return KeyModifier.isKeyCodeModifier((InputConstants.Key)keyBinding.getKey()) && KeyBindingUtil.isKeyDown(keyBinding);
    }

    private static boolean isKeyDown(KeyMapping keyBinding) {
        InputConstants.Key key = keyBinding.getKey();
        int keyCode = key.getValue();
        if (keyCode != InputConstants.UNKNOWN.getValue()) {
            long windowHandle = Minecraft.getInstance().getWindow().getWindow();
            try {
                if (key.getType() == InputConstants.Type.KEYSYM) {
                    return InputConstants.isKeyDown((long)windowHandle, (int)keyCode);
                }
                if (key.getType() == InputConstants.Type.MOUSE) {
                    return GLFW.glfwGetMouseButton((long)windowHandle, (int)keyCode) == 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

