/*
 * Decompiled with CFR 0.152.
 */
package de.artemis.laboratoryblocks.common.blockentities;

import com.mojang.logging.LogUtils;
import de.artemis.laboratoryblocks.common.blocks.ChiseledLaboratoryBookShelfBlock;
import de.artemis.laboratoryblocks.common.registration.ModBlockEntities;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ChiseledLaboratoryBookShelfBlockEntity
extends BlockEntity
implements Container {
    public static final int MAX_BOOKS_IN_STORAGE = 6;
    private static final Logger LOGGER = LogUtils.getLogger();
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)6, (Object)ItemStack.f_41583_);
    private int lastInteractedSlot = -1;
    private LazyOptional<?> itemHandler = LazyOptional.of(this::createUnSidedHandler);

    public ChiseledLaboratoryBookShelfBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.CHISELED_LABORATORY_BOOKSHELF_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    private void updateState(int slot) {
        if (slot >= 0 && slot < 6) {
            this.lastInteractedSlot = slot;
            BlockState blockstate = this.m_58900_();
            for (int i = 0; i < ChiseledLaboratoryBookShelfBlock.f_260698_.size(); ++i) {
                boolean flag = !this.m_8020_(i).m_41619_();
                BooleanProperty booleanproperty = (BooleanProperty)ChiseledLaboratoryBookShelfBlock.f_260698_.get(i);
                blockstate = (BlockState)blockstate.m_61124_((Property)booleanproperty, (Comparable)Boolean.valueOf(flag));
            }
            Objects.requireNonNull(this.f_58857_).m_7731_(this.f_58858_, blockstate, 3);
        } else {
            LOGGER.error("Expected slot 0-5, got {}", (Object)slot);
        }
    }

    public void m_142466_(CompoundTag pTag) {
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)pTag, this.items);
        this.lastInteractedSlot = pTag.m_128451_("last_interacted_slot");
    }

    protected void m_183515_(CompoundTag pTag) {
        ContainerHelper.m_18976_((CompoundTag)pTag, this.items, (boolean)true);
        pTag.m_128405_("last_interacted_slot", this.lastInteractedSlot);
    }

    public int count() {
        return (int)this.items.stream().filter(Predicate.not(ItemStack::m_41619_)).count();
    }

    public void m_6211_() {
        this.items.clear();
    }

    public int m_6643_() {
        return 6;
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int pSlot) {
        return (ItemStack)this.items.get(pSlot);
    }

    public ItemStack m_7407_(int pSlot, int pAmount) {
        ItemStack itemstack = Objects.requireNonNullElse((ItemStack)this.items.get(pSlot), ItemStack.f_41583_);
        this.items.set(pSlot, (Object)ItemStack.f_41583_);
        if (!itemstack.m_41619_()) {
            this.updateState(pSlot);
        }
        return itemstack;
    }

    public ItemStack m_8016_(int pSlot) {
        return this.m_7407_(pSlot, 1);
    }

    public void m_6836_(int pSlot, ItemStack pStack) {
        if (pStack.m_204117_(ItemTags.f_244646_)) {
            this.items.set(pSlot, (Object)pStack);
            this.updateState(pSlot);
        }
    }

    public boolean m_271862_(Container pTarget, int pIndex, ItemStack pStack) {
        return pTarget.m_216874_(p_281577_ -> {
            if (p_281577_.m_41619_()) {
                return true;
            }
            return ItemStack.m_150942_((ItemStack)pStack, (ItemStack)p_281577_) && p_281577_.m_41613_() + pStack.m_41613_() <= Math.min(p_281577_.m_41741_(), pTarget.m_6893_());
        });
    }

    public int m_6893_() {
        return 1;
    }

    public boolean m_6542_(Player pPlayer) {
        return Container.m_272074_((BlockEntity)this, (Player)pPlayer);
    }

    public boolean m_7013_(int pIndex, ItemStack pStack) {
        return pStack.m_204117_(ItemTags.f_244646_) && this.m_8020_(pIndex).m_41619_();
    }

    public int getLastInteractedSlot() {
        return this.lastInteractedSlot;
    }

    protected IItemHandler createUnSidedHandler() {
        return new InvWrapper((Container)this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        return !this.f_58859_ && cap == ForgeCapabilities.ITEM_HANDLER ? this.itemHandler.cast() : super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemHandler.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.itemHandler = LazyOptional.of(this::createUnSidedHandler);
    }
}

