/*
 * Decompiled with CFR 0.152.
 */
package de.artemis.laboratoryblocks.common.data;

import de.artemis.laboratoryblocks.common.data.BlockLootTablesProvider;
import de.artemis.laboratoryblocks.common.data.FusionModelProvider;
import de.artemis.laboratoryblocks.common.data.ItemModelProvider;
import de.artemis.laboratoryblocks.common.data.LanguageProvider;
import de.artemis.laboratoryblocks.common.data.ModelAndBlockStateProvider;
import de.artemis.laboratoryblocks.common.data.RecipesProvider;
import de.artemis.laboratoryblocks.common.data.TagsProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="laboratoryblocks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataProvider {
    @SubscribeEvent
    public static void onDataGen(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture future = event.getLookupProvider();
        generator.addProvider(true, (net.minecraft.data.DataProvider)new ModelAndBlockStateProvider(generator.getPackOutput(), existingFileHelper));
        generator.addProvider(true, (net.minecraft.data.DataProvider)new ItemModelProvider(generator.getPackOutput(), existingFileHelper));
        generator.addProvider(true, (net.minecraft.data.DataProvider)new LanguageProvider(generator.getPackOutput(), "en_us"));
        generator.addProvider(true, (net.minecraft.data.DataProvider)new BlockLootTablesProvider(generator.getPackOutput()));
        generator.addProvider(true, (net.minecraft.data.DataProvider)new RecipesProvider(generator.getPackOutput()));
        generator.addProvider(true, (net.minecraft.data.DataProvider)new TagsProvider.BlockTagsProvider(generator.getPackOutput(), future, existingFileHelper));
        generator.addProvider(true, (net.minecraft.data.DataProvider)new TagsProvider.ItemTagsProvider(generator.getPackOutput(), future, existingFileHelper));
        generator.addProvider(true, (net.minecraft.data.DataProvider)new FusionModelProvider(generator.getPackOutput()));
    }

    public static String getRegistryName(Item item) {
        return item.m_204114_().m_205785_().m_135782_().toString();
    }

    public static String getRegistryName(Block block) {
        return block.m_204297_().m_205785_().m_135782_().toString();
    }

    public static String getRawRegistryName(Item item) {
        return item.m_204114_().m_205785_().m_135782_().m_135815_().toString();
    }

    public static String getRawRegistryName(Block block) {
        return block.m_204297_().m_205785_().m_135782_().m_135815_().toString();
    }
}

