/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.init.SoundsInit;
import com.mcwwindows.kikoz.objects.WindowBase;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Blinds
extends WindowBase {
    private static final EnumProperty<GaragePart> PART = EnumProperty.create((String)"part", GaragePart.class);
    private static final EnumProperty<BlindsState> BLINDSSTATE = EnumProperty.create((String)"blindsstate", BlindsState.class);
    String infoname;
    boolean hasTextInfo = true;
    protected static final VoxelShape WEST = Shapes.or((VoxelShape)Blinds.box((double)12.0, (double)0.0, (double)0.0, (double)15.9, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape SOUTH = Shapes.or((VoxelShape)Blinds.box((double)0.0, (double)0.0, (double)0.1, (double)16.0, (double)16.0, (double)4.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape EAST = Shapes.or((VoxelShape)Blinds.box((double)0.1, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[0]);
    protected static final VoxelShape NORTH = Shapes.or((VoxelShape)Blinds.box((double)0.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0, (double)15.9), (VoxelShape[])new VoxelShape[0]);

    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                return NORTH;
            }
            case SOUTH: {
                return SOUTH;
            }
            case EAST: {
                return EAST;
            }
            case WEST: {
                return WEST;
            }
        }
        return null;
    }

    public Blinds(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(BLINDSSTATE, (Comparable)((Object)BlindsState.OPEN))).setValue(PART, (Comparable)((Object)GaragePart.BOTTOM)));
    }

    @Override
    protected BlockState WindowState(BlockState state, LevelReader level, BlockPos pos) {
        boolean below;
        boolean above = level.getBlockState(pos.above()).getBlock() == this;
        boolean bl = below = level.getBlockState(pos.below()).getBlock() == this;
        if (above && below) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)GaragePart.BOTTOM));
        }
        if (!above && below) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)GaragePart.TOP));
        }
        if (above && !below) {
            return (BlockState)state.setValue(PART, (Comparable)((Object)GaragePart.BOTTOM));
        }
        return (BlockState)state.setValue(PART, (Comparable)((Object)GaragePart.TOP));
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.WindowState(super.getStateForPlacement(context), (LevelReader)context.getLevel(), context.getClickedPos()).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, FACING, BLINDSSTATE});
    }

    public InteractionResult useItemOn(ItemStack itemstack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Item item = itemstack.getItem();
        if (item != this.asItem()) {
            BlindsState currentState = (BlindsState)((Object)state.getValue(BLINDSSTATE));
            BlindsState nextState = this.cycleBlindsState(currentState);
            worldIn.playSound(null, pos, (SoundEvent)SoundsInit.BLINDS_CLOSE.get(), SoundSource.BLOCKS, 0.5f, worldIn.random.nextFloat() * 0.1f + 0.8f);
            this.toggleBlinds(worldIn, pos, nextState, (Direction)state.getValue((Property)FACING), 1000);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public int getLightBlock(BlockState state, BlockGetter reader, BlockPos pos) {
        BlindsState currentState = (BlindsState)((Object)state.getValue(BLINDSSTATE));
        if (currentState == BlindsState.CLOSED) {
            return 15;
        }
        return 0;
    }

    private void toggleBlinds(Level world, BlockPos pos, BlindsState targetState, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() != this) {
            return;
        }
        BlindsState currentState = (BlindsState)((Object)state.getValue(BLINDSSTATE));
        if (currentState != targetState) {
            BlockPos[] positions;
            world.setBlockAndUpdate(pos, (BlockState)state.setValue(BLINDSSTATE, (Comparable)((Object)targetState)));
            for (BlockPos newPos : positions = new BlockPos[]{pos.south(), pos.north(), pos.east(), pos.west(), pos.below(), pos.above()}) {
                this.toggleBlinds(world, newPos, targetState, targetDirection, depth - 1);
            }
        }
    }

    private BlindsState cycleBlindsState(BlindsState currentState) {
        switch (currentState.ordinal()) {
            case 0: {
                return BlindsState.OPEN;
            }
            case 1: {
                return BlindsState.RAISED;
            }
        }
        return BlindsState.CLOSED;
    }

    protected void spawnDestroyParticles(Level level, Player player, BlockPos pos, BlockState state) {
        BlindsState raised = (BlindsState)((Object)state.getValue(BLINDSSTATE));
        GaragePart part = (GaragePart)((Object)state.getValue(PART));
        if (raised == BlindsState.RAISED && part == GaragePart.BOTTOM) {
            return;
        }
        level.levelEvent((Entity)player, 2001, pos, Blinds.getId((BlockState)state));
    }

    public static enum BlindsState implements StringRepresentable
    {
        CLOSED("closed"),
        OPEN("open"),
        RAISED("raised");

        private final String name;

        private BlindsState(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }

    public static enum GaragePart implements StringRepresentable
    {
        TOP("top"),
        BOTTOM("bottom");

        private final String name;

        private GaragePart(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

