/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.init.SoundsInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class Shutter
extends Block {
    protected static final VoxelShape SOUTH_LEFT = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)11.0);
    protected static final VoxelShape SOUTH_RIGHT = Block.box((double)14.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_LEFT = Block.box((double)5.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_RIGHT = Block.box((double)0.0, (double)0.0, (double)14.0, (double)11.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_LEFT = Block.box((double)0.0, (double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)2.0);
    protected static final VoxelShape EAST_RIGHT = Block.box((double)5.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape NORTH_LEFT = Block.box((double)0.0, (double)0.0, (double)5.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_RIGHT = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)11.0);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.DOOR_HINGE;

    public Shutter(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)OPEN, (Comparable)Boolean.valueOf(false))).setValue(HINGE, (Comparable)DoorHingeSide.LEFT));
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        DoorHingeSide hinge = (DoorHingeSide)state.getValue(HINGE);
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                if (hinge == DoorHingeSide.RIGHT) {
                    return NORTH_RIGHT;
                }
                return NORTH_LEFT;
            }
            case SOUTH: {
                if (hinge == DoorHingeSide.RIGHT) {
                    return SOUTH_RIGHT;
                }
                return SOUTH_LEFT;
            }
            case WEST: {
                if (hinge == DoorHingeSide.RIGHT) {
                    return WEST_RIGHT;
                }
                return WEST_LEFT;
            }
        }
        if (hinge == DoorHingeSide.RIGHT) {
            return EAST_RIGHT;
        }
        return EAST_LEFT;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter getter, BlockPos pos) {
        return Shapes.empty();
    }

    public ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Item item = itemstack.getItem();
        if (item == this.asItem()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        this.toggleShutter(level, pos, (Boolean)state.getValue((Property)OPEN) == false, (Direction)state.getValue((Property)FACING), 100);
        level.playSound(null, pos, (SoundEvent)SoundsInit.WINDOW_OPEN.get(), SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.8f);
        state = (BlockState)state.cycle((Property)OPEN);
        level.setBlock(pos, state, 2);
        return ItemInteractionResult.SUCCESS;
    }

    private DoorHingeSide getHinge(BlockPlaceContext context) {
        BlockPos blockpos = context.getClickedPos();
        Direction direction = context.getHorizontalDirection();
        int j = direction.getStepX();
        int k = direction.getStepZ();
        Vec3 vector3d = context.getClickLocation();
        double d0 = vector3d.x - (double)blockpos.getX();
        double d1 = vector3d.z - (double)blockpos.getZ();
        return !(j < 0 && d1 < 0.5 || j > 0 && d1 > 0.5 || k < 0 && d0 > 0.5 || k > 0 && d0 < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(HINGE, (Comparable)this.getHinge(context))).setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getClockWise());
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, OPEN, HINGE});
    }

    public BlockState updateShape(BlockState state, Direction dir, BlockState statetwo, LevelAccessor access, BlockPos pos, BlockPos postwo) {
        return super.updateShape(state, dir, statetwo, access, pos, postwo);
    }

    private void toggleShutter(Level world, BlockPos pos, boolean targetOpen, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = world.getBlockState(pos);
        if (state.getBlock() != this) {
            return;
        }
        boolean open = (Boolean)state.getValue((Property)OPEN);
        Direction direction = (Direction)state.getValue((Property)FACING);
        if (open != targetOpen && direction.equals((Object)targetDirection)) {
            BlockPos[] positions;
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(targetOpen)));
            for (BlockPos newPos : positions = new BlockPos[]{pos.south(1), pos.north(1), pos.east(1), pos.west(1), pos.below(1), pos.below(2), pos.above(1)}) {
                this.toggleShutter(world, newPos, targetOpen, targetDirection, depth - 2);
            }
        }
    }
}

