/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.block.custom;

import com.lumengrid.oritechthings.block.ModBlocks;
import com.lumengrid.oritechthings.entity.custom.AcceleratorMagneticFieldBlockEntity;
import com.lumengrid.oritechthings.main.ConfigLoader;
import dev.architectury.registry.menu.ExtendedMenuProvider;
import dev.architectury.registry.menu.MenuRegistry;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.api.energy.EnergyApi;
import rearth.oritech.block.base.entity.ExpandableEnergyStorageBlockEntity;
import rearth.oritech.util.ComparatorOutputProvider;
import rearth.oritech.util.MachineAddonController;

public class AcceleratorMagneticFieldBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty TARGET_DIR = DirectionProperty.create((String)"target_dir");

    public AcceleratorMagneticFieldBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(3.0f, 6.0f).requiresCorrectToolForDrops().noOcclusion());
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)TARGET_DIR, (Comparable)Direction.NORTH));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TARGET_DIR});
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext ctx) {
        return (BlockState)Objects.requireNonNull(super.getStateForPlacement(ctx)).setValue((Property)TARGET_DIR, (Comparable)ctx.getNearestLookingDirection().getOpposite());
    }

    @NotNull
    public RenderShape getRenderShape(@NotNull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new AcceleratorMagneticFieldBlockEntity(pos, state);
    }

    protected boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    protected int getAnalogOutputSignal(@NotNull BlockState state, Level world, @NotNull BlockPos pos) {
        return ((ComparatorOutputProvider)Objects.requireNonNull(world.getBlockEntity(pos))).getComparatorOutput();
    }

    public boolean isSignalSource(@NotNull BlockState state) {
        return true;
    }

    public void neighborChanged(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Block sourceBlock, @NotNull BlockPos sourcePos, boolean notify) {
        super.neighborChanged(state, world, pos, sourceBlock, sourcePos, notify);
        if (world.isClientSide) {
            return;
        }
        boolean isPowered = world.hasNeighborSignal(pos);
        ExpandableEnergyStorageBlockEntity storageEntity = (ExpandableEnergyStorageBlockEntity)world.getBlockEntity(pos);
        assert (storageEntity != null);
        storageEntity.setRedstonePowered(isPowered);
    }

    @NotNull
    public InteractionResult useWithoutItem(@NotNull BlockState state, Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        if (!world.isClientSide) {
            BlockEntity entity = world.getBlockEntity(pos);
            if (!(entity instanceof MachineAddonController)) {
                return InteractionResult.SUCCESS;
            }
            MachineAddonController machineEntity = (MachineAddonController)entity;
            machineEntity.initAddons();
            ExtendedMenuProvider handler = (ExtendedMenuProvider)world.getBlockEntity(pos);
            MenuRegistry.openExtendedMenu((ServerPlayer)((ServerPlayer)player), (ExtendedMenuProvider)handler);
        }
        return InteractionResult.SUCCESS;
    }

    @NotNull
    protected List<ItemStack> getDrops(@NotNull BlockState state, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull LootParams.Builder builder) {
        List droppedStacks = super.getDrops(state, builder);
        BlockEntity blockEntity = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (blockEntity instanceof AcceleratorMagneticFieldBlockEntity) {
            AcceleratorMagneticFieldBlockEntity storageEntity = (AcceleratorMagneticFieldBlockEntity)blockEntity;
            droppedStacks.addAll(storageEntity.inventory.getHeldStacks());
            storageEntity.inventory.clearContent();
        }
        return droppedStacks;
    }

    @NotNull
    private static ItemStack getStackWithData(LevelReader world, BlockPos pos) {
        ItemStack stack = new ItemStack((ItemLike)((Block)ModBlocks.ACCELERATOR_MAGNETIC_FIELD.get()).asItem());
        AcceleratorMagneticFieldBlockEntity storageEntity = (AcceleratorMagneticFieldBlockEntity)world.getBlockEntity(pos);
        assert (storageEntity != null);
        if (storageEntity.getEnergyStorage(null).getAmount() > 0L) {
            stack.set(EnergyApi.ITEM.getEnergyComponent(), (Object)storageEntity.getEnergyStorage(null).getAmount());
        }
        return stack;
    }

    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        long storedEnergyInStack = (Long)itemStack.getOrDefault(EnergyApi.ITEM.getEnergyComponent(), (Object)0L);
        if (storedEnergyInStack > 0L) {
            ExpandableEnergyStorageBlockEntity storageEntity = (ExpandableEnergyStorageBlockEntity)world.getBlockEntity(pos);
            assert (storageEntity != null);
            storageEntity.energyStorage.setAmount(storedEnergyInStack);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@NotNull Level world, @NotNull BlockState state, @NotNull BlockEntityType<T> type) {
        return (world1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof BlockEntityTicker) {
                BlockEntityTicker ticker = (BlockEntityTicker)blockEntity;
                ticker.tick(world1, pos, state1, blockEntity);
            }
        };
    }

    @NotNull
    public BlockState playerWillDestroy(Level world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        BlockEntity entity;
        if (!world.isClientSide && (entity = world.getBlockEntity(pos)) instanceof MachineAddonController) {
            MachineAddonController machineEntity = (MachineAddonController)entity;
            machineEntity.resetAddons();
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void appendHoverText(@NotNull ItemStack stack, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, TooltipFlag options) {
        if (!ConfigLoader.getInstance().magneticFieldSettings.enabled()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.accelerator_magnetic_field_disabled").withStyle(ChatFormatting.RED));
            return;
        }
        tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.accelerator_magnetic_field").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.accelerator_magnetic_field_desc").withStyle(ChatFormatting.DARK_GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.accelerator_magnetic_field_limitation").withStyle(ChatFormatting.RED));
        tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.accelerator_magnetic_field_addon_info").withStyle(ChatFormatting.GOLD));
        tooltip.add((Component)Component.empty());
        if (Screen.hasControlDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.accelerator_magnetic_field.target_designator_usage"));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.accelerator_magnetic_field.target_designator_step1"));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.accelerator_magnetic_field.target_designator_step2"));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.accelerator_magnetic_field.target_designator_step3"));
            tooltip.add((Component)Component.translatable((String)"tooltip.oritechthings.accelerator_magnetic_field.target_designator_benefit"));
        } else {
            tooltip.add((Component)Component.translatable((String)"tooltip.oritech.item_extra_info").withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC));
        }
    }
}

