/*
 * Decompiled with CFR 0.152.
 */
package com.lumengrid.oritechthings.network.packet;

import io.netty.buffer.ByteBuf;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.init.BlockContent;

public record FramePlacerPacket(BlockPos startPos, int xDimension, int yDimension, int offset, Direction facing) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FramePlacerPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"oritechthings", (String)"frame_placer"));
    public static final StreamCodec<ByteBuf, FramePlacerPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, FramePlacerPacket::startPos, (StreamCodec)ByteBufCodecs.INT, FramePlacerPacket::xDimension, (StreamCodec)ByteBufCodecs.INT, FramePlacerPacket::yDimension, (StreamCodec)ByteBufCodecs.INT, FramePlacerPacket::offset, (StreamCodec)Direction.STREAM_CODEC, FramePlacerPacket::facing, FramePlacerPacket::new);

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handleDataOnServer(FramePlacerPacket packet, IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sPlayer = (ServerPlayer)player;
        ServerLevel level = sPlayer.serverLevel();
        BlockPos startPos = FramePlacerPacket.getOffsetPosition(packet.facing, packet.startPos, -packet.offset, 0);
        BlockPos playerPos = sPlayer.blockPosition();
        Direction playerFacing = sPlayer.getDirection();
        for (int x = 0; x < packet.xDimension; ++x) {
            for (int y = 0; y < packet.yDimension; ++y) {
                BlockPos currentPos = FramePlacerPacket.getOffsetPosition(packet.facing, startPos, x, y);
                BlockState state = level.getBlockState(currentPos);
                boolean isPerimeter = FramePlacerPacket.isPerimeter(x, y, packet.xDimension, packet.yDimension);
                if (isPerimeter && state.is(BlockContent.MACHINE_FRAME_BLOCK)) continue;
                if (!state.isAir()) {
                    level.destroyBlock(currentPos, false);
                    FramePlacerPacket.dropBlockInFrontOfPlayer(level, playerPos, playerFacing, state);
                }
                if (!isPerimeter || FramePlacerPacket.placeFrameBlock(sPlayer, level, currentPos)) continue;
                return;
            }
        }
    }

    private static void dropBlockInFrontOfPlayer(ServerLevel level, BlockPos playerPos, Direction playerFacing, BlockState blockState) {
        ItemStack blockItem = new ItemStack((ItemLike)blockState.getBlock());
        BlockPos dropPos = playerPos.offset(playerFacing.getNormal());
        dropPos = dropPos.above();
        ItemEntity itemEntity = new ItemEntity((Level)level, (double)dropPos.getX(), (double)dropPos.getY(), (double)dropPos.getZ(), blockItem);
        level.addFreshEntity((Entity)itemEntity);
    }

    private static BlockPos getOffsetPosition(Direction facing, BlockPos startPos, int x, int y) {
        return switch (facing) {
            case Direction.NORTH -> startPos.offset(x, 0, -y);
            case Direction.WEST -> startPos.offset(-y, 0, -x);
            case Direction.EAST -> startPos.offset(y, 0, x);
            case Direction.SOUTH -> startPos.offset(-x, 0, y);
            default -> startPos.offset(x, 0, y);
        };
    }

    private static boolean isPerimeter(int x, int y, int xDimension, int yDimension) {
        return x == 0 || x == xDimension - 1 || y == 0 || y == yDimension - 1;
    }

    private static boolean placeFrameBlock(ServerPlayer player, ServerLevel level, BlockPos pos) {
        if (player.isCreative()) {
            BlockState frameBlockState = BlockContent.MACHINE_FRAME_BLOCK.defaultBlockState();
            level.setBlockAndUpdate(pos, frameBlockState);
            return true;
        }
        ItemStack frameBlockItem = FramePlacerPacket.findFrameBlockInInventory(player);
        if (frameBlockItem.isEmpty()) {
            player.sendSystemMessage((Component)Component.translatable((String)"message.oritechthings.frame_placer.missing_frame").withStyle(ChatFormatting.RED));
            return false;
        }
        BlockState frameBlockState = Block.byItem((Item)frameBlockItem.getItem()).defaultBlockState();
        level.setBlockAndUpdate(pos, frameBlockState);
        frameBlockItem.shrink(1);
        return true;
    }

    private static ItemStack findFrameBlockInInventory(ServerPlayer player) {
        for (ItemStack stack : player.getInventory().items) {
            if (stack.getItem() != BlockContent.MACHINE_FRAME_BLOCK.asItem()) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }
}

